/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.js.require;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RequireJsGenerator {
    private ModuleInfo moduleInfo;
    private Map<String, Object> requireConfig;
    private HashMap<String, String> dependencies = new HashMap();
    private static final JSONParser parser = new JSONParser();

    public static RequireJsGenerator parsePom(InputStream inputStream) throws IOException, ParserConfigurationException, SAXException, XPathExpressionException, ParseException {
        byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
        Document pom = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(bytes));
        return new RequireJsGenerator(pom);
    }

    public static RequireJsGenerator processJsScript(String moduleName, String moduleVersion, InputStream inputStream) throws IOException, NoSuchMethodException, ScriptException, ParseException {
        byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
        return new RequireJsGenerator(moduleName, moduleVersion, new String(bytes, "UTF-8"));
    }

    public static RequireJsGenerator parseJsonPackage(InputStream inputStream) throws IOException, ParseException {
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            Map json = (Map)parser.parse((Reader)bufferedReader);
            return new RequireJsGenerator(json);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static RequireJsGenerator emptyGenerator(String physicalPathNamePart, String physicalPathVersionPart) {
        return new RequireJsGenerator(physicalPathNamePart, physicalPathVersionPart);
    }

    private RequireJsGenerator(Document pom) throws XPathExpressionException, ParseException {
        this.requirejsFromPom(pom);
    }

    private RequireJsGenerator(String moduleName, String moduleVersion, String jsScript) throws NoSuchMethodException, ScriptException, ParseException, IOException {
        this.requirejsFromJs(moduleName, moduleVersion, jsScript);
    }

    private RequireJsGenerator(Map<String, Object> json) {
        this.requirejsFromJson(json);
    }

    private RequireJsGenerator(String moduleName, String moduleVersion) {
        this.moduleInfo = new ModuleInfo(moduleName, moduleVersion);
        HashMap<String, String> paths = new HashMap<String, String>();
        paths.put(moduleName, "");
        this.requireConfig = new HashMap<String, Object>();
        this.requireConfig.put("paths", paths);
    }

    public ModuleInfo getConvertedConfig(ArtifactInfo artifactInfo) throws ParseException {
        return this.getConvertedConfig(artifactInfo, true, null);
    }

    public ModuleInfo getConvertedConfig(ArtifactInfo artifactInfo, boolean isAmdPackage, String exports) throws ParseException {
        this.moduleInfo.setAmdPackage(isAmdPackage);
        this.moduleInfo.setExports(exports);
        HashMap<String, String> artifactModules = new HashMap<String, String>();
        Map<String, Object> convertedConfig = this.modifyConfigPaths(artifactModules);
        HashMap<String, HashMap<String, String>> artifactVersion = new HashMap<String, HashMap<String, String>>();
        artifactVersion.put(artifactInfo.getVersion(), artifactModules);
        HashMap<String, HashMap<String, HashMap<String, String>>> artifacts = new HashMap<String, HashMap<String, HashMap<String, String>>>();
        artifacts.put(artifactInfo.getGroup() + "/" + artifactInfo.getArtifactId(), artifactVersion);
        HashMap<String, HashMap<String, Object>> meta = new HashMap<String, HashMap<String, Object>>();
        meta.put("modules", this.moduleInfo.getModules());
        meta.put("artifacts", artifacts);
        convertedConfig.put("requirejs-osgi-meta", meta);
        this.moduleInfo.setRequireJs(convertedConfig);
        return this.moduleInfo;
    }

    private void requirejsFromPom(Document pom) throws XPathExpressionException, ParseException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        Element document = pom.getDocumentElement();
        this.moduleInfo = new ModuleInfo((String)xPath.evaluate("/project/artifactId", document, XPathConstants.STRING), (String)xPath.evaluate("/project/version", document, XPathConstants.STRING));
        String pomConfig = (String)xPath.evaluate("/project/properties/requirejs", document, XPathConstants.STRING);
        this.requireConfig = (Map)parser.parse(pomConfig);
        NodeList pomDependencies = (NodeList)xPath.evaluate("/project/dependencies/dependency[contains(groupId, 'org.webjars')]", document, XPathConstants.NODESET);
        int ic = pomDependencies.getLength();
        for (int i = 0; i != ic; ++i) {
            Node dependency = pomDependencies.item(i);
            NodeList dependencyChildNodes = dependency.getChildNodes();
            String dependencyGroupId = null;
            String dependencyArtifactId = null;
            String dependencyVersion = null;
            int jc = dependencyChildNodes.getLength();
            for (int j = 0; j != jc; ++j) {
                Node item = dependencyChildNodes.item(j);
                String nodeName = item.getNodeName();
                if (nodeName.equals("groupId")) {
                    dependencyGroupId = item.getChildNodes().item(0).getNodeValue();
                }
                if (nodeName.equals("artifactId")) {
                    dependencyArtifactId = item.getChildNodes().item(0).getNodeValue();
                }
                if (!nodeName.equals("version")) continue;
                dependencyVersion = item.getChildNodes().item(0).getNodeValue();
            }
            this.dependencies.put("mvn:" + dependencyGroupId + "/" + dependencyArtifactId, dependencyVersion);
        }
    }

    private void requirejsFromJs(String moduleName, String moduleVersion, String jsScript) throws IOException, ScriptException, NoSuchMethodException, ParseException {
        this.moduleInfo = new ModuleInfo(moduleName, moduleVersion);
        Pattern pat = Pattern.compile("webjars!(.*).js");
        Matcher m = pat.matcher(jsScript);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, m.group(1));
        }
        m.appendTail(sb);
        jsScript = sb.toString();
        pat = Pattern.compile("webjars\\.path\\(['\"]{1}(.*)['\"]{1}, (['\"]{0,1}[^\\)]+['\"]{0,1})\\)");
        m = pat.matcher(jsScript);
        while (m.find()) {
            m.appendReplacement(sb, m.group(2));
        }
        m.appendTail(sb);
        jsScript = sb.toString();
        ScriptEngineManager factory = new ScriptEngineManager();
        ScriptEngine engine = factory.getEngineByName("JavaScript");
        String script = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/org/pentaho/js/require/require-js-aggregator.js"));
        script = script.replace("{{EXTERNAL_CONFIG}}", jsScript);
        engine.eval(script);
        this.requireConfig = (Map)parser.parse(((Invocable)((Object)engine)).invokeFunction("processConfig", "").toString());
    }

    private void requirejsFromJson(Map<String, Object> json) {
        List<Object> packages;
        this.moduleInfo = new ModuleInfo((String)json.get("name"), (String)json.get("version"));
        if (json.containsKey("path")) {
            this.moduleInfo.setPath((String)json.get("path"));
        }
        Map paths = json.containsKey("paths") ? (Map)json.get("paths") : new HashMap();
        paths.put(this.moduleInfo.getName(), this.moduleInfo.getPath());
        Map map = json.containsKey("map") ? (Map)json.get("map") : new HashMap();
        Object pck = this.extractPackage(json, this.moduleInfo.getName(), paths, map);
        this.requireConfig = new HashMap<String, Object>();
        if (!map.isEmpty()) {
            HashMap<String, HashMap<String, Object>> topmap = new HashMap<String, HashMap<String, Object>>();
            topmap.put(this.moduleInfo.getName(), (HashMap<String, Object>)map);
            this.requireConfig.put("map", topmap);
        }
        if (json.containsKey("dependencies")) {
            HashMap deps = (HashMap)json.get("dependencies");
            Set depsKeySet = deps.keySet();
            for (String key : depsKeySet) {
                this.dependencies.put(key, (String)deps.get(key));
            }
        }
        this.requireConfig.put("paths", paths);
        List list = packages = json.containsKey("packages") ? (List)json.get("packages") : new ArrayList();
        if (pck != null) {
            packages.add(pck);
        }
        if (!packages.isEmpty()) {
            this.requireConfig.put("packages", packages);
        }
        if (json.containsKey("config")) {
            this.requireConfig.put("config", json.get("config"));
        }
    }

    private Object extractPackage(Map<String, Object> json, String moduleName, Map<String, Object> paths, Map<String, Object> map) {
        Object value;
        Object pck = null;
        if (json.containsKey("main")) {
            value = json.get("main");
            if (value instanceof String) {
                pck = this.packageFromFilename((String)value);
            } else if (value instanceof List) {
                List files = (List)value;
                for (Object file : files) {
                    Object pack = this.packageFromFilename((String)file);
                    if (pack == null) continue;
                    pck = pack;
                    break;
                }
            }
        }
        if (json.containsKey("browser")) {
            value = json.get("browser");
            if (value instanceof String) {
                pck = this.packageFromFilename((String)value);
            } else if (value instanceof Map) {
                Map overridePaths = (Map)value;
                for (String overridePath : overridePaths.keySet()) {
                    String replaceValue;
                    Object replaceRawValue = overridePaths.get(overridePath);
                    if (replaceRawValue instanceof String) {
                        replaceValue = (String)replaceRawValue;
                        if (replaceValue.startsWith("./")) {
                            replaceValue = replaceValue.substring(2);
                        }
                        replaceValue = FilenameUtils.removeExtension((String)replaceValue);
                    } else {
                        replaceValue = "no-where-to-be-found";
                    }
                    if (overridePath.startsWith("./")) {
                        paths.put(FilenameUtils.removeExtension((String)overridePath), replaceValue);
                        continue;
                    }
                    map.put(FilenameUtils.removeExtension((String)overridePath), replaceValue);
                }
            }
        }
        return pck;
    }

    private Object packageFromFilename(String file) {
        if (file.startsWith("./")) {
            file = file.substring(2);
        } else if (file.startsWith("/")) {
            file = file.substring(1);
        }
        if (FilenameUtils.getExtension((String)file).equals("js")) {
            if (file.equals("main.js")) {
                return "";
            }
            String filename = FilenameUtils.removeExtension((String)file);
            HashMap<String, String> pck = new HashMap<String, String>();
            pck.put("name", "");
            if (!this.moduleInfo.getPath().isEmpty()) {
                pck.put("location", this.moduleInfo.getPath());
            }
            pck.put("main", filename);
            return pck;
        }
        return null;
    }

    private Map<String, Object> modifyConfigPaths(HashMap<String, String> artifactModules) throws ParseException {
        HashMap map;
        HashMap shim;
        List packages;
        HashMap paths;
        HashMap<String, Object> requirejs = new HashMap<String, Object>();
        HashMap<String, String> keyMap = new HashMap<String, String>();
        HashMap<String, Object> moduleDetails = new HashMap<String, Object>();
        if (this.dependencies != null && !this.dependencies.isEmpty()) {
            moduleDetails.put("dependencies", this.dependencies);
        }
        boolean isAmdPackage = this.moduleInfo.isAmdPackage();
        moduleDetails.put("isAmdPackage", isAmdPackage);
        if (!isAmdPackage && this.moduleInfo.getExports() != null) {
            moduleDetails.put("exports", this.moduleInfo.getExports());
        }
        if ((paths = (HashMap)this.requireConfig.get("paths")) != null) {
            HashMap<String, String> convertedPaths = new HashMap<String, String>();
            for (String key : paths.keySet()) {
                String versionedKey;
                if (key.startsWith("./")) {
                    versionedKey = this.moduleInfo.getVersionedName() + key.substring(1);
                } else {
                    versionedKey = key + "_" + this.moduleInfo.getVersion();
                    HashMap<String, HashMap<String, Object>> module = new HashMap<String, HashMap<String, Object>>();
                    module.put(this.moduleInfo.getVersion(), moduleDetails);
                    this.moduleInfo.addModuleId(key, module);
                    artifactModules.put(key, this.moduleInfo.getVersion());
                }
                keyMap.put(key, versionedKey);
                String path = (String)paths.get(key);
                if (path.length() > 0) {
                    if (path.startsWith("/")) {
                        convertedPaths.put(versionedKey, path);
                        continue;
                    }
                    convertedPaths.put(versionedKey, this.moduleInfo.getVersionedPath() + "/" + path);
                    continue;
                }
                convertedPaths.put(versionedKey, this.moduleInfo.getVersionedPath());
            }
            requirejs.put("paths", convertedPaths);
        }
        if ((packages = (List)this.requireConfig.get("packages")) != null && !packages.isEmpty()) {
            moduleDetails.put("packages", SerializationUtils.clone((Serializable)((Serializable)((Object)packages))));
            ArrayList<String> convertedPackages = new ArrayList<String>();
            for (Object pack : packages) {
                if (pack instanceof String) {
                    String convertedName;
                    String packageName = (String)pack;
                    if (!packageName.isEmpty()) {
                        convertedName = this.moduleInfo.getVersionedName() + "/" + packageName;
                    } else {
                        packageName = this.moduleInfo.getName();
                        convertedName = this.moduleInfo.getVersionedName();
                    }
                    keyMap.put(packageName, convertedName);
                    keyMap.put(packageName + "/main", convertedName + "/main");
                    convertedPackages.add(convertedName);
                    continue;
                }
                if (!(pack instanceof HashMap)) continue;
                HashMap packageObj = (HashMap)pack;
                if (((HashMap)pack).containsKey("name")) {
                    String convertedName;
                    String mainScript;
                    String packageName = (String)packageObj.get("name");
                    String string = mainScript = ((HashMap)pack).containsKey("main") ? (String)packageObj.get("main") : "main";
                    if (!packageName.isEmpty()) {
                        convertedName = this.moduleInfo.getVersionedName() + "/" + packageName;
                    } else {
                        packageName = this.moduleInfo.getName();
                        convertedName = this.moduleInfo.getVersionedName();
                    }
                    keyMap.put(packageName, convertedName);
                    keyMap.put(packageName + "/" + mainScript, convertedName + "/" + mainScript);
                    packageObj.put("name", convertedName);
                }
                convertedPackages.add((String)pack);
            }
            requirejs.put("packages", convertedPackages);
        }
        if ((shim = (HashMap)this.requireConfig.get("shim")) != null) {
            requirejs.put("shim", this.convertSubConfig(keyMap, shim));
        }
        if ((map = (HashMap)this.requireConfig.get("map")) != null) {
            requirejs.put("map", this.convertSubConfig(keyMap, map));
        }
        if (this.requireConfig.containsKey("config")) {
            requirejs.put("config", this.requireConfig.get("config"));
        }
        return requirejs;
    }

    private HashMap<String, ?> convertSubConfig(HashMap<String, String> keyMap, HashMap<String, ?> subConfig) {
        HashMap convertedSubConfig = new HashMap();
        if (subConfig != null) {
            for (String key : subConfig.keySet()) {
                String versionedKey = keyMap.get(key);
                if (versionedKey != null) {
                    convertedSubConfig.put(versionedKey, subConfig.get(key));
                    continue;
                }
                convertedSubConfig.put(key, subConfig.get(key));
            }
        }
        return convertedSubConfig;
    }

    public static class VersionParser {
        private static Logger logger = LoggerFactory.getLogger(VersionParser.class);
        private static Version DEFAULT = new Version(0, 0, 0);
        private static Pattern VERSION_PAT = Pattern.compile("([0-9]+)?(?:\\.([0-9]*)(?:\\.([0-9]*))?)?[\\.-]?(.*)");
        private static Pattern CLASSIFIER_PAT = Pattern.compile("[a-zA-Z0-9_\\-]+");

        public static Version parseVersion(String incomingVersion) {
            if (StringUtils.isEmpty((String)incomingVersion)) {
                return DEFAULT;
            }
            Matcher m = VERSION_PAT.matcher(incomingVersion);
            if (!m.matches()) {
                return DEFAULT;
            }
            String s_major = m.group(1);
            String s_minor = m.group(2);
            String s_patch = m.group(3);
            String classifier = m.group(4);
            Integer major = 0;
            Integer minor = 0;
            Integer patch = 0;
            if (!StringUtils.isEmpty((String)s_major)) {
                try {
                    major = Integer.parseInt(s_major);
                }
                catch (NumberFormatException e) {
                    logger.warn("Major version part not an integer: " + s_major);
                }
            }
            if (!StringUtils.isEmpty((String)s_minor)) {
                try {
                    minor = Integer.parseInt(s_minor);
                }
                catch (NumberFormatException e) {
                    logger.warn("Minor version part not an integer: " + s_minor);
                }
            }
            if (!StringUtils.isEmpty((String)s_patch)) {
                try {
                    patch = Integer.parseInt(s_patch);
                }
                catch (NumberFormatException e) {
                    logger.warn("Patch version part not an integer: " + s_patch);
                }
            }
            if (classifier != null && !CLASSIFIER_PAT.matcher(classifier = classifier.replaceAll("\\.", "_")).matches()) {
                logger.warn("Provided Classifier not valid for OSGI, ignoring");
                classifier = null;
            }
            if (classifier != null) {
                return new Version(major.intValue(), minor.intValue(), patch.intValue(), classifier);
            }
            return new Version(major.intValue(), minor.intValue(), patch.intValue());
        }
    }

    public static class ArtifactInfo {
        private String group = "unknown";
        private String artifactId = "unknown";
        private String version = "0.0.0";
        private String osgiCompatibleVersion = "0.0.0";

        public ArtifactInfo(URL url) {
            if (url.getProtocol().equals("file")) {
                String filePath = url.getFile();
                int start = filePath.lastIndexOf(47);
                this.artifactId = start >= 0 ? filePath.substring(filePath.lastIndexOf(47) + 1, filePath.length()) : filePath;
            } else if (url.getProtocol().equals("mvn")) {
                String[] parts = url.getPath().split("!", 2);
                String artifactPart = parts[parts.length - 1];
                parts = artifactPart.split("/");
                this.group = parts[0];
                this.artifactId = parts[1];
                this.version = parts.length > 2 ? parts[2] : "LATEST";
                this.osgiCompatibleVersion = VersionParser.parseVersion(this.version).toString();
            }
        }

        public ArtifactInfo(String group, String artifactId, String version) {
            this.group = group;
            this.artifactId = artifactId;
            this.version = version;
        }

        public String getGroup() {
            return this.group;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public String getOsgiCompatibleVersion() {
            return this.osgiCompatibleVersion;
        }
    }

    public static class ModuleInfo {
        private String name;
        private String version;
        private String path;
        private boolean isAmdPackage;
        private String exports;
        private String versionedModuleId;
        private String versionedPath;
        final HashMap<String, Object> modules;
        private Map<String, Object> requireJs;

        public ModuleInfo(String moduleName, String moduleVersion) {
            this.name = moduleName;
            this.version = moduleVersion;
            this.isAmdPackage = true;
            this.exports = null;
            this.versionedModuleId = this.name + "_" + this.version;
            this.versionedPath = this.name + "/" + this.version;
            this.modules = new HashMap();
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getPath() {
            return this.path != null ? this.path : "";
        }

        public void setPath(String path) {
            this.path = path;
        }

        public boolean isAmdPackage() {
            return this.isAmdPackage;
        }

        public void setAmdPackage(boolean amdPackage) {
            this.isAmdPackage = amdPackage;
        }

        public String getExports() {
            return this.exports;
        }

        public void setExports(String exports) {
            this.exports = exports;
        }

        public void addModuleId(String key, Object module) {
            this.modules.put(key, module);
        }

        public HashMap<String, Object> getModules() {
            return this.modules;
        }

        public String getVersionedName() {
            return this.versionedModuleId;
        }

        public String getVersionedPath() {
            return this.versionedPath;
        }

        public Map<String, Object> getRequireJs() {
            return this.requireJs;
        }

        public void setRequireJs(Map<String, Object> requireJs) {
            this.requireJs = requireJs;
        }

        public String exportRequireJs() {
            return JSONObject.toJSONString(this.requireJs);
        }
    }
}

