/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.pur;

import java.io.Serializable;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.RepositoryAttributeInterface;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.platform.api.repository2.unified.data.node.DataNode;
import org.pentaho.platform.api.repository2.unified.data.node.DataProperty;

public class PurRepositoryAttribute
implements RepositoryAttributeInterface,
Serializable {
    private static final long serialVersionUID = -5787096049770518000L;
    private DataNode dataNode;
    private List<DatabaseMeta> databases;

    public PurRepositoryAttribute(DataNode dataNode, List<DatabaseMeta> databases) {
        this.dataNode = dataNode;
        this.databases = databases;
    }

    public void setAttribute(String code, String value) {
        this.dataNode.setProperty(code, value);
    }

    public String getAttributeString(String code) {
        DataProperty property = this.dataNode.getProperty(code);
        if (property != null) {
            return property.getString();
        }
        return null;
    }

    public void setAttribute(String code, boolean value) {
        this.dataNode.setProperty(code, value);
    }

    public boolean getAttributeBoolean(String code) {
        DataProperty property = this.dataNode.getProperty(code);
        if (property != null) {
            return property.getBoolean();
        }
        return false;
    }

    public void setAttribute(String code, long value) {
        this.dataNode.setProperty(code, value);
    }

    public long getAttributeInteger(String code) {
        DataProperty property = this.dataNode.getProperty(code);
        if (property != null) {
            return property.getLong();
        }
        return 0L;
    }

    public void setAttribute(String code, DatabaseMeta databaseMeta) {
        this.dataNode.setProperty(code, databaseMeta.getObjectId().getId());
    }

    public DatabaseMeta getAttributeDatabaseMeta(String code) {
        DataProperty property = this.dataNode.getProperty(code);
        if (property == null || Const.isEmpty((String)property.getString())) {
            return null;
        }
        StringObjectId id = new StringObjectId(property.getString());
        return DatabaseMeta.findDatabase(this.databases, (ObjectId)id);
    }
}

