/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.rules;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.ObjectFilter;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.io.Resource;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.step.BaseStepData;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.steps.rules.Rules;
import org.pentaho.di.trans.steps.rules.RulesAccumulator;

public class RulesAccumulatorData
extends BaseStepData
implements StepDataInterface {
    private static Class<?> PKG = RulesAccumulator.class;
    private RowMetaInterface outputRowMeta;
    private RowMetaInterface inputRowMeta;
    private KnowledgeBuilder kbuilder;
    private KnowledgeBase kbase;
    private List<Object[]> results;
    private String ruleString;
    private List<Rules.Row> rowList = new ArrayList<Rules.Row>();
    private List<Rules.Row> resultList = new ArrayList<Rules.Row>();
    private String ruleFilePath;

    public String getRuleString() {
        return this.ruleString;
    }

    public void setRuleString(String ruleString) {
        this.ruleString = ruleString;
    }

    public String getRuleFilePath() {
        return this.ruleFilePath;
    }

    public void setRuleFilePath(String ruleFilePath) {
        this.ruleFilePath = ruleFilePath;
    }

    public void setOutputRowMeta(RowMetaInterface outputRowMeta) {
        this.outputRowMeta = outputRowMeta;
    }

    public RowMetaInterface getOutputRowMeta() {
        return this.outputRowMeta;
    }

    public void initializeRules() {
        ClassLoader orig = Thread.currentThread().getContextClassLoader();
        ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
        Thread.currentThread().setContextClassLoader(loader);
        Resource ruleSet = null;
        ruleSet = this.ruleString != null ? ResourceFactory.newReaderResource((Reader)new StringReader(this.ruleString)) : ResourceFactory.newFileResource((String)this.ruleFilePath);
        this.kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        this.kbuilder.add(ruleSet, ResourceType.DRL);
        if (this.kbuilder.hasErrors()) {
            System.out.println(this.kbuilder.getErrors().toString());
            throw new RuntimeException(BaseMessages.getString(PKG, (String)"RulesData.Error.CompileDRL", (String[])new String[0]));
        }
        Collection pkgs = this.kbuilder.getKnowledgePackages();
        this.kbase = KnowledgeBaseFactory.newKnowledgeBase();
        this.kbase.addKnowledgePackages(pkgs);
        Thread.currentThread().setContextClassLoader(orig);
    }

    public void initializeInput(RowMetaInterface _inputRowMeta) {
        if (_inputRowMeta == null) {
            BaseMessages.getString(PKG, (String)"RulesData.InitializeColumns.InputRowMetaIsNull", (String[])new String[0]);
            return;
        }
        this.inputRowMeta = _inputRowMeta;
    }

    public void loadRow(Object[] r) throws Exception {
        Hashtable<String, Object> columns = new Hashtable<String, Object>();
        for (String field : this.inputRowMeta.getFieldNames()) {
            columns.put(field, r[this.inputRowMeta.indexOfValue(field)]);
        }
        this.rowList.add(new Rules.Row(columns, true));
    }

    public List<Rules.Row> getResultRows() {
        return this.resultList;
    }

    public void execute() throws Exception {
        if (this.kbase != null) {
            StatefulKnowledgeSession session = this.kbase.newStatefulKnowledgeSession();
            for (Rules.Row row : this.rowList) {
                session.insert((Object)row);
            }
            session.fireAllRules();
            Collection oList = session.getObjects((org.drools.runtime.ObjectFilter)new ObjectFilter(){

                public boolean accept(Object o) {
                    return o instanceof Rules.Row && !((Rules.Row)o).isExternalSource();
                }
            });
            for (Object o : oList) {
                this.resultList.add((Rules.Row)o);
            }
            session.dispose();
        }
    }

    public List<Object[]> fetchResults() {
        return this.results;
    }

    public void shutdown() {
    }
}

