/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.impl.shim.mapreduce;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.big.data.impl.shim.mapreduce.FutureMapReduceJobSimpleImpl;
import org.pentaho.big.data.impl.shim.mapreduce.MapReduceJobBuilderImpl;
import org.pentaho.big.data.impl.shim.mapreduce.PentahoMapReduceJobBuilderImpl;
import org.pentaho.bigdata.api.mapreduce.MapReduceExecutionException;
import org.pentaho.bigdata.api.mapreduce.MapReduceJarInfo;
import org.pentaho.bigdata.api.mapreduce.MapReduceJobBuilder;
import org.pentaho.bigdata.api.mapreduce.MapReduceJobSimple;
import org.pentaho.bigdata.api.mapreduce.MapReduceService;
import org.pentaho.bigdata.api.mapreduce.PentahoMapReduceJobBuilder;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.plugins.LifecyclePluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entries.hadoopjobexecutor.JarUtility;
import org.pentaho.hadoop.PluginPropertiesUtil;
import org.pentaho.hadoop.shim.HadoopConfiguration;
import org.pentaho.hadoop.shim.spi.HadoopShim;

public class MapReduceServiceImpl
implements MapReduceService {
    public static final Class<?> PKG = MapReduceServiceImpl.class;
    public static final String ERROR_DRIVER_CLASS_NOT_SPECIFIED = "ErrorDriverClassNotSpecified";
    public static final String ERROR_MULTIPLE_DRIVER_CLASSES = "ErrorMultipleDriverClasses";
    private final NamedCluster namedCluster;
    private final HadoopShim hadoopShim;
    private final HadoopConfiguration hadoopConfiguration;
    private final ExecutorService executorService;
    private final JarUtility jarUtility;
    private final PluginPropertiesUtil pluginPropertiesUtil;
    private final PluginRegistry pluginRegistry;

    public MapReduceServiceImpl(NamedCluster namedCluster, HadoopConfiguration hadoopConfiguration, ExecutorService executorService) {
        this(namedCluster, hadoopConfiguration, executorService, new JarUtility(), new PluginPropertiesUtil(), PluginRegistry.getInstance());
    }

    public MapReduceServiceImpl(NamedCluster namedCluster, HadoopConfiguration hadoopConfiguration, ExecutorService executorService, JarUtility jarUtility, PluginPropertiesUtil pluginPropertiesUtil, PluginRegistry pluginRegistry) {
        this.namedCluster = namedCluster;
        this.hadoopConfiguration = hadoopConfiguration;
        this.hadoopShim = hadoopConfiguration.getHadoopShim();
        this.executorService = executorService;
        this.jarUtility = jarUtility;
        this.pluginPropertiesUtil = pluginPropertiesUtil;
        this.pluginRegistry = pluginRegistry;
    }

    public MapReduceJobSimple executeSimple(URL resolvedJarUrl, String driverClass, String commandLineArgs) throws MapReduceExecutionException {
        Class<?> mainClass = this.locateDriverClass(driverClass, resolvedJarUrl, this.hadoopShim);
        return new FutureMapReduceJobSimpleImpl(this.executorService, mainClass, commandLineArgs);
    }

    public MapReduceJobBuilder createJobBuilder(LogChannelInterface log, VariableSpace variableSpace) {
        return new MapReduceJobBuilderImpl(this.namedCluster, this.hadoopShim, log, variableSpace);
    }

    public PentahoMapReduceJobBuilder createPentahoMapReduceJobBuilder(LogChannelInterface log, VariableSpace variableSpace) throws IOException {
        PluginInterface pluginInterface = this.pluginRegistry.findPluginWithId(LifecyclePluginType.class, "HadoopSpoonPlugin");
        try {
            Properties pmrProperties = this.pluginPropertiesUtil.loadPluginProperties(pluginInterface);
            return new PentahoMapReduceJobBuilderImpl(this.namedCluster, this.hadoopConfiguration, log, variableSpace, pluginInterface, pmrProperties);
        }
        catch (KettleFileException e) {
            throw new IOException(e);
        }
    }

    public MapReduceJarInfo getJarInfo(URL resolvedJarUrl) throws IOException, ClassNotFoundException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        List classesInJarWithMain = this.jarUtility.getClassesInJarWithMain(resolvedJarUrl.toExternalForm(), classLoader);
        List<String> classNamesInJarWithMain = new ArrayList(classesInJarWithMain.size());
        for (Class aClass : classesInJarWithMain) {
            classNamesInJarWithMain.add(aClass.getCanonicalName());
        }
        final List<String> finalClassNamesInJarWithMain = classNamesInJarWithMain = Collections.unmodifiableList(classNamesInJarWithMain);
        Class mainClassFromManifest = null;
        try {
            mainClassFromManifest = this.jarUtility.getMainClassFromManifest(resolvedJarUrl, classLoader);
        }
        catch (Exception exception) {
            // empty catch block
        }
        final String mainClassName = mainClassFromManifest != null ? mainClassFromManifest.getCanonicalName() : null;
        return new MapReduceJarInfo(){

            public List<String> getClassesWithMain() {
                return finalClassNamesInJarWithMain;
            }

            public String getMainClass() {
                return mainClassName;
            }
        };
    }

    @VisibleForTesting
    Class<?> locateDriverClass(String driverClass, URL resolvedJarUrl, HadoopShim shim) throws MapReduceExecutionException {
        try {
            if (Const.isEmpty((String)driverClass)) {
                Class mainClass = this.jarUtility.getMainClassFromManifest(resolvedJarUrl, shim.getClass().getClassLoader());
                if (mainClass == null) {
                    List mainClasses = this.jarUtility.getClassesInJarWithMain(resolvedJarUrl.toExternalForm(), shim.getClass().getClassLoader());
                    if (mainClasses.size() == 1) {
                        return (Class)mainClasses.get(0);
                    }
                    if (mainClasses.isEmpty()) {
                        throw new MapReduceExecutionException(BaseMessages.getString(PKG, (String)ERROR_DRIVER_CLASS_NOT_SPECIFIED, (String[])new String[0]));
                    }
                    throw new MapReduceExecutionException(BaseMessages.getString(PKG, (String)ERROR_MULTIPLE_DRIVER_CLASSES, (String[])new String[0]));
                }
                return mainClass;
            }
            return this.jarUtility.getClassByName(driverClass, resolvedJarUrl, shim.getClass().getClassLoader());
        }
        catch (Exception e) {
            if (e instanceof MapReduceExecutionException) {
                throw (MapReduceExecutionException)e;
            }
            throw new MapReduceExecutionException((Throwable)e);
        }
    }
}

