/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.uifoundation.chart;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Paint;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Node;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.UnknownKeyException;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.commons.connection.PentahoDataTransmuter;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.uifoundation.chart.ChartDefinition;
import org.pentaho.platform.uifoundation.chart.JFreeChartEngine;
import org.pentaho.platform.uifoundation.messages.Messages;

public class CategoryDatasetChartDefinition
extends DefaultCategoryDataset
implements ChartDefinition {
    private static final String STACKED_NODE_NAME = "is-stacked";
    private static final String ORIENTATION_NODE_NAME = "orientation";
    private static final String DOMAIN_TITLE_NODE_NAME = "domain-title";
    private static final String DOMAIN_TITLE_FONT_NODE_NAME = "domain-title-font";
    private static final String DOMAIN_TICK_FONT_NODE_NAME = "domain-tick-font";
    private static final String RANGE_TITLE_NODE_NAME = "range-title";
    private static final String RANGE_TITLE_FONT_NODE_NAME = "range-title-font";
    private static final String RANGE_TICK_FORMAT_NODE_NAME = "range-tick-format";
    private static final String RANGE_TICK_FONT_NODE_NAME = "range-tick-font";
    private static final String RANGE_MINIMUM_NODE_NAME = "range-minimum";
    private static final String RANGE_MAXIMUM_NODE_NAME = "range-maximum";
    private static final String RANGE_TICK_UNITS_NODE_NAME = "range-tick-units";
    private static final String DOMAIN_LABEL_ROTATION_ANGLE_NODE_NAME = "domain-label-rotation";
    private static final String DOMAIN_LABEL_ROTATION_DIRECTION_NODE_NAME = "domain-label-rotation-dir";
    private static final String MAX_BAR_WIDTH_NODE_NAME = "max-bar-width";
    private static final String INCLUDE_NULL_CATEGORIES_NODE_NAME = "include-null-categories";
    private int chartType = -1;
    private static final int DEFAULT_WIDTH = 200;
    private static final int DEFAULT_HEIGHT = 200;
    private String title = "";
    protected String noDataMessage = null;
    private RectangleEdge titlePosition = RectangleEdge.TOP;
    private RectangleEdge legendPosition = RectangleEdge.BOTTOM;
    private Font titleFont = TextTitle.DEFAULT_FONT;
    private final List subTitles = new ArrayList();
    private Paint chartBackgroundPaint = Color.WHITE;
    private Image chartBackgroundImage = null;
    private boolean borderVisible = false;
    private Paint borderPaint = Color.BLACK;
    private int width = 200;
    private int height = 200;
    private PlotOrientation orientation = PlotOrientation.VERTICAL;
    private Paint plotBackgroundPaint = Color.WHITE;
    private Image plotBackgroundImage = null;
    private boolean legendIncluded = true;
    private Font legendFont = null;
    private boolean legendBorderVisible = true;
    private boolean includeNullCategories = true;
    private boolean threeD = false;
    private boolean stacked = false;
    private Paint[] paintSequence = null;
    private CategoryLabelPositions domainLabelPositions = new CategoryLabelPositions();
    private String domainTitle = null;
    private Font domainTitleFont = TextTitle.DEFAULT_FONT;
    private Font domainTickFont = null;
    private String rangeTitle = null;
    private Font rangeTitleFont = TextTitle.DEFAULT_FONT;
    private NumberFormat rangeTickFormat = null;
    private Font rangeTickFont = null;
    private double rangeMinimum = 0.0;
    private double rangeMaximum = 1.0;
    private Double rangeTickUnits = null;
    private Float backgroundAlpha;
    private Float foregroundAlpha;
    private String lineStyle = "solid";
    private float lineWidth = 1.0f;
    private boolean markersVisible = false;
    private Double maxBarWidth;
    private IPentahoSession session;
    private static final long serialVersionUID = 1717509132920946530L;

    public CategoryDatasetChartDefinition(IPentahoSession session) {
        this.session = session;
    }

    public CategoryDatasetChartDefinition(IPentahoSession session, Node chartAttributes) {
        this.session = session;
        this.setChartAttributes(chartAttributes);
    }

    public CategoryDatasetChartDefinition(int chartType, IPentahoResultSet data, boolean byRow, IPentahoSession session) {
        this(session);
        this.chartType = chartType;
        if (byRow) {
            this.setDataByRow(data);
        } else {
            this.setDataByColumn(data);
        }
    }

    public CategoryDatasetChartDefinition(IPentahoResultSet data, boolean byRow, Node chartAttributes, IPentahoSession session) {
        this(-1, data, byRow, session);
        this.setChartAttributes(chartAttributes);
    }

    public static Log getLogger() {
        return LogFactory.getLog(CategoryDatasetChartDefinition.class);
    }

    private void setChartAttributes(Node chartAttributes) {
        if (chartAttributes == null) {
            return;
        }
        Node backgroundAlphaNode = chartAttributes.selectSingleNode("background-alpha");
        Node foregroundAlphaNode = chartAttributes.selectSingleNode("foreground-alpha");
        if (backgroundAlphaNode != null) {
            this.setBackgroundAlpha(chartAttributes.selectSingleNode("background-alpha"));
        }
        if (foregroundAlphaNode != null) {
            this.setForegroundAlpha(chartAttributes.selectSingleNode("foreground-alpha"));
        }
        this.setChartType(chartAttributes.selectSingleNode("chart-type"));
        this.setChartBackground(chartAttributes.selectSingleNode("chart-background"));
        this.setPlotBackground(chartAttributes.selectSingleNode("plot-background"));
        this.setOrientation(chartAttributes.selectSingleNode(ORIENTATION_NODE_NAME));
        this.setLegendIncluded(chartAttributes.selectSingleNode("include-legend"));
        this.setTitle(chartAttributes.selectSingleNode("title"));
        List subTitleNodes = chartAttributes.selectNodes("subtitle");
        if (subTitleNodes == null || subTitleNodes.isEmpty()) {
            Node subTitlesNode = chartAttributes.selectSingleNode("subtitles");
            if (subTitlesNode != null) {
                subTitleNodes = subTitlesNode.selectNodes("subtitle");
            }
        } else {
            CategoryDatasetChartDefinition.getLogger().warn((Object)Messages.getInstance().getString("CHART.WARN_DEPRECATED_CHILD", "subtitle", "subtitles"));
            CategoryDatasetChartDefinition.getLogger().warn((Object)Messages.getInstance().getString("CHART.WARN_PROPERTY_WILL_NOT_VALIDATE", "subtitle"));
        }
        if (subTitleNodes != null) {
            this.addSubTitles(subTitleNodes);
        }
        this.setPaintSequence(chartAttributes.selectSingleNode("color-palette"));
        this.setStacked(chartAttributes.selectSingleNode(STACKED_NODE_NAME));
        this.setThreeD(chartAttributes.selectSingleNode("is-3D"));
        this.setWidth(chartAttributes.selectSingleNode("width"));
        this.setHeight(chartAttributes.selectSingleNode("height"));
        this.setCategoryLabelRotation(chartAttributes.selectSingleNode(DOMAIN_LABEL_ROTATION_DIRECTION_NODE_NAME), chartAttributes.selectSingleNode(DOMAIN_LABEL_ROTATION_ANGLE_NODE_NAME));
        this.setBorderVisible(chartAttributes.selectSingleNode("border-visible"));
        this.setBorderPaint(JFreeChartEngine.getPaint(chartAttributes.selectSingleNode("border-paint")));
        this.setTitlePosition(chartAttributes.selectSingleNode("title-position"));
        this.setLegendPosition(chartAttributes.selectSingleNode("legend-position"));
        this.setTitleFont(chartAttributes.selectSingleNode("title-font"));
        this.setDomainTitle(chartAttributes.selectSingleNode(DOMAIN_TITLE_NODE_NAME));
        this.setDomainTitleFont(chartAttributes.selectSingleNode(DOMAIN_TITLE_FONT_NODE_NAME));
        this.setRangeMinimum(chartAttributes.selectSingleNode(RANGE_MINIMUM_NODE_NAME));
        this.setRangeMaximum(chartAttributes.selectSingleNode(RANGE_MAXIMUM_NODE_NAME));
        this.setRangeTickUnits(chartAttributes.selectSingleNode(RANGE_TICK_UNITS_NODE_NAME));
        this.setDomainTickFont(chartAttributes.selectSingleNode(DOMAIN_TICK_FONT_NODE_NAME));
        this.setRangeTitle(chartAttributes.selectSingleNode(RANGE_TITLE_NODE_NAME));
        this.setRangeTitleFont(chartAttributes.selectSingleNode(RANGE_TITLE_FONT_NODE_NAME));
        this.setRangeTickFormat(chartAttributes.selectSingleNode(RANGE_TICK_FORMAT_NODE_NAME));
        this.setRangeTickFont(chartAttributes.selectSingleNode(RANGE_TICK_FONT_NODE_NAME));
        this.setLineStyle(chartAttributes.selectSingleNode("line-style"));
        this.setLineWidth(chartAttributes.selectSingleNode("line-width"));
        this.setMarkersVisible(chartAttributes.selectSingleNode("markers-visible"));
        this.setMaxBarWidth(chartAttributes.selectSingleNode(MAX_BAR_WIDTH_NODE_NAME));
        this.setLegendFont(chartAttributes.selectSingleNode("legend-font"));
        this.setLegendBorderVisible(chartAttributes.selectSingleNode("legend-border-visible"));
        String defaultIncludeNullCategories = PentahoSystem.getSystemSetting("Charting/include-null-categories", "true");
        this.setIncludeNullCategories("true".equals(defaultIncludeNullCategories));
        this.setIncludeNullCategories(chartAttributes.selectSingleNode(INCLUDE_NULL_CATEGORIES_NODE_NAME));
    }

    private void setDataByColumn(IPentahoResultSet data) {
        this.setDataByRow(PentahoDataTransmuter.pivot((IPentahoResultSet)data));
    }

    private void setDataByRow(IPentahoResultSet data) {
        boolean hasColumnHeaders;
        if (data == null) {
            this.noDataMessage = Messages.getInstance().getString("CHART.USER_NO_DATA_AVAILABLE");
            return;
        }
        boolean hasRowHeaders = data.getMetaData().getRowHeaders() != null;
        boolean bl = hasColumnHeaders = data.getMetaData().getColumnHeaders() != null;
        if (!hasRowHeaders || !hasColumnHeaders) {
            data = PentahoDataTransmuter.transmute((IPentahoResultSet)data, (boolean)false);
        }
        String[] rowHeaders = null;
        String[] columnHeaders = null;
        try {
            rowHeaders = PentahoDataTransmuter.getCollapsedHeaders((int)1, (IPentahoResultSet)data, (char)'|');
            columnHeaders = PentahoDataTransmuter.getCollapsedHeaders((int)0, (IPentahoResultSet)data, (char)'|');
        }
        catch (Exception e) {
            CategoryDatasetChartDefinition.getLogger().error(null, (Throwable)e);
        }
        int row = 0;
        Object[] rowData = data.next();
        while (rowData != null) {
            for (int column = 0; column < rowData.length; ++column) {
                Number currentNumber;
                if (rowData[column] instanceof Number) {
                    currentNumber = null;
                    try {
                        if (rowHeaders != null && row < rowHeaders.length && columnHeaders != null && column < columnHeaders.length) {
                            currentNumber = this.getValue((Comparable)((Object)rowHeaders[row]), (Comparable)((Object)columnHeaders[column]));
                        }
                    }
                    catch (UnknownKeyException uke) {
                        currentNumber = new Double(0.0);
                    }
                    if (currentNumber == null) {
                        currentNumber = new Double(0.0);
                    }
                    double currentValue = currentNumber.doubleValue();
                    double newValue = ((Number)rowData[column]).doubleValue();
                    if (rowHeaders == null || row >= rowHeaders.length || columnHeaders == null || column >= columnHeaders.length) continue;
                    this.setValue(new Double(currentValue + newValue), (Comparable)((Object)rowHeaders[row]), (Comparable)((Object)columnHeaders[column]));
                    continue;
                }
                if (!this.includeNullCategories || rowData[column] != null) continue;
                currentNumber = null;
                try {
                    if (rowHeaders != null && row < rowHeaders.length && columnHeaders != null && column < columnHeaders.length) {
                        currentNumber = this.getValue((Comparable)((Object)rowHeaders[row]), (Comparable)((Object)columnHeaders[column]));
                    }
                }
                catch (UnknownKeyException uke) {
                    currentNumber = null;
                }
                if (rowHeaders == null || row >= rowHeaders.length || columnHeaders == null || column >= columnHeaders.length) continue;
                this.setValue(currentNumber, (Comparable)((Object)rowHeaders[row]), (Comparable)((Object)columnHeaders[column]));
            }
            ++row;
            rowData = data.next();
        }
        if (data.getRowCount() > 0 && this.getRowCount() <= 0) {
            this.noDataMessage = Messages.getInstance().getString("CHART.USER_INCORRECT_DATA_FORMAT");
        }
    }

    public void setChartBackgroundPaint(Paint chartBackgroundPaint) {
        if (chartBackgroundPaint != null) {
            this.chartBackgroundPaint = chartBackgroundPaint;
        }
    }

    @Override
    public Font getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(Font titleFont) {
        this.titleFont = titleFont;
    }

    public void setTitleFont(Node titleFontNode) {
        Font font = JFreeChartEngine.getFont(titleFontNode);
        if (font != null) {
            this.setTitleFont(font);
        }
    }

    @Override
    public Paint getChartBackgroundPaint() {
        return this.chartBackgroundPaint;
    }

    public int getChartType() {
        return this.chartType;
    }

    @Deprecated
    public static int getChartType(String typeStr) {
        if (typeStr != null) {
            if ("PieChart".equalsIgnoreCase(typeStr)) {
                return 2;
            }
            if ("PieGrid".equalsIgnoreCase(typeStr)) {
                return 3;
            }
            if ("BarChart".equalsIgnoreCase(typeStr)) {
                return 4;
            }
            if ("LineChart".equalsIgnoreCase(typeStr)) {
                return 5;
            }
            if ("AreaChart".equalsIgnoreCase(typeStr)) {
                return 6;
            }
            if ("BarLineChart".equalsIgnoreCase(typeStr)) {
                return 11;
            }
        }
        return -1;
    }

    public void setChartType(Node chartTypeNode) {
        if (chartTypeNode != null) {
            String typeStr = chartTypeNode.getText();
            this.setChartType(JFreeChartEngine.getChartType(typeStr));
        }
    }

    public void setChartType(int chartType) {
        this.chartType = chartType;
    }

    @Override
    public boolean isThreeD() {
        return this.threeD;
    }

    public void setThreeD(Node threeDNode) {
        if (threeDNode != null) {
            String boolStr = threeDNode.getText();
            this.setThreeD(Boolean.parseBoolean(boolStr));
        }
    }

    public void setThreeD(boolean threeD) {
        this.threeD = threeD;
    }

    public boolean isStacked() {
        return this.stacked;
    }

    public void setStacked(Node stackedNode) {
        if (stackedNode != null) {
            String boolStr = stackedNode.getText();
            this.setStacked(Boolean.parseBoolean(boolStr));
        }
    }

    public void setStacked(boolean stacked) {
        this.stacked = stacked;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setHeight(Node heightNode) {
        if (heightNode != null) {
            this.setHeight(Integer.parseInt(heightNode.getText()));
        }
    }

    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    public void setWidth(Node widthNode) {
        if (widthNode != null) {
            this.setWidth(Integer.parseInt(widthNode.getText()));
        }
    }

    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(Node chartTitleNode) {
        if (chartTitleNode != null) {
            this.setTitle(chartTitleNode.getText());
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public Paint[] getPaintSequence() {
        return this.paintSequence;
    }

    public void setPaintSequence(Node paletteNode) {
        if (paletteNode != null) {
            List colorNodes = paletteNode.selectNodes("color");
            Paint[] paints = new Paint[colorNodes.size()];
            for (int i = 0; i < colorNodes.size(); ++i) {
                paints[i] = JFreeChartEngine.getPaint((Node)colorNodes.get(i));
            }
            this.setPaintSequence(paints);
        }
    }

    public void setPaintSequence(Paint[] paintSequence) {
        this.paintSequence = paintSequence;
    }

    @Override
    public List getSubtitles() {
        return this.subTitles;
    }

    public void addSubTitles(List subTitleNodes) {
        if (subTitleNodes != null) {
            Iterator iter = subTitleNodes.iterator();
            while (iter.hasNext()) {
                this.addSubTitle(((Node)iter.next()).getText());
            }
        }
    }

    public void addSubTitle(String subTitle) {
        this.subTitles.add(subTitle);
    }

    @Override
    public Image getChartBackgroundImage() {
        return this.chartBackgroundImage;
    }

    public void setChartBackgroundImage(Node chartBackgroundImageNode) {
        this.setChartBackgroundImage(JFreeChartEngine.getImage(chartBackgroundImageNode, this.getSession()));
    }

    public void setChartBackgroundImage(Image chartBackgroundImage) {
        this.chartBackgroundImage = chartBackgroundImage;
    }

    @Override
    public boolean isLegendIncluded() {
        return this.legendIncluded;
    }

    public void setLegendIncluded(Node legendNode) {
        if (legendNode != null) {
            String boolStr = legendNode.getText();
            Boolean booleanValue = new Boolean(boolStr);
            this.setLegendIncluded(booleanValue);
        }
    }

    public void setLegendIncluded(boolean legendIncluded) {
        this.legendIncluded = legendIncluded;
    }

    public void setPlotBackgroundPaint(Paint plotBackgroundPaint) {
        if (plotBackgroundPaint != null) {
            this.plotBackgroundPaint = plotBackgroundPaint;
        }
    }

    @Override
    public Paint getPlotBackgroundPaint() {
        return this.plotBackgroundPaint;
    }

    @Override
    public Image getPlotBackgroundImage() {
        return this.plotBackgroundImage;
    }

    public void setPlotBackgroundImage(Node plotBackgroundImageNode) {
        this.setPlotBackgroundImage(JFreeChartEngine.getImage(plotBackgroundImageNode, this.getSession()));
    }

    public void setPlotBackgroundImage(Image plotBackgroundImage) {
        this.plotBackgroundImage = plotBackgroundImage;
    }

    public PlotOrientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Node orientationNode) {
        if (orientationNode != null) {
            String orientationStr = orientationNode.getText();
            if ("Vertical".equalsIgnoreCase(orientationStr)) {
                this.setOrientation(PlotOrientation.VERTICAL);
            } else if ("Horizontal".equalsIgnoreCase(orientationStr)) {
                this.setOrientation(PlotOrientation.HORIZONTAL);
            }
        }
    }

    public void setOrientation(PlotOrientation orientation) {
        this.orientation = orientation;
    }

    public CategoryLabelPositions getCategoryLabelPositions() {
        return this.domainLabelPositions;
    }

    public void setCategoryLabelRotation(Node rotationDirection, Node rotationAngle) {
        String direction = "down";
        if (rotationDirection != null) {
            direction = rotationDirection.getText();
        }
        if (rotationAngle != null) {
            if ("up".equalsIgnoreCase(direction)) {
                this.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)Double.parseDouble(rotationAngle.getText())));
            } else {
                this.setCategoryLabelPositions(CategoryLabelPositions.createDownRotationLabelPositions((double)Double.parseDouble(rotationAngle.getText())));
            }
        }
    }

    public void setCategoryLabelPositions(CategoryLabelPositions categoryLabelPositions) {
        this.domainLabelPositions = categoryLabelPositions;
    }

    @Override
    public boolean isBorderVisible() {
        return this.borderVisible;
    }

    public void setBorderVisible(Node borderVisibleNode) {
        if (borderVisibleNode != null) {
            String boolStr = borderVisibleNode.getText();
            Boolean booleanValue = new Boolean(boolStr);
            this.setBorderVisible(booleanValue);
        }
    }

    public void setBorderVisible(boolean borderVisible) {
        this.borderVisible = borderVisible;
    }

    @Override
    public Paint getBorderPaint() {
        return this.borderPaint;
    }

    public void setBorderPaint(Paint borderPaint) {
        if (borderPaint != null) {
            this.borderPaint = borderPaint;
        }
    }

    public void setTitlePosition(Node titlePositionNode) {
        RectangleEdge position = this.getPosition(titlePositionNode);
        if (position != null) {
            this.setTitlePosition(position);
        }
    }

    public void setLegendPosition(Node legendPositionNode) {
        RectangleEdge position = this.getPosition(legendPositionNode);
        if (position != null) {
            this.setLegendPosition(position);
        }
    }

    private RectangleEdge getPosition(Node positionNode) {
        if (positionNode != null) {
            String positionStr = positionNode.getText();
            if ("top".equalsIgnoreCase(positionStr)) {
                return RectangleEdge.TOP;
            }
            if ("left".equalsIgnoreCase(positionStr)) {
                return RectangleEdge.LEFT;
            }
            if ("bottom".equalsIgnoreCase(positionStr)) {
                return RectangleEdge.BOTTOM;
            }
            if ("right".equalsIgnoreCase(positionStr)) {
                return RectangleEdge.RIGHT;
            }
        }
        return null;
    }

    @Override
    public RectangleEdge getTitlePosition() {
        return this.titlePosition;
    }

    public void setTitlePosition(RectangleEdge titlePosition) {
        this.titlePosition = titlePosition;
    }

    @Override
    public RectangleEdge getLegendPosition() {
        return this.legendPosition;
    }

    public void setLegendPosition(RectangleEdge legendPosition) {
        this.legendPosition = legendPosition;
    }

    public void setChartBackground(Node chartBackgroundNode) {
        Node backgroundTypeNode;
        if (chartBackgroundNode != null && (backgroundTypeNode = chartBackgroundNode.selectSingleNode("@type")) != null) {
            String backgroundTypeStr = backgroundTypeNode.getText();
            if ("color".equalsIgnoreCase(backgroundTypeStr)) {
                this.setChartBackgroundPaint(JFreeChartEngine.getPaint(chartBackgroundNode));
                this.setChartBackgroundImage((Image)null);
            } else if ("image".equalsIgnoreCase(backgroundTypeStr)) {
                this.setChartBackgroundImage(chartBackgroundNode);
                this.setChartBackgroundPaint(null);
            } else if ("texture".equalsIgnoreCase(backgroundTypeStr)) {
                this.setChartBackgroundPaint(JFreeChartEngine.getTexturePaint(chartBackgroundNode, this.getWidth(), this.getHeight(), this.getSession()));
                this.setChartBackgroundImage((Image)null);
            } else if ("gradient".equalsIgnoreCase(backgroundTypeStr)) {
                this.setChartBackgroundPaint(JFreeChartEngine.getGradientPaint(chartBackgroundNode, this.getWidth(), this.getHeight()));
                this.setChartBackgroundImage((Image)null);
            }
        }
    }

    public void setPlotBackground(Node plotBackgroundNode) {
        Node backgroundTypeNode;
        if (plotBackgroundNode != null && (backgroundTypeNode = plotBackgroundNode.selectSingleNode("@type")) != null) {
            String backgroundTypeStr = backgroundTypeNode.getText();
            if ("color".equalsIgnoreCase(backgroundTypeStr)) {
                this.setPlotBackgroundPaint(JFreeChartEngine.getPaint(plotBackgroundNode));
                this.setPlotBackgroundImage((Image)null);
            } else if ("image".equalsIgnoreCase(backgroundTypeStr)) {
                this.setPlotBackgroundImage(plotBackgroundNode);
                this.setPlotBackgroundPaint(null);
            } else if ("texture".equalsIgnoreCase(backgroundTypeStr)) {
                this.setPlotBackgroundPaint(JFreeChartEngine.getTexturePaint(plotBackgroundNode, this.getWidth(), this.getHeight(), this.getSession()));
                this.setPlotBackgroundImage((Image)null);
            } else if ("gradient".equalsIgnoreCase(backgroundTypeStr)) {
                this.setPlotBackgroundPaint(JFreeChartEngine.getGradientPaint(plotBackgroundNode, this.getWidth(), this.getHeight()));
                this.setPlotBackgroundImage((Image)null);
            }
        }
    }

    public void setDomainTitle(Node titleNode) {
        if (titleNode != null) {
            this.setDomainTitle(titleNode.getText());
        }
    }

    public String getDomainTitle() {
        return this.domainTitle;
    }

    public void setDomainTitle(String domainTitle) {
        this.domainTitle = domainTitle;
    }

    public void setRangeTitle(Node titleNode) {
        if (titleNode != null) {
            this.setRangeTitle(titleNode.getText());
        }
    }

    public String getRangeTitle() {
        return this.rangeTitle;
    }

    public void setRangeTitle(String rangeTitle) {
        this.rangeTitle = rangeTitle;
    }

    public void setDomainTitleFont(Node titleFontNode) {
        Font font = JFreeChartEngine.getFont(titleFontNode);
        if (font != null) {
            this.setDomainTitleFont(font);
        }
    }

    public Font getDomainTitleFont() {
        return this.domainTitleFont;
    }

    public void setDomainTitleFont(Font domainTitleFont) {
        this.domainTitleFont = domainTitleFont;
    }

    public Font getDomainTickFont() {
        return this.domainTickFont;
    }

    public void setDomainTickFont(Font domainTickFont) {
        this.domainTickFont = domainTickFont;
    }

    public void setDomainTickFont(Node rangeTickFontNode) {
        Font font = JFreeChartEngine.getFont(rangeTickFontNode);
        if (font != null) {
            this.setDomainTickFont(font);
        }
    }

    public void setRangeTitleFont(Node titleFontNode) {
        Font font = JFreeChartEngine.getFont(titleFontNode);
        if (font != null) {
            this.setRangeTitleFont(font);
        }
    }

    public Font getRangeTitleFont() {
        return this.rangeTitleFont;
    }

    public void setRangeTitleFont(Font rangeTitleFont) {
        this.rangeTitleFont = rangeTitleFont;
    }

    public NumberFormat getRangeTickFormat() {
        return this.rangeTickFormat;
    }

    public void setRangeTickFormat(NumberFormat rangeTickFormat) {
        this.rangeTickFormat = rangeTickFormat;
    }

    public void setRangeTickFormat(Node tickFormatFontNode) {
        DecimalFormat format;
        if (tickFormatFontNode != null && (format = new DecimalFormat(tickFormatFontNode.getText())) != null) {
            this.setRangeTickFormat(format);
        }
    }

    public Font getRangeTickFont() {
        return this.rangeTickFont;
    }

    public void setRangeTickFont(Font rangeTickFont) {
        this.rangeTickFont = rangeTickFont;
    }

    public void setRangeTickFont(Node rangeTickFontNode) {
        Font font = JFreeChartEngine.getFont(rangeTickFontNode);
        if (font != null) {
            this.setRangeTickFont(font);
        }
    }

    @Override
    public boolean isDisplayLabels() {
        return false;
    }

    public IPentahoSession getSession() {
        return this.session;
    }

    public void setSession(IPentahoSession session) {
        this.session = session;
    }

    public String getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(String lineStyle) {
        this.lineStyle = lineStyle;
    }

    public void setLineStyle(Node lineStyleNode) {
        if (lineStyleNode != null) {
            this.setLineStyle(lineStyleNode.getText());
        }
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
    }

    public void setLineWidth(Node lineWidthNode) {
        if (lineWidthNode != null) {
            this.setLineWidth(Float.parseFloat(lineWidthNode.getText()));
        }
    }

    public boolean isMarkersVisible() {
        return this.markersVisible;
    }

    public void setMarkersVisible(boolean markersVisible) {
        this.markersVisible = markersVisible;
    }

    public void setMarkersVisible(Node markersVisibleNode) {
        if (markersVisibleNode != null) {
            String boolStr = markersVisibleNode.getText();
            Boolean booleanValue = new Boolean(boolStr);
            this.setMarkersVisible(booleanValue);
        }
    }

    public Double getMaxBarWidth() {
        return this.maxBarWidth;
    }

    public void setMaxBarWidth(Double maxBarWidth) {
        this.maxBarWidth = maxBarWidth;
    }

    public void setMaxBarWidth(Node maxBarWidthNode) {
        if (maxBarWidthNode != null) {
            this.setMaxBarWidth(new Double(maxBarWidthNode.getText()));
        }
    }

    @Override
    public Font getLegendFont() {
        return this.legendFont;
    }

    public void setLegendFont(Font legendFont) {
        this.legendFont = legendFont;
    }

    public void setLegendFont(Node legendFontNode) {
        Font font = JFreeChartEngine.getFont(legendFontNode);
        if (font != null) {
            this.setLegendFont(font);
        }
    }

    public void setLegendBorderVisible(Node legendBorderVisibleNode) {
        if (legendBorderVisibleNode != null) {
            boolean legBorderVisible = new Boolean(legendBorderVisibleNode.getText());
            this.setLegendBorderVisible(legBorderVisible);
        }
    }

    public void setLegendBorderVisible(boolean legendBorderVisible) {
        this.legendBorderVisible = legendBorderVisible;
    }

    public void setIncludeNullCategories(Node includeNullCategoriesNode) {
        if (includeNullCategoriesNode != null) {
            boolean locIncludeNullCategories = new Boolean(includeNullCategoriesNode.getText());
            this.setIncludeNullCategories(locIncludeNullCategories);
        }
    }

    public boolean isIncludeNullCategories() {
        return this.includeNullCategories;
    }

    public void setIncludeNullCategories(boolean includeNullCategories) {
        this.includeNullCategories = includeNullCategories;
    }

    @Override
    public boolean isLegendBorderVisible() {
        return this.legendBorderVisible;
    }

    public double getRangeMinimum() {
        return this.rangeMinimum;
    }

    public void setRangeMinimum(Node rangeMinimumNode) {
        if (rangeMinimumNode != null) {
            this.setRangeMinimum(Double.parseDouble(rangeMinimumNode.getText()));
        }
    }

    public void setRangeMinimum(double rangeMinimum) {
        this.rangeMinimum = rangeMinimum;
    }

    public double getRangeMaximum() {
        return this.rangeMaximum;
    }

    public void setRangeMaximum(Node rangeMaximumNode) {
        if (rangeMaximumNode != null) {
            this.setRangeMaximum(Double.parseDouble(rangeMaximumNode.getText()));
        }
    }

    public void setRangeMaximum(double rangeMaximum) {
        this.rangeMaximum = rangeMaximum;
    }

    public void setRangeTickUnits(Node rangeTickUnitsNode) {
        String rangeTickVal;
        String dotLess;
        if (rangeTickUnitsNode != null && Integer.parseInt(dotLess = (rangeTickVal = rangeTickUnitsNode.getText()).replace(".", "")) > 0) {
            this.setRangeTickUnits(Double.parseDouble(rangeTickVal));
        }
    }

    public void setRangeTickUnits(double rangeTickUnits) {
        this.rangeTickUnits = rangeTickUnits;
    }

    public Double getRangeTickUnits() {
        return this.rangeTickUnits;
    }

    @Override
    public String getNoDataMessage() {
        return this.noDataMessage;
    }

    @Override
    public Float getBackgroundAlpha() {
        return this.backgroundAlpha;
    }

    public void setBackgroundAlpha(Node backgroundAlphaNode) {
        if (backgroundAlphaNode != null) {
            Float backgroundAlphaValue;
            this.backgroundAlpha = backgroundAlphaValue = new Float(backgroundAlphaNode.getText());
        }
    }

    @Override
    public Float getForegroundAlpha() {
        return this.foregroundAlpha;
    }

    public void setForegroundAlpha(Node foregroundAlphaNode) {
        if (foregroundAlphaNode != null) {
            Float foregroundAlphaValue;
            this.foregroundAlpha = foregroundAlphaValue = new Float(foregroundAlphaNode.getText());
        }
    }
}

