/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.uifoundation.chart;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.jfree.data.general.Dataset;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.engine.services.ActionSequenceJCRHelper;
import org.pentaho.platform.uifoundation.chart.AbstractChartComponent;
import org.pentaho.platform.uifoundation.messages.Messages;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;

public abstract class AbstractJFreeChartComponent
extends AbstractChartComponent {
    private static final long serialVersionUID = 1244685089926020547L;
    private static final int DEFAULT_HEIGHT = 125;
    private static final int DEFAULT_WIDTH = 125;
    protected int chartType;
    protected ActionSequenceJCRHelper jcrHelper = this.getSession() != null ? new ActionSequenceJCRHelper(this.getSession()) : new ActionSequenceJCRHelper();
    protected Dataset dataDefinition;

    protected AbstractJFreeChartComponent(int chartType, String definitionPath, int width, int height, IPentahoUrlFactory urlFactory, List messages) {
        this(urlFactory, messages);
        this.chartType = chartType;
        this.definitionPath = definitionPath;
        this.width = width;
        this.height = height;
        this.setSourcePath(definitionPath);
    }

    protected AbstractJFreeChartComponent(String definitionPath, IPentahoUrlFactory urlFactory, ArrayList messages) {
        this(urlFactory, messages);
        this.definitionPath = definitionPath;
        this.setSourcePath(definitionPath);
    }

    protected AbstractJFreeChartComponent(IPentahoUrlFactory urlFactory, List messages) {
        super(urlFactory, messages);
        AbstractChartComponent.logger = LogFactory.getLog(this.getClass());
    }

    public abstract Dataset createChart(Document var1);

    public Dataset getDataDefinitiont() {
        return this.dataDefinition;
    }

    public void setDataDefinition(Dataset dataSet) {
        this.dataDefinition = dataSet;
    }

    public int getChartType() {
        return this.chartType;
    }

    public void setChartType(int chartType) {
        this.chartType = chartType;
    }

    @Override
    public boolean setDataAction(String chartDefinition) {
        try {
            Document dataActionDocument = this.jcrHelper.getSolutionDocument(chartDefinition, RepositoryFilePermission.READ);
            if (dataActionDocument == null) {
                return false;
            }
            Node dataNode = dataActionDocument.selectSingleNode("chart/data");
            if (dataNode == null) {
                return false;
            }
            this.chartType = (int)XmlDom4JHelper.getNodeText("chart-type", dataNode, -1L);
            this.actionPath = XmlDom4JHelper.getNodeText("data-path", dataNode);
            this.actionOutput = XmlDom4JHelper.getNodeText("data-output", dataNode);
            this.byRow = XmlDom4JHelper.getNodeText("data-orientation", dataNode, "rows").equals("rows");
            if (this.width == 0) {
                this.width = (int)XmlDom4JHelper.getNodeText("chart/width", (Node)dataActionDocument, 125L);
            }
            if (this.height == 0) {
                this.height = (int)XmlDom4JHelper.getNodeText("chart/height", (Node)dataActionDocument, 125L);
            }
        }
        catch (Exception e) {
            this.error(Messages.getInstance().getString("CategoryDatasetChartComponent.ERROR_0001_INVALID_CHART_DEFINITION", chartDefinition), e);
            return false;
        }
        return true;
    }
}

