/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.runtime;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository.IRuntimeElement;
import org.pentaho.platform.api.repository.RepositoryException;
import org.pentaho.platform.engine.core.system.PentahoBase;
import org.pentaho.platform.engine.services.messages.Messages;
import org.pentaho.platform.util.xml.XmlHelper;

public class SimpleRuntimeElement
extends PentahoBase
implements IRuntimeElement {
    private static final long serialVersionUID = 5024690844237335928L;
    private static final Log logger = LogFactory.getLog(SimpleRuntimeElement.class);
    private String instanceId;
    private String parentId;
    private String solutionId;
    private String parentType;
    private int revision;
    private Map typesMap = new HashMap();
    private Map paramMapSS = new HashMap();
    private Map paramMapLS = new HashMap();
    private Map paramMapBD = new HashMap();
    private Map paramMapDT = new HashMap();
    private Map paramMapLong = new HashMap();
    private Map paramMapCPLX = new HashMap();
    private static final int MAXSSLENGH = 254;
    private static final ThreadLocal allowableReadAttributeNames = new ThreadLocal();
    private boolean loaded;
    private boolean readOnly;

    protected SimpleRuntimeElement() {
    }

    public SimpleRuntimeElement(String instId) {
        this.instanceId = instId;
    }

    public SimpleRuntimeElement(String instId, String parId, String parType) {
        this.instanceId = instId;
        this.parentId = parId;
        this.parentType = parType;
    }

    public SimpleRuntimeElement(String instId, String parId, String parType, String solnId) {
        this.instanceId = instId;
        this.parentId = parId;
        this.parentType = parType;
        this.solutionId = solnId;
    }

    public List getMessages() {
        return null;
    }

    protected void setPentahoSession(IPentahoSession sess) {
        this.genLogIdFromSession(sess);
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.updateOk();
        this.parentId = parentId;
    }

    public String getParentType() {
        return this.parentType;
    }

    public void setParentType(String parentType) {
        this.updateOk();
        this.parentType = parentType;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instId) {
        this.updateOk();
        this.instanceId = instId;
    }

    public String getSolutionId() {
        return this.solutionId;
    }

    public void setSolutionId(String solutionId) {
        this.updateOk();
        this.solutionId = solutionId;
    }

    public int getRevision() {
        return this.revision;
    }

    protected void setRevision(int rev) {
        this.revision = rev;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IRuntimeElement)) {
            return false;
        }
        IRuntimeElement otherRE = (IRuntimeElement)other;
        return this.getInstanceId().equals(otherRE.getInstanceId());
    }

    public int hashCode() {
        return this.getInstanceId().hashCode();
    }

    protected Map getParamMapSS() {
        return this.paramMapSS;
    }

    protected Map getParamMapLS() {
        return this.paramMapLS;
    }

    protected Map getParamMapDT() {
        return this.paramMapDT;
    }

    protected Map getParamMapBD() {
        return this.paramMapBD;
    }

    protected Map getParamMapLong() {
        return this.paramMapLong;
    }

    protected Map getParamMapCPLX() {
        return this.paramMapCPLX;
    }

    protected void setParamMapSS(Map ss) {
        this.paramMapSS = ss;
    }

    protected void setParamMapLS(Map ls) {
        this.paramMapLS = ls;
    }

    protected void setParamMapDT(Map dt) {
        this.paramMapDT = dt;
    }

    protected void setParamMapBD(Map bd) {
        this.paramMapBD = bd;
    }

    protected void setParamMapLong(Map lng) {
        this.paramMapLong = lng;
    }

    protected void setParamMapCPLX(Map cplx) {
        this.paramMapCPLX = cplx;
    }

    public String getStringProperty(String key) {
        return this.getStringProperty(key, null);
    }

    public String getStringProperty(String key, String defaultValue) {
        this.trace(Messages.getInstance().getString("RTREPO.DEBUG_PROPERTY_GETSET", "getString", key));
        Object prop = this.getParamMapSS().get(key);
        if (prop == null) {
            prop = this.getParamMapLS().get(key);
        }
        return prop != null ? prop.toString() : defaultValue;
    }

    protected void checkType(String key, String type, boolean setIt) {
        Map localTypesMap = this.getTypesMap();
        String curType = (String)localTypesMap.get(key);
        if (curType != null && !curType.equals(type)) {
            throw new RepositoryException(Messages.getInstance().getErrorString("RTREPO.ERROR_0001_INVALIDTYPE", curType, type));
        }
        if (setIt) {
            localTypesMap.put(key, type);
        }
    }

    public void setStringProperty(String key, String value) {
        this.updateOk();
        this.trace(Messages.getInstance().getString("RTREPO.DEBUG_PROPERTY_GETSET", "setString", key));
        Map theMapSS = this.getParamMapSS();
        Map theMapLS = this.getParamMapLS();
        if (value != null) {
            this.checkType(key, value.getClass().getName(), true);
            if (value.length() > 254) {
                theMapSS.remove(key);
                theMapLS.put(key, new StringBuffer(value));
            } else {
                theMapLS.remove(key);
                theMapSS.put(key, value);
            }
        } else {
            theMapSS.remove(key);
            theMapLS.remove(key);
        }
    }

    public BigDecimal getBigDecimalProperty(String key) {
        this.trace(Messages.getInstance().getString("RTREPO.DEBUG_PROPERTY_GETSET", "getBigDecimal", key));
        return this.getBigDecimalProperty(key, null);
    }

    public BigDecimal getBigDecimalProperty(String key, BigDecimal defaultValue) {
        this.trace(Messages.getInstance().getString("RTREPO.DEBUG_PROPERTY_GETSET", "getBigDecimal", key));
        Object prop = this.getParamMapBD().get(key);
        return prop != null ? new BigDecimal((String)prop) : defaultValue;
    }

    public void setBigDecimalProperty(String key, BigDecimal value) {
        this.updateOk();
        this.trace(Messages.getInstance().getString("RTREPO.DEBUG_PROPERTY_GETSET", "setBigDecimal", key));
        Map theMap = this.getParamMapBD();
        if (value != null) {
            this.checkType(key, value.getClass().getName(), true);
            theMap.put(key, value.toString());
        } else {
            theMap.remove(key);
        }
    }

    public Date getDateProperty(String key) {
        this.trace(Messages.getInstance().getString("RTREPO.DEBUG_PROPERTY_GETSET", "getDate", key));
        return this.getDateProperty(key, null);
    }

    public Date getDateProperty(String key, Date defaultValue) {
        this.trace(Messages.getInstance().getString("RTREPO.DEBUG_PROPERTY_GETSET", "getDate", key));
        Object prop = this.getParamMapDT().get(key);
        return prop != null ? (Date)prop : defaultValue;
    }

    public void setDateProperty(String key, Date value) {
        this.updateOk();
        this.trace(Messages.getInstance().getString("RTREPO.DEBUG_PROPERTY_GETSET", "setDate", key));
        Map theMap = this.getParamMapDT();
        if (value != null) {
            this.checkType(key, value.getClass().getName(), true);
            theMap.put(key, value);
        } else {
            theMap.remove(key);
        }
    }

    public Long getLongProperty(String key, Long defaultValue) {
        this.trace(Messages.getInstance().getString("RTREPO.DEBUG_PROPERTY_GETSET", "getLong", key));
        Object prop = this.getParamMapLong().get(key);
        return prop != null ? (Long)prop : defaultValue;
    }

    public long getLongProperty(String key, long defaultValue) {
        this.trace(Messages.getInstance().getString("RTREPO.DEBUG_PROPERTY_GETSET", "getLong", key));
        Object prop = this.getParamMapLong().get(key);
        return prop != null ? (Long)prop : defaultValue;
    }

    public void setLongProperty(String key, Long value) {
        this.updateOk();
        this.trace(Messages.getInstance().getString("RTREPO.DEBUG_PROPERTY_GETSET", "setLong", key));
        Map theMap = this.getParamMapLong();
        if (value != null) {
            this.checkType(key, value.getClass().getName(), true);
            theMap.put(key, value);
        } else {
            theMap.remove(key);
        }
    }

    public void setLongProperty(String key, long value) {
        this.updateOk();
        this.setLongProperty(key, new Long(value));
    }

    public List getListProperty(String key) {
        this.trace(Messages.getInstance().getString("RTREPO.DEBUG_PROPERTY_GETSET", "getList", key));
        Object prop = this.getParamMapCPLX().get(key);
        return (List)prop;
    }

    public Map getMapProperty(String key) {
        this.trace(Messages.getInstance().getString("RTREPO.DEBUG_PROPERTY_GETSET", "getMap", key));
        Object prop = this.getParamMapCPLX().get(key);
        return (Map)prop;
    }

    public void setListProperty(String key, List value) {
        this.updateOk();
        this.trace(Messages.getInstance().getString("RTREPO.DEBUG_PROPERTY_GETSET", "setList", key));
        Map theMap = this.getParamMapCPLX();
        if (value != null) {
            this.checkType(key, value.getClass().getName(), true);
            theMap.put(key, value);
        } else {
            theMap.remove(key);
        }
    }

    public void setMapProperty(String key, Map value) {
        this.updateOk();
        this.trace(Messages.getInstance().getString("RTREPO.DEBUG_PROPERTY_GETSET", "setMap", key));
        Map theMap = this.getParamMapCPLX();
        if (value != null) {
            this.checkType(key, value.getClass().getName(), true);
            theMap.put(key, value);
        } else {
            theMap.remove(key);
        }
    }

    public String toXML() {
        StringBuffer rtn = new StringBuffer();
        rtn.append("<runtime-element>\r");
        rtn.append(this.getXMLString(this.getInstanceId(), "instance-id", "  "));
        rtn.append(this.getXMLString(Integer.toString(this.getRevision()), "revision", "  "));
        rtn.append(this.getXMLString(this.getParentId(), "parent-id", "  "));
        rtn.append(this.getXMLString(this.getParentType(), "parent-type", "  "));
        rtn.append(this.getXMLString(this.getSolutionId(), "solution-id", "  "));
        rtn.append(this.getMapXML(this.getParamMapSS(), "small-string-map"));
        rtn.append(this.getMapXML(this.getParamMapLS(), "large-string-map"));
        rtn.append(this.getMapXML(this.getParamMapDT(), "date-map"));
        rtn.append(this.getMapXML(this.getParamMapBD(), "big-decimal-map"));
        rtn.append(this.getMapXML(this.getParamMapLong(), "long-map"));
        rtn.append(this.getMapXML(this.getParamMapCPLX(), "complex-map"));
        rtn.append("</runtime-element>\r");
        return rtn.toString();
    }

    private String getXMLString(String str, String tag, String indent) {
        return indent + "<" + tag + "><![CDATA[" + str + "]]></" + tag + ">\r";
    }

    private String getMapXML(Map theMap, String tag) {
        StringBuffer sb = new StringBuffer();
        sb.append("  <").append(tag).append(">\r");
        sb.append(XmlHelper.mapToXML(theMap, "      "));
        sb.append("  </").append(tag).append(">\r");
        return sb.toString();
    }

    @Override
    public Log getLogger() {
        return logger;
    }

    public void setAllowableAttributeNames(Collection allowedReadNames) {
        allowableReadAttributeNames.set(allowedReadNames);
    }

    protected Map getTypesMap() {
        return this.typesMap;
    }

    protected void setTypesMap(Map typesMap) {
        this.typesMap = typesMap;
    }

    public Set getParameterNames() {
        return this.getTypesMap().keySet();
    }

    public String getParameterType(String parameterName) {
        return (String)this.getTypesMap().get(parameterName);
    }

    public void setLoaded(boolean value) {
        this.loaded = value;
    }

    public boolean getLoaded() {
        return this.loaded;
    }

    private void updateOk() {
        if (!this.loaded) {
            return;
        }
        if (this.readOnly) {
            throw new IllegalStateException(Messages.getInstance().getErrorString("RTELEMENT.ERROR_0001_INVALIDUPDATE"));
        }
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean value) {
        this.readOnly = value;
    }

    public void forceSave() {
    }
}

