/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.security.event;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.audit.AuditHelper;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.security.Authentication;
import org.springframework.security.event.authentication.AbstractAuthenticationEvent;
import org.springframework.security.event.authentication.AuthenticationSuccessEvent;
import org.springframework.util.Assert;

public class PentahoAuthenticationSuccessListener
implements ApplicationListener,
Ordered {
    private static final Log logger = LogFactory.getLog(PentahoAuthenticationSuccessListener.class);
    private int order = 100;

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof AuthenticationSuccessEvent) {
            logger.debug((Object)("received " + event.getClass().getSimpleName()));
            logger.debug((Object)"synchronizing current IPentahoSession with SecurityContext");
            try {
                Authentication authentication = ((AbstractAuthenticationEvent)event).getAuthentication();
                IPentahoSession pentahoSession = PentahoSessionHolder.getSession();
                Assert.notNull((Object)pentahoSession, (String)"PentahoSessionHolder doesn't have a session");
                pentahoSession.setAuthenticated(authentication.getName());
                pentahoSession.setAttribute("roles", (Object)authentication.getAuthorities());
                AuditHelper.audit(pentahoSession.getId(), pentahoSession.getName(), pentahoSession.getActionName(), pentahoSession.getObjectName(), "", "session_start", "", "", 0.0f, null);
            }
            catch (Exception e) {
                logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

