/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system.objfac;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.lang.ClassUtils;
import org.pentaho.platform.api.engine.IPentahoObjectReference;
import org.pentaho.platform.api.engine.IPentahoObjectRegistration;
import org.pentaho.platform.api.engine.IPentahoRegistrableObjectFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.objfac.references.SingletonPentahoObjectReference;

public class RuntimeObjectFactory
implements IPentahoRegistrableObjectFactory {
    private final Multimap<Class, IPentahoObjectReference<?>> registry = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());

    public <T> IPentahoObjectRegistration registerObject(T obj) {
        if (obj instanceof IPentahoObjectReference) {
            throw new IllegalArgumentException("Object cannot be of type: IPentahoObjectRegistration. Call the appropriate registerReference instead");
        }
        return this.registerReference(new SingletonPentahoObjectReference(obj.getClass(), obj), IPentahoRegistrableObjectFactory.Types.ALL);
    }

    public <T> IPentahoObjectRegistration registerReference(IPentahoObjectReference<T> reference) {
        return this.registerReference(reference, IPentahoRegistrableObjectFactory.Types.ALL);
    }

    public <T> IPentahoObjectRegistration registerObject(T obj, IPentahoRegistrableObjectFactory.Types types) {
        if (obj instanceof IPentahoObjectReference) {
            throw new IllegalArgumentException("Object cannot be of type: IPentahoObjectRegistration. Call the appropriate registerReference instead");
        }
        return this.registerReference(new SingletonPentahoObjectReference(obj.getClass(), obj), types);
    }

    public <T> IPentahoObjectRegistration registerReference(IPentahoObjectReference<T> reference, IPentahoRegistrableObjectFactory.Types types) {
        ArrayList<Class> classesToPublishAs = new ArrayList<Class>();
        Class clazz = reference.getObjectClass();
        switch (types) {
            case INTERFACES: {
                classesToPublishAs.addAll(ClassUtils.getAllInterfaces((Class)clazz));
                break;
            }
            case CLASSES: {
                classesToPublishAs.addAll(ClassUtils.getAllSuperclasses((Class)clazz));
                classesToPublishAs.add(clazz);
                break;
            }
            case ALL: {
                classesToPublishAs.addAll(ClassUtils.getAllInterfaces((Class)clazz));
                classesToPublishAs.addAll(ClassUtils.getAllSuperclasses((Class)clazz));
                classesToPublishAs.add(clazz);
            }
        }
        return this.registerReference(reference, classesToPublishAs.toArray(new Class[classesToPublishAs.size()]));
    }

    public <T> IPentahoObjectRegistration registerObject(T obj, Class<?> ... classes) {
        if (obj instanceof IPentahoObjectReference) {
            throw new IllegalArgumentException("Object cannot be of type: IPentahoObjectRegistration. Call the appropriate registerReference instead");
        }
        return this.registerReference(new SingletonPentahoObjectReference(obj.getClass(), obj), classes);
    }

    public <T> IPentahoObjectRegistration registerReference(IPentahoObjectReference<T> reference, Class<?> ... classes) {
        for (Class<?> aClass : classes) {
            this.registry.get(aClass).add(reference);
        }
        return new ObjectRegistration(reference, Arrays.asList(classes));
    }

    public <T> T get(Class<T> interfaceClass, IPentahoSession session) throws ObjectFactoryException {
        IPentahoObjectReference<T> objectReference = this.getObjectReference(interfaceClass, session);
        if (objectReference == null) {
            return null;
        }
        return (T)objectReference.getObject();
    }

    public <T> T get(Class<T> interfaceClass, String key, IPentahoSession session) throws ObjectFactoryException {
        IPentahoObjectReference<T> reference = this.getObjectReference(interfaceClass, session, Collections.singletonMap("id", key));
        if (reference == null && (reference = this.getObjectReference(interfaceClass, session, Collections.emptyMap())) == null) {
            return null;
        }
        return (T)reference.getObject();
    }

    public <T> T get(Class<T> interfaceClass, IPentahoSession session, Map<String, String> properties) throws ObjectFactoryException {
        List<IPentahoObjectReference<T>> references = this.getObjectReferences(interfaceClass, session, properties);
        if (references.isEmpty()) {
            return null;
        }
        return (T)references.get(0).getObject();
    }

    public boolean objectDefined(String key) {
        return false;
    }

    public boolean objectDefined(Class<?> clazz) {
        return !this.registry.get(clazz).isEmpty();
    }

    public Class<?> getImplementingClass(String key) {
        return null;
    }

    public void init(String configFile, Object context) {
    }

    public <T> List<T> getAll(Class<T> interfaceClass, IPentahoSession session) throws ObjectFactoryException {
        return this.getAll(interfaceClass, session, Collections.emptyMap());
    }

    public <T> List<T> getAll(Class<T> interfaceClass, IPentahoSession session, Map<String, String> properties) throws ObjectFactoryException {
        List<IPentahoObjectReference<T>> retValReferences = this.getObjectReferences(interfaceClass, session, properties);
        ArrayList<Object> retVals = new ArrayList<Object>();
        for (IPentahoObjectReference<T> ref : retValReferences) {
            retVals.add(ref.getObject());
        }
        return retVals;
    }

    public <T> IPentahoObjectReference<T> getObjectReference(Class<T> interfaceClass, IPentahoSession curSession) throws ObjectFactoryException {
        return this.getObjectReference(interfaceClass, curSession, Collections.emptyMap());
    }

    public <T> IPentahoObjectReference<T> getObjectReference(Class<T> interfaceClass, IPentahoSession curSession, Map<String, String> properties) throws ObjectFactoryException {
        List<IPentahoObjectReference<T>> objectReferences = this.getObjectReferences(interfaceClass, curSession, properties);
        if (objectReferences.isEmpty()) {
            return null;
        }
        return objectReferences.get(0);
    }

    public <T> List<IPentahoObjectReference<T>> getObjectReferences(Class<T> interfaceClass, IPentahoSession curSession) throws ObjectFactoryException {
        return this.getObjectReferences(interfaceClass, curSession, Collections.emptyMap());
    }

    public <T> List<IPentahoObjectReference<T>> getObjectReferences(final Class<T> interfaceClass, IPentahoSession curSession, final Map<String, String> properties) throws ObjectFactoryException {
        List<Object> retValReferences = new ArrayList<IPentahoObjectReference<T>>();
        try {
            retValReferences = (List)SessionCapturedOperation.execute(curSession, new Callable<List<IPentahoObjectReference<T>>>(){

                @Override
                public List<IPentahoObjectReference<T>> call() throws Exception {
                    List<IPentahoObjectReference<?>> iPentahoObjectReferences = RuntimeObjectFactory.this.getReferencesByQuery(interfaceClass, properties);
                    ArrayList retVals = new ArrayList();
                    if (!iPentahoObjectReferences.isEmpty()) {
                        for (IPentahoObjectReference<?> ref : iPentahoObjectReferences) {
                            retVals.add(ref);
                        }
                    }
                    return retVals;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(retValReferences);
        Collections.reverse(retValReferences);
        return retValReferences;
    }

    public String getName() {
        return "Runtime Object Factory";
    }

    protected <T> List<IPentahoObjectReference<?>> getReferencesByQuery(Class<T> type, Map<String, String> query) {
        Collection iPentahoObjectReferences = this.registry.get(type);
        if (iPentahoObjectReferences.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList returnCollection = new ArrayList();
        for (IPentahoObjectReference next : iPentahoObjectReferences) {
            if (query == null || query.isEmpty()) {
                returnCollection.add(next);
                continue;
            }
            Map attributes = next.getAttributes();
            boolean matches = true;
            for (Map.Entry<String, String> queryEntry : query.entrySet()) {
                if (attributes.containsKey(queryEntry.getKey()) && attributes.get(queryEntry.getKey()).equals(queryEntry.getValue())) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            returnCollection.add(next);
        }
        return returnCollection;
    }

    protected class ObjectRegistration
    implements IPentahoObjectRegistration {
        private IPentahoObjectReference<?> reference;
        private List<Class<?>> publishedClasses;

        public ObjectRegistration(IPentahoObjectReference<?> reference, List<Class<?>> publishedClasses) {
            this.reference = reference;
            this.publishedClasses = publishedClasses;
        }

        public IPentahoObjectReference<?> getReference() {
            return this.reference;
        }

        public List<Class<?>> getPublishedClasses() {
            return this.publishedClasses;
        }

        public void remove() {
            for (Class<?> aClass : this.publishedClasses) {
                RuntimeObjectFactory.this.registry.get(aClass).remove(this.reference);
            }
        }
    }

    private static class SessionSwapper {
        private static final ThreadLocal<IPentahoSession> originalSessions = new ThreadLocal();

        private SessionSwapper() {
        }

        public static void swap(IPentahoSession tempSession) {
            IPentahoSession originalSession = PentahoSessionHolder.getSession();
            originalSessions.set(originalSession);
            if (originalSession != tempSession) {
                PentahoSessionHolder.setSession(tempSession);
            }
        }

        public static void restore() {
            IPentahoSession orig = originalSessions.get();
            PentahoSessionHolder.setSession(orig);
        }
    }

    private static class SessionCapturedOperation {
        private SessionCapturedOperation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static <T> T execute(IPentahoSession session, Callable<T> callee) throws Exception {
            SessionSwapper.swap(session);
            try {
                T t = callee.call();
                return t;
            }
            finally {
                SessionSwapper.restore();
            }
        }
    }
}

