/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system.objfac;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.pentaho.platform.api.engine.IPentahoObjectFactory;
import org.pentaho.platform.api.engine.IPentahoObjectReference;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.engine.core.messages.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateObjectFactory
implements IPentahoObjectFactory {
    protected final Set<IPentahoObjectFactory> factories = Collections.synchronizedSet(new HashSet());
    protected IPentahoObjectFactory primaryFactory;
    private Logger logger = LoggerFactory.getLogger(AggregateObjectFactory.class);
    private final ReadWriteLock factoryLock = new ReentrantReadWriteLock(false);
    private Lock writeLock = this.factoryLock.writeLock();
    private Lock readLock = this.factoryLock.readLock();
    private static ReferencePriorityComparitor referencePriorityComparitor = new ReferencePriorityComparitor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerObjectFactory(IPentahoObjectFactory fact, boolean primary) {
        this.writeLock.lock();
        try {
            this.factories.add(fact);
        }
        finally {
            this.writeLock.unlock();
        }
        if (primary) {
            this.primaryFactory = fact;
        }
        this.logger.debug("New IPentahoObjectFactory registered: " + fact.getName());
    }

    public void registerObjectFactory(IPentahoObjectFactory fact) {
        this.registerObjectFactory(fact, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deregisterObjectFactory(IPentahoObjectFactory factory) {
        this.writeLock.lock();
        try {
            boolean bl = this.factories.remove(factory);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Set<IPentahoObjectFactory> getFactories() {
        return new HashSet<IPentahoObjectFactory>(this.factories);
    }

    public IPentahoObjectFactory getPrimaryFactory() {
        return this.primaryFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Class<T> interfaceClass, String key, IPentahoSession session) throws ObjectFactoryException {
        T fromType;
        if (key != null) {
            this.readLock.lock();
            try {
                for (IPentahoObjectFactory fact : this.factories) {
                    if (!fact.objectDefined(key)) continue;
                    Object object = fact.get(interfaceClass, key, session);
                    this.logger.debug(MessageFormat.format("Found object for key: {0} in factory: {1}", key, fact.getName()));
                    Object object2 = object;
                    return (T)object2;
                }
            }
            finally {
                this.readLock.unlock();
            }
        }
        if ((fromType = this.get(interfaceClass, session, null)) != null) {
            return fromType;
        }
        String msg = Messages.getInstance().getString("AbstractSpringPentahoObjectFactory.WARN_FAILED_TO_RETRIEVE_OBJECT", interfaceClass.getSimpleName());
        throw new ObjectFactoryException(msg);
    }

    public <T> T get(Class<T> interfaceClass, IPentahoSession session) throws ObjectFactoryException {
        return this.get(interfaceClass, session, null);
    }

    private int computePriority(IPentahoObjectReference ref) {
        return ref.getRanking();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean objectDefined(String key) {
        this.readLock.lock();
        try {
            for (IPentahoObjectFactory fact : this.factories) {
                if (!fact.objectDefined(key)) continue;
                this.logger.debug(MessageFormat.format("Object defined for key: {0} in factory: {1}", key, fact.getName()));
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getImplementingClass(String key) {
        this.readLock.lock();
        try {
            for (IPentahoObjectFactory fact : this.factories) {
                if (!fact.objectDefined(key)) continue;
                this.logger.debug(MessageFormat.format("Found implementing class for key: {0} in factory: {1}", key, fact.getName()));
                Class clazz = fact.getImplementingClass(key);
                return clazz;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return null;
    }

    public void init(String configFile, Object context) {
    }

    public <T> List<T> getAll(Class<T> interfaceClass, IPentahoSession curSession) throws ObjectFactoryException {
        return this.getAll(interfaceClass, curSession, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> getAll(Class<T> interfaceClass, IPentahoSession curSession, Map<String, String> properties) throws ObjectFactoryException {
        ArrayList referenceList = new ArrayList();
        this.readLock.lock();
        try {
            for (IPentahoObjectFactory fact : this.factories) {
                List refs;
                if (!fact.objectDefined(interfaceClass) || (refs = fact.getObjectReferences(interfaceClass, curSession, properties)) == null) continue;
                referenceList.addAll(refs);
            }
        }
        finally {
            this.readLock.unlock();
        }
        Collections.sort(referenceList, referencePriorityComparitor);
        ArrayList<Object> entryList = new ArrayList<Object>();
        for (IPentahoObjectReference ref : referenceList) {
            if (entryList.contains(ref.getObject())) continue;
            entryList.add(ref.getObject());
        }
        return entryList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> IPentahoObjectReference<T> getObjectReference(Class<T> clazz, IPentahoSession curSession) throws ObjectFactoryException {
        HashSet<IPentahoObjectReference> references = new HashSet<IPentahoObjectReference>();
        this.readLock.lock();
        try {
            for (IPentahoObjectFactory fact : this.factories) {
                IPentahoObjectReference found;
                if (!fact.objectDefined(clazz) || (found = fact.getObjectReference(clazz, curSession)) == null) continue;
                references.add(found);
            }
        }
        finally {
            this.readLock.unlock();
        }
        IPentahoObjectReference highestRef = null;
        int highestRefPriority = -1;
        for (IPentahoObjectReference ref : references) {
            int pri = this.computePriority(ref);
            if (pri <= highestRefPriority) continue;
            highestRef = ref;
            highestRefPriority = pri;
        }
        return highestRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Class<T> clazz, IPentahoSession session, Map<String, String> properties) throws ObjectFactoryException {
        IPentahoObjectReference<T> highestRef = this.getObjectReference(clazz, session, properties);
        if (highestRef != null) {
            return (T)highestRef.getObject();
        }
        this.readLock.lock();
        try {
            for (IPentahoObjectFactory fact : this.factories) {
                Object object;
                if (!fact.objectDefined(clazz.getSimpleName())) continue;
                Object object2 = object = fact.get(clazz, clazz.getSimpleName(), session);
                return (T)object2;
            }
        }
        finally {
            this.readLock.unlock();
        }
        String msg = Messages.getInstance().getString("AbstractSpringPentahoObjectFactory.WARN_FAILED_TO_RETRIEVE_OBJECT", clazz.getSimpleName());
        throw new ObjectFactoryException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean objectDefined(Class<?> clazz) {
        this.readLock.lock();
        try {
            for (IPentahoObjectFactory fact : this.factories) {
                if (!fact.objectDefined(clazz)) continue;
                this.logger.debug(MessageFormat.format("Found object for class: {0} in factory: {1}", clazz.getName(), fact.getName()));
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> IPentahoObjectReference<T> getObjectReference(Class<T> interfaceClass, IPentahoSession curSession, Map<String, String> properties) throws ObjectFactoryException {
        HashSet references = new HashSet();
        this.readLock.lock();
        try {
            for (IPentahoObjectFactory fact : this.factories) {
                List found;
                if (!fact.objectDefined(interfaceClass) || (found = fact.getObjectReferences(interfaceClass, curSession, properties)) == null) continue;
                references.addAll(found);
            }
        }
        finally {
            this.readLock.unlock();
        }
        IPentahoObjectReference highestRef = null;
        int highestRefPriority = -1;
        for (IPentahoObjectReference ref : references) {
            int pri = this.computePriority(ref);
            if (pri <= highestRefPriority) continue;
            highestRef = ref;
            highestRefPriority = pri;
        }
        return highestRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.writeLock.lock();
        try {
            this.factories.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public <T> List<IPentahoObjectReference<T>> getObjectReferences(Class<T> interfaceClass, IPentahoSession curSession) throws ObjectFactoryException {
        return this.getObjectReferences(interfaceClass, curSession, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<IPentahoObjectReference<T>> getObjectReferences(Class<T> interfaceClass, IPentahoSession curSession, Map<String, String> properties) throws ObjectFactoryException {
        HashSet referenceSet = new HashSet();
        this.readLock.lock();
        try {
            for (IPentahoObjectFactory fact : this.factories) {
                List found;
                if (!fact.objectDefined(interfaceClass) || (found = fact.getObjectReferences(interfaceClass, curSession, properties)) == null) continue;
                referenceSet.addAll(found);
            }
        }
        finally {
            this.readLock.unlock();
        }
        ArrayList<IPentahoObjectReference<T>> referenceList = new ArrayList<IPentahoObjectReference<T>>();
        referenceList.addAll(referenceSet);
        Collections.sort(referenceList, referencePriorityComparitor);
        return referenceList;
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    private static class ReferencePriorityComparitor
    implements Comparator<IPentahoObjectReference> {
        private static final String PRIORITY = "priority";

        private ReferencePriorityComparitor() {
        }

        @Override
        public int compare(IPentahoObjectReference ref1, IPentahoObjectReference ref2) {
            int pri2;
            int pri1 = this.extractPriority(ref1);
            if (pri1 == (pri2 = this.extractPriority(ref2))) {
                return 0;
            }
            if (pri1 < pri2) {
                return 1;
            }
            return -1;
        }

        private int extractPriority(IPentahoObjectReference ref) {
            if (ref == null || ref.getAttributes() == null || !ref.getAttributes().containsKey(PRIORITY)) {
                return 0;
            }
            try {
                return Integer.parseInt(ref.getAttributes().get(PRIORITY).toString());
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
    }
}

