/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.fst;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.lucene.search.suggest.InputIterator;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.search.suggest.SortedInputIterator;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.OfflineSorter;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.lucene.util.fst.Util;

public class WFSTCompletionLookup
extends Lookup {
    private FST<Long> fst = null;
    private final boolean exactFirst;
    private long count = 0L;
    static final Comparator<Long> weightComparator = new Comparator<Long>(){

        @Override
        public int compare(Long left, Long right) {
            return left.compareTo(right);
        }
    };

    public WFSTCompletionLookup() {
        this(true);
    }

    public WFSTCompletionLookup(boolean exactFirst) {
        this.exactFirst = exactFirst;
    }

    @Override
    public void build(InputIterator iterator) throws IOException {
        if (iterator.hasPayloads()) {
            throw new IllegalArgumentException("this suggester doesn't support payloads");
        }
        if (iterator.hasContexts()) {
            throw new IllegalArgumentException("this suggester doesn't support contexts");
        }
        this.count = 0L;
        BytesRef scratch = new BytesRef();
        WFSTInputIterator iter = new WFSTInputIterator(iterator);
        IntsRefBuilder scratchInts = new IntsRefBuilder();
        BytesRefBuilder previous = null;
        PositiveIntOutputs outputs = PositiveIntOutputs.getSingleton();
        Builder builder = new Builder(FST.INPUT_TYPE.BYTE1, (Outputs)outputs);
        while ((scratch = iter.next()) != null) {
            long cost = iter.weight();
            if (previous == null) {
                previous = new BytesRefBuilder();
            } else if (scratch.equals((Object)previous.get())) continue;
            Util.toIntsRef((BytesRef)scratch, (IntsRefBuilder)scratchInts);
            builder.add(scratchInts.get(), (Object)cost);
            previous.copyBytes(scratch);
            ++this.count;
        }
        this.fst = builder.finish();
    }

    @Override
    public boolean store(DataOutput output) throws IOException {
        output.writeVLong(this.count);
        if (this.fst == null) {
            return false;
        }
        this.fst.save(output);
        return true;
    }

    @Override
    public boolean load(DataInput input) throws IOException {
        this.count = input.readVLong();
        this.fst = new FST(input, (Outputs)PositiveIntOutputs.getSingleton());
        return true;
    }

    @Override
    public List<Lookup.LookupResult> lookup(CharSequence key, Set<BytesRef> contexts, boolean onlyMorePopular, int num) {
        if (contexts != null) {
            throw new IllegalArgumentException("this suggester doesn't support contexts");
        }
        assert (num > 0);
        if (onlyMorePopular) {
            throw new IllegalArgumentException("this suggester only works with onlyMorePopular=false");
        }
        if (this.fst == null) {
            return Collections.emptyList();
        }
        BytesRefBuilder scratch = new BytesRefBuilder();
        scratch.copyChars(key);
        int prefixLength = scratch.length();
        FST.Arc arc = new FST.Arc();
        Long prefixOutput = null;
        try {
            prefixOutput = this.lookupPrefix(scratch.get(), (FST.Arc<Long>)arc);
        }
        catch (IOException bogus) {
            throw new RuntimeException(bogus);
        }
        if (prefixOutput == null) {
            return Collections.emptyList();
        }
        ArrayList<Lookup.LookupResult> results = new ArrayList<Lookup.LookupResult>(num);
        CharsRefBuilder spare = new CharsRefBuilder();
        if (this.exactFirst && arc.isFinal()) {
            spare.copyUTF8Bytes(scratch.get());
            results.add(new Lookup.LookupResult(spare.toString(), WFSTCompletionLookup.decodeWeight(prefixOutput + (Long)arc.nextFinalOutput)));
            if (--num == 0) {
                return results;
            }
        }
        Util.TopResults completions = null;
        try {
            completions = Util.shortestPaths(this.fst, (FST.Arc)arc, (Object)prefixOutput, weightComparator, (int)num, (!this.exactFirst ? 1 : 0) != 0);
            assert (completions.isComplete);
        }
        catch (IOException bogus) {
            throw new RuntimeException(bogus);
        }
        BytesRefBuilder suffix = new BytesRefBuilder();
        for (Util.Result completion : completions) {
            scratch.setLength(prefixLength);
            Util.toBytesRef((IntsRef)completion.input, (BytesRefBuilder)suffix);
            scratch.append(suffix);
            spare.copyUTF8Bytes(scratch.get());
            results.add(new Lookup.LookupResult(spare.toString(), WFSTCompletionLookup.decodeWeight((Long)completion.output)));
        }
        return results;
    }

    private Long lookupPrefix(BytesRef scratch, FST.Arc<Long> arc) throws IOException {
        assert (0L == (Long)this.fst.outputs.getNoOutput());
        long output = 0L;
        FST.BytesReader bytesReader = this.fst.getBytesReader();
        this.fst.getFirstArc(arc);
        byte[] bytes = scratch.bytes;
        int pos = scratch.offset;
        int end = pos + scratch.length;
        while (pos < end) {
            if (this.fst.findTargetArc(bytes[pos++] & 0xFF, arc, arc, bytesReader) == null) {
                return null;
            }
            output += ((Long)arc.output).longValue();
        }
        return output;
    }

    public Object get(CharSequence key) {
        if (this.fst == null) {
            return null;
        }
        FST.Arc arc = new FST.Arc();
        Long result = null;
        try {
            result = this.lookupPrefix(new BytesRef(key), (FST.Arc<Long>)arc);
        }
        catch (IOException bogus) {
            throw new RuntimeException(bogus);
        }
        if (result == null || !arc.isFinal()) {
            return null;
        }
        return WFSTCompletionLookup.decodeWeight(result + (Long)arc.nextFinalOutput);
    }

    private static int decodeWeight(long encoded) {
        return (int)(Integer.MAX_VALUE - encoded);
    }

    private static int encodeWeight(long value) {
        if (value < 0L || value > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("cannot encode value: " + value);
        }
        return Integer.MAX_VALUE - (int)value;
    }

    public long ramBytesUsed() {
        return this.fst == null ? 0L : this.fst.ramBytesUsed();
    }

    @Override
    public long getCount() {
        return this.count;
    }

    private final class WFSTInputIterator
    extends SortedInputIterator {
        WFSTInputIterator(InputIterator source) throws IOException {
            super(source);
            assert (!source.hasPayloads());
        }

        @Override
        protected void encode(OfflineSorter.ByteSequencesWriter writer, ByteArrayDataOutput output, byte[] buffer, BytesRef spare, BytesRef payload, Set<BytesRef> contexts, long weight) throws IOException {
            if (spare.length + 4 >= buffer.length) {
                buffer = ArrayUtil.grow((byte[])buffer, (int)(spare.length + 4));
            }
            output.reset(buffer);
            output.writeBytes(spare.bytes, spare.offset, spare.length);
            output.writeInt(WFSTCompletionLookup.encodeWeight(weight));
            writer.write(buffer, 0, output.getPosition());
        }

        @Override
        protected long decode(BytesRef scratch, ByteArrayDataInput tmpInput) {
            scratch.length -= 4;
            tmpInput.reset(scratch.bytes, scratch.offset + scratch.length, 4);
            return tmpInput.readInt();
        }
    }
}

