/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.extwriter;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.GroupDataBody;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.filter.DataSource;
import org.pentaho.reporting.engine.classic.core.filter.EmptyDataSource;
import org.pentaho.reporting.engine.classic.core.filter.templates.Template;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.GroupDataBodyType;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ClassFactoryCollector;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ObjectDescription;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ObjectFactoryException;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.datasource.DataSourceCollector;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.templates.TemplateCollector;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.templates.TemplateDescription;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.AbstractXMLDefinitionWriter;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.DataSourceWriter;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.FunctionsWriter;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterContext;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterException;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.StyleWriter;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.SubReportDefinitionWriter;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.TemplateWriter;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class ReportDescriptionWriter
extends AbstractXMLDefinitionWriter {
    public static final String BAND_TAG = "band";
    public static final String ELEMENT_TAG = "element";
    public static final String FIELDS_TAG = "fields";
    public static final String FIELD_TAG = "field";
    public static final String GROUP_HEADER_TAG = "group-header";
    public static final String GROUP_FOOTER_TAG = "group-footer";
    public static final String GROUP_TAG = "group";
    public static final String GROUPS_TAG = "groups";
    public static final String WATERMARK_TAG = "watermark";
    public static final String REPORT_DESCRIPTION_TAG = "report-description";
    public static final String REPORT_HEADER_TAG = "report-header";
    public static final String REPORT_FOOTER_TAG = "report-footer";
    public static final String PAGE_HEADER_TAG = "page-header";
    public static final String PAGE_FOOTER_TAG = "page-footer";
    public static final String ITEMBAND_TAG = "itemband";
    public static final String NO_DATA_BAND_TAG = "no-data-band";

    public ReportDescriptionWriter(ReportWriterContext reportWriter, XmlWriter indent) {
        super(reportWriter, indent);
    }

    @Override
    public void write() throws IOException, ReportWriterException {
        XmlWriter writer = this.getXmlWriter();
        writer.writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", REPORT_DESCRIPTION_TAG, false);
        this.writeRootBand(REPORT_HEADER_TAG, this.getReport().getReportHeader());
        this.writeRootBand(REPORT_FOOTER_TAG, this.getReport().getReportFooter());
        this.writeRootBand(PAGE_HEADER_TAG, this.getReport().getPageHeader());
        this.writeRootBand(PAGE_FOOTER_TAG, this.getReport().getPageFooter());
        this.writeRootBand(WATERMARK_TAG, this.getReport().getWatermark());
        this.writeGroups();
        GroupDataBody dataBody = (GroupDataBody)this.getReport().getChildElementByType(GroupDataBodyType.INSTANCE);
        if (dataBody != null) {
            this.writeRootBand(ITEMBAND_TAG, dataBody.getItemBand());
            this.writeRootBand(NO_DATA_BAND_TAG, dataBody.getNoDataBand());
        }
        writer.writeCloseTag();
    }

    private void writeSubReports(RootLevelBand band) throws IOException, ReportWriterException {
        int subReportCount = band.getSubReportCount();
        for (int i = 0; i < subReportCount; ++i) {
            SubReport sreport = band.getSubReport(i);
            ReportWriterContext context = new ReportWriterContext(sreport, this.getReportWriter());
            SubReportDefinitionWriter writer = new SubReportDefinitionWriter(context, this.getXmlWriter());
            writer.write();
        }
    }

    private void writeBand(String tagName, Band band) throws IOException, ReportWriterException {
        XmlWriter writer = this.getXmlWriter();
        if (band.getName().startsWith("anonymousBand@") || band.getName().startsWith("anonymousElement@")) {
            writer.writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", tagName, false);
        } else {
            writer.writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", tagName, "name", band.getName(), false);
        }
        this.writeStyleInfo(band);
        Element[] list = band.getElementArray();
        for (int i = 0; i < list.length; ++i) {
            if (list[i] instanceof Band) {
                Band b = (Band)list[i];
                this.writeBand(BAND_TAG, b);
                continue;
            }
            this.writeElement(list[i]);
        }
        if (band instanceof RootLevelBand) {
            this.writeSubReports((RootLevelBand)((Object)band));
        }
        writer.writeCloseTag();
    }

    private void writeStyleInfo(Element band) throws IOException, ReportWriterException {
        Map<StyleKey, Expression> styleExpressions;
        XmlWriter writer = this.getXmlWriter();
        ElementStyleSheet styleSheet = band.getStyle();
        if (!this.isStyleSheetEmpty(styleSheet)) {
            writer.writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "style", false);
            StyleWriter styleWriter = new StyleWriter(this.getReportWriter(), band.getStyle(), writer);
            styleWriter.write();
            writer.writeCloseTag();
        }
        if (!(styleExpressions = band.getStyleExpressions()).isEmpty()) {
            FunctionsWriter fnWriter = new FunctionsWriter(this.getReportWriter(), writer);
            for (Map.Entry<StyleKey, Expression> entry : styleExpressions.entrySet()) {
                StyleKey key = entry.getKey();
                Expression ex = entry.getValue();
                fnWriter.writeStyleExpression(ex, key);
            }
        }
    }

    private boolean isStyleSheetEmpty(ElementStyleSheet es) {
        StyleKey[] namesArray = es.getDefinedPropertyNamesArray();
        return namesArray.length == 0;
    }

    private void writeElement(Element element) throws IOException, ReportWriterException {
        AttributeList attList = new AttributeList();
        if (!element.getName().startsWith("anonymousElement@")) {
            attList.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "name", element.getName());
        }
        XmlWriter writer = this.getXmlWriter();
        writer.writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", ELEMENT_TAG, attList, false);
        this.writeStyleInfo(element);
        this.writeDataSourceForElement(element);
        writer.writeCloseTag();
    }

    protected void writeDataSourceForElement(Element element) throws ReportWriterException, IOException {
        Template template;
        if (element.getDataSource() instanceof EmptyDataSource) {
            return;
        }
        if (!(element.getDataSource() instanceof Template)) {
            this.writeDataSource(element.getDataSource());
            return;
        }
        TemplateCollector tc = this.getReportWriter().getTemplateCollector();
        TemplateDescription templateDescription = tc.getDescription(template = (Template)element.getDataSource());
        if (templateDescription == null) {
            throw new ReportWriterException("Unknown template type: " + template);
        }
        TemplateDescription parentTemplate = (TemplateDescription)templateDescription.getInstance();
        try {
            templateDescription.setParameterFromObject(template);
        }
        catch (ObjectFactoryException ofe) {
            throw new ReportWriterException("Error while preparing the template", ofe);
        }
        TemplateWriter templateWriter = new TemplateWriter(this.getReportWriter(), this.getXmlWriter(), templateDescription, parentTemplate);
        templateWriter.write();
    }

    private void writeDataSource(DataSource datasource) throws IOException, ReportWriterException {
        ReportWriterContext reportWriter = this.getReportWriter();
        ClassFactoryCollector classFactoryCollector = reportWriter.getClassFactoryCollector();
        ObjectDescription od = classFactoryCollector.getDescriptionForClass(datasource.getClass());
        if (od == null) {
            od = classFactoryCollector.getSuperClassObjectDescription(datasource.getClass(), null);
        }
        if (od == null) {
            throw new ReportWriterException("Unable to resolve DataSource: " + datasource.getClass());
        }
        DataSourceCollector dataSourceCollector = reportWriter.getDataSourceCollector();
        String dsname = dataSourceCollector.getDataSourceName(od);
        if (dsname == null) {
            throw new ReportWriterException("No name for DataSource " + datasource);
        }
        XmlWriter writer = this.getXmlWriter();
        writer.writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "datasource", "type", dsname, false);
        DataSourceWriter dsWriter = new DataSourceWriter(reportWriter, datasource, od, writer);
        dsWriter.write();
        writer.writeCloseTag();
    }

    private void writeGroups() throws IOException, ReportWriterException {
        XmlWriter writer = this.getXmlWriter();
        writer.writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", GROUPS_TAG, false);
        int groupSize = this.getReport().getGroupCount();
        for (int i = 0; i < groupSize; ++i) {
            RelationalGroup g = (RelationalGroup)this.getReport().getGroup(i);
            writer.writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", GROUP_TAG, "name", g.getName(), false);
            List<String> fields = g.getFields();
            if (!fields.isEmpty()) {
                writer.writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", FIELDS_TAG, false);
                for (int f = 0; f < fields.size(); ++f) {
                    String field = fields.get(f);
                    writer.writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", FIELD_TAG, false);
                    writer.writeTextNormalized(field, false);
                    writer.writeCloseTag();
                }
                writer.writeCloseTag();
            } else {
                writer.writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", FIELDS_TAG, true);
            }
            this.writeRootBand(GROUP_HEADER_TAG, g.getHeader());
            this.writeRootBand(GROUP_FOOTER_TAG, g.getFooter());
            writer.writeCloseTag();
        }
        writer.writeCloseTag();
    }

    private void writeRootBand(String tag, Band band) throws IOException, ReportWriterException {
        if (this.isEmptyRootBand(band)) {
            return;
        }
        this.writeBand(tag, band);
    }

    private boolean isEmptyRootBand(Band band) {
        RootLevelBand rlb;
        if (!band.getName().startsWith("anonymousBand@")) {
            return false;
        }
        if (!band.getName().startsWith("anonymousElement@")) {
            return false;
        }
        if (band.getElementCount() != 0) {
            return false;
        }
        if (band instanceof RootLevelBand && (rlb = (RootLevelBand)((Object)band)).getSubReportCount() > 0) {
            return false;
        }
        ElementStyleSheet styleSheet = band.getStyle();
        return this.isStyleSheetEmpty(styleSheet);
    }
}

