/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.style;

import java.util.List;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.layout.style.SimpleStyleSheet;
import org.pentaho.reporting.engine.classic.core.layout.style.StyleCache;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.libraries.base.util.LFUMap;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class DefaultStyleCache
implements StyleCache {
    private LFUMap<CacheKey, CacheCarrier> cache;
    private CacheKey lookupKey = new CacheKey();
    private List<StyleKey> validateKeys;
    private boolean validateCache;
    private int cacheHits;
    private int cacheMiss;
    private String name;

    public DefaultStyleCache(String name) {
        this();
        this.name = name;
    }

    public DefaultStyleCache() {
        this.cache = new LFUMap(500);
        this.validateCache = "true".equals(ClassicEngineBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.engine.classic.core.layout.style.ValidateStyleCacheResults"));
    }

    @Override
    public SimpleStyleSheet getStyleSheet(StyleSheet parent) {
        InstanceID id = parent.getId();
        String styleClass = parent.getClass().getName();
        this.lookupKey.setStyleClass(styleClass);
        this.lookupKey.setInstanceId(id);
        CacheCarrier cc = (CacheCarrier)this.cache.get((Object)this.lookupKey);
        if (cc == null) {
            CacheKey key = new CacheKey(id, styleClass);
            SimpleStyleSheet styleSheet = new SimpleStyleSheet(parent);
            this.cache.put((Object)key, (Object)new CacheCarrier(parent.getChangeTracker(), styleSheet));
            ++this.cacheMiss;
            return styleSheet;
        }
        if (cc.getChangeTracker() != parent.getChangeTracker()) {
            CacheKey key = new CacheKey(id, styleClass);
            SimpleStyleSheet styleSheet = new SimpleStyleSheet(parent);
            this.cache.put((Object)key, (Object)new CacheCarrier(parent.getChangeTracker(), styleSheet));
            ++this.cacheMiss;
            return styleSheet;
        }
        this.validateCacheResult(parent, cc.getStyleSheet());
        ++this.cacheHits;
        return cc.getStyleSheet();
    }

    private void validateCacheResult(StyleSheet s1, StyleSheet s2) {
        if (!this.validateCache) {
            return;
        }
        if (this.validateKeys == null) {
            this.validateKeys = StyleKey.getDefinedStyleKeysList();
        }
        for (StyleKey validateKey : this.validateKeys) {
            Object o2;
            Object o1 = s1.getStyleProperty(validateKey);
            if (ObjectUtilities.equal((Object)o1, (Object)(o2 = s2.getStyleProperty(validateKey)))) continue;
            throw new InvalidReportStateException("Cache-Failure on " + s1.getId() + " " + validateKey + " " + o1 + " vs " + o2 + " [" + s1.getChangeTracker() + "; " + s2.getChangeTracker() + "]");
        }
    }

    @Override
    public String printPerformanceStats() {
        int total = this.cacheHits + this.cacheMiss;
        return "StyleCache: " + this.name + " " + "Total=" + total + " Hits=" + this.cacheHits + " (" + 100.0f * (float)this.cacheHits / (float)Math.max(1, total) + "%)" + " Miss=" + this.cacheMiss + " (" + 100.0f * (float)this.cacheMiss / (float)Math.max(1, total) + "%)";
    }

    private static class CacheCarrier {
        private long changeTracker;
        private SimpleStyleSheet styleSheet;

        protected CacheCarrier(long changeTracker, SimpleStyleSheet styleSheet) {
            this.changeTracker = changeTracker;
            this.styleSheet = styleSheet;
        }

        public long getChangeTracker() {
            return this.changeTracker;
        }

        public SimpleStyleSheet getStyleSheet() {
            return this.styleSheet;
        }
    }

    private static class CacheKey {
        private InstanceID instanceId;
        private String styleClass;

        protected CacheKey() {
        }

        protected CacheKey(InstanceID instanceId, String styleClass) {
            if (instanceId == null) {
                throw new NullPointerException();
            }
            if (styleClass == null) {
                throw new NullPointerException();
            }
            this.instanceId = instanceId;
            this.styleClass = styleClass;
        }

        public Object getInstanceId() {
            return this.instanceId;
        }

        public void setInstanceId(InstanceID instanceId) {
            if (instanceId == null) {
                throw new NullPointerException();
            }
            this.instanceId = instanceId;
        }

        public String getStyleClass() {
            return this.styleClass;
        }

        public void setStyleClass(String styleClass) {
            this.styleClass = styleClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (!this.instanceId.equals(cacheKey.instanceId)) {
                return false;
            }
            return this.styleClass.equals(cacheKey.styleClass);
        }

        public int hashCode() {
            int result = this.instanceId.hashCode();
            result = 31 * result + this.styleClass.hashCode();
            return result;
        }

        public String toString() {
            return "CacheKey{instanceId=" + this.instanceId + ", styleClass='" + this.styleClass + '\'' + '}';
        }
    }
}

