/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.pentaho.reporting.engine.classic.core.PerformanceTags;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.states.PerformanceMonitorContext;
import org.pentaho.reporting.libraries.base.util.EmptyPerformanceLoggingStopWatch;
import org.pentaho.reporting.libraries.base.util.PerformanceLoggingStopWatch;

public abstract class IterateVisualProcessStep {
    private PerformanceLoggingStopWatch summaryWatch = EmptyPerformanceLoggingStopWatch.INSTANCE;
    private PerformanceLoggingStopWatch eventWatch = EmptyPerformanceLoggingStopWatch.INSTANCE;

    protected IterateVisualProcessStep() {
    }

    public void initializePerformanceMonitoring(PerformanceMonitorContext monitorContext) {
        this.summaryWatch.stop();
        this.eventWatch.stop();
        this.summaryWatch = monitorContext.createStopWatch(PerformanceTags.getSummaryTag("pentaho.report.processing.layout.process.", this.getClass().getSimpleName()));
        this.eventWatch = monitorContext.createStopWatch(PerformanceTags.getDetailTag("pentaho.report.processing.layout.process.", this.getClass().getSimpleName()));
    }

    public void close() {
        this.summaryWatch.close();
        this.eventWatch.close();
    }

    protected PerformanceLoggingStopWatch getSummaryWatch() {
        return this.summaryWatch;
    }

    protected PerformanceLoggingStopWatch getEventWatch() {
        return this.eventWatch;
    }

    protected final void startProcessing(RenderNode node) {
        RenderBox parent = node.getParent();
        if (parent == null) {
            this.processBlockLevelChild(node);
            return;
        }
        int parentType = parent.getLayoutNodeType();
        if ((parentType & 0x12) == 18) {
            this.processBlockLevelChild(node);
        } else if ((parentType & 0x22) == 34) {
            this.processCanvasLevelChild(node);
        } else if ((parentType & 0x42) == 66) {
            this.processInlineLevelChild(node);
        } else if ((parentType & 0x82) == 130) {
            this.processRowLevelChild(node);
        } else if (parentType == 266242) {
            this.processTableChild(node);
        } else if (parentType == 270338) {
            this.processTableSectionChild(node);
        } else if (parentType == 278530) {
            this.processTableRowChild(node);
        } else if (parentType == 294914) {
            this.processTableCellChild(node);
        } else if (parentType == 393218) {
            this.processTableColChild(node);
        } else if (parentType == 327682) {
            this.processTableColGroupChild(node);
        } else {
            this.processOtherLevelChild(node);
        }
    }

    protected final void processTableChild(RenderNode node) {
        int type = node.getNodeType();
        if ((type & 2) == 2) {
            RenderBox box = (RenderBox)node;
            if (this.startTableLevelBox(box)) {
                this.processBoxChilds(box);
            }
            this.finishTableLevelBox(box);
        } else {
            this.processTableLevelNode(node);
        }
    }

    protected void processTableLevelNode(RenderNode node) {
    }

    protected void finishTableLevelBox(RenderBox box) {
    }

    protected boolean startTableLevelBox(RenderBox box) {
        return true;
    }

    protected final void processTableRowChild(RenderNode node) {
        int type = node.getNodeType();
        if ((type & 2) == 2) {
            RenderBox box = (RenderBox)node;
            if (this.startTableRowLevelBox(box)) {
                this.processBoxChilds(box);
            }
            this.finishTableRowLevelBox(box);
        } else {
            this.processTableRowLevelNode(node);
        }
    }

    protected void processTableRowLevelNode(RenderNode node) {
    }

    protected void finishTableRowLevelBox(RenderBox box) {
    }

    protected boolean startTableRowLevelBox(RenderBox box) {
        return true;
    }

    protected final void processTableSectionChild(RenderNode node) {
        int type = node.getNodeType();
        if ((type & 2) == 2) {
            RenderBox box = (RenderBox)node;
            if (this.startTableSectionLevelBox(box)) {
                this.processBoxChilds(box);
            }
            this.finishTableSectionLevelBox(box);
        } else {
            this.processTableSectionLevelNode(node);
        }
    }

    protected void processTableSectionLevelNode(RenderNode node) {
    }

    protected void finishTableSectionLevelBox(RenderBox box) {
    }

    protected boolean startTableSectionLevelBox(RenderBox box) {
        return true;
    }

    protected final void processTableCellChild(RenderNode node) {
        int type = node.getNodeType();
        if (type == 274) {
            ParagraphRenderBox box = (ParagraphRenderBox)node;
            if (this.startTableCellLevelBox(box)) {
                this.processParagraphChilds(box);
            }
            this.finishTableCellLevelBox(box);
        } else if ((type & 2) == 2) {
            RenderBox box = (RenderBox)node;
            if (this.startTableCellLevelBox(box)) {
                this.processBoxChilds(box);
            }
            this.finishTableCellLevelBox(box);
        } else {
            this.processTableCellLevelNode(node);
        }
    }

    protected void processTableCellLevelNode(RenderNode node) {
    }

    protected void finishTableCellLevelBox(RenderBox box) {
    }

    protected boolean startTableCellLevelBox(RenderBox box) {
        return true;
    }

    protected final void processTableColChild(RenderNode node) {
        int type = node.getNodeType();
        if ((type & 2) == 2) {
            RenderBox box = (RenderBox)node;
            if (this.startTableColLevelBox(box)) {
                this.processBoxChilds(box);
            }
            this.finishTableColLevelBox(box);
        } else {
            this.processTableColLevelNode(node);
        }
    }

    protected void processTableColLevelNode(RenderNode node) {
    }

    protected void finishTableColLevelBox(RenderBox box) {
    }

    protected boolean startTableColLevelBox(RenderBox box) {
        return true;
    }

    protected final void processTableColGroupChild(RenderNode node) {
        int type = node.getNodeType();
        if ((type & 2) == 2) {
            RenderBox box = (RenderBox)node;
            if (this.startTableColGroupLevelBox(box)) {
                this.processBoxChilds(box);
            }
            this.finishTableColGroupLevelBox(box);
        } else {
            this.processTableColGroupLevelNode(node);
        }
    }

    protected void processTableColGroupLevelNode(RenderNode node) {
    }

    protected void finishTableColGroupLevelBox(RenderBox box) {
    }

    protected boolean startTableColGroupLevelBox(RenderBox box) {
        return true;
    }

    protected void processOtherLevelChild(RenderNode node) {
    }

    protected void processInlineLevelNode(RenderNode node) {
    }

    protected boolean startInlineLevelBox(RenderBox box) {
        return true;
    }

    protected void finishInlineLevelBox(RenderBox box) {
    }

    protected final void processInlineLevelChild(RenderNode node) {
        int type = node.getNodeType();
        if (type == 274) {
            ParagraphRenderBox box = (ParagraphRenderBox)node;
            if (this.startInlineLevelBox(box)) {
                this.processParagraphChilds(box);
            }
            this.finishInlineLevelBox(box);
        } else if ((type & 2) == 2) {
            RenderBox box = (RenderBox)node;
            if (this.startInlineLevelBox(box)) {
                this.processBoxChilds(box);
            }
            this.finishInlineLevelBox(box);
        } else {
            this.processInlineLevelNode(node);
        }
    }

    protected void processCanvasLevelNode(RenderNode node) {
    }

    protected boolean startCanvasLevelBox(RenderBox box) {
        return true;
    }

    protected void finishCanvasLevelBox(RenderBox box) {
    }

    protected final void processCanvasLevelChild(RenderNode node) {
        int nodeType = node.getNodeType();
        if (nodeType == 274) {
            ParagraphRenderBox box = (ParagraphRenderBox)node;
            if (this.startCanvasLevelBox(box)) {
                this.processParagraphChilds(box);
            }
            this.finishCanvasLevelBox(box);
        } else if ((nodeType & 2) == 2) {
            RenderBox box = (RenderBox)node;
            if (this.startCanvasLevelBox(box)) {
                this.processBoxChilds(box);
            }
            this.finishCanvasLevelBox(box);
        } else {
            this.processCanvasLevelNode(node);
        }
    }

    protected void processBlockLevelNode(RenderNode node) {
    }

    protected boolean startBlockLevelBox(RenderBox box) {
        return true;
    }

    protected void finishBlockLevelBox(RenderBox box) {
    }

    protected final void processBlockLevelChild(RenderNode node) {
        int nodeType = node.getLayoutNodeType();
        if (nodeType == 1042) {
            LogicalPageBox box = (LogicalPageBox)node;
            if (this.startBlockLevelBox(box)) {
                this.startProcessing(box.getWatermarkArea());
                this.startProcessing(box.getHeaderArea());
                this.processBoxChilds(box);
                this.startProcessing(box.getRepeatFooterArea());
                this.startProcessing(box.getFooterArea());
            }
            this.finishBlockLevelBox(box);
        } else if (nodeType == 274) {
            ParagraphRenderBox box = (ParagraphRenderBox)node;
            if (this.startBlockLevelBox(box)) {
                this.processParagraphChilds(box);
            }
            this.finishBlockLevelBox(box);
        } else if ((nodeType & 2) == 2) {
            RenderBox box = (RenderBox)node;
            if (this.startBlockLevelBox(box)) {
                this.processBoxChilds(box);
            }
            this.finishBlockLevelBox(box);
        } else {
            this.processBlockLevelNode(node);
        }
    }

    protected abstract void processParagraphChilds(ParagraphRenderBox var1);

    protected void processBoxChilds(RenderBox box) {
        for (RenderNode node = box.getFirstChild(); node != null; node = node.getNext()) {
            this.startProcessing(node);
        }
    }

    protected final void processRowLevelChild(RenderNode node) {
        int nodeType = node.getNodeType();
        if (nodeType == 274) {
            ParagraphRenderBox box = (ParagraphRenderBox)node;
            if (this.startRowLevelBox(box)) {
                this.processParagraphChilds(box);
            }
            this.finishRowLevelBox(box);
        } else if ((nodeType & 2) == 2) {
            RenderBox box = (RenderBox)node;
            if (this.startRowLevelBox(box)) {
                this.processBoxChilds(box);
            }
            this.finishRowLevelBox(box);
        } else {
            this.processRowLevelNode(node);
        }
    }

    protected void processRowLevelNode(RenderNode node) {
    }

    protected boolean startRowLevelBox(RenderBox box) {
        return true;
    }

    protected void finishRowLevelBox(RenderBox box) {
    }
}

