/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter.types;

import java.util.Locale;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.filter.FormatSpecification;
import org.pentaho.reporting.engine.classic.core.filter.RawDataSource;
import org.pentaho.reporting.engine.classic.core.filter.types.AbstractElementType;
import org.pentaho.reporting.engine.classic.core.filter.types.ElementTypeUtils;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.formatting.FastDecimalFormat;

public class NumberFieldType
extends AbstractElementType
implements RawDataSource {
    public static final NumberFieldType INSTANCE = new NumberFieldType();
    private static final String DECIMALFORMAT_DEFAULT_PATTERN = "#,###.##############################################################################################################################################################################################################################";

    public NumberFieldType() {
        super("number-field");
    }

    @Override
    public Object getDesignValue(ExpressionRuntime runtime, ReportElement element) {
        Object staticValue = ElementTypeUtils.queryStaticValue(element);
        if (staticValue instanceof Number) {
            Object formatStringRaw = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "format-string");
            if (formatStringRaw == null || "".equals(formatStringRaw)) {
                formatStringRaw = DECIMALFORMAT_DEFAULT_PATTERN;
            }
            try {
                Locale locale = runtime.getResourceBundleFactory().getLocale();
                FastDecimalFormat decimalFormat = new FastDecimalFormat(String.valueOf(formatStringRaw), locale);
                return decimalFormat.format(staticValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ElementTypeUtils.queryFieldName(element);
    }

    @Override
    public Object getRawValue(ExpressionRuntime runtime, ReportElement element) {
        if (runtime == null) {
            throw new NullPointerException("Runtime must never be null.");
        }
        if (element == null) {
            throw new NullPointerException("Element must never be null.");
        }
        Object retval = ElementTypeUtils.queryFieldOrValue(runtime, element);
        if (!(retval instanceof Number)) {
            return element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value");
        }
        return retval;
    }

    @Override
    public FormatSpecification getFormatString(ExpressionRuntime runtime, ReportElement element, FormatSpecification formatSpecification) {
        Object formatStringRaw;
        if (formatSpecification == null) {
            formatSpecification = new FormatSpecification();
        }
        if ((formatStringRaw = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "format-string")) == null) {
            formatSpecification.redefine(0, null);
        } else {
            formatSpecification.redefine(2, String.valueOf(formatStringRaw));
        }
        return formatSpecification;
    }

    @Override
    public void configureDesignTimeDefaults(ReportElement element, Locale locale) {
    }

    @Override
    public Object getValue(ExpressionRuntime runtime, ReportElement element) {
        if (runtime == null) {
            throw new NullPointerException("Runtime must never be null.");
        }
        if (element == null) {
            throw new NullPointerException("Element must never be null.");
        }
        Object retval = ElementTypeUtils.queryFieldOrValue(runtime, element);
        if (!(retval instanceof Number)) {
            return element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value");
        }
        Object formatStringRaw = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "format-string");
        if (formatStringRaw == null || "".equals(formatStringRaw)) {
            formatStringRaw = DECIMALFORMAT_DEFAULT_PATTERN;
        }
        try {
            Locale locale = runtime.getResourceBundleFactory().getLocale();
            NumberFieldTypeContext context = element.getElementContext(NumberFieldTypeContext.class);
            if (context.decimalFormat == null) {
                context.formatString = String.valueOf(formatStringRaw);
                context.locale = locale;
                context.decimalFormat = new FastDecimalFormat(context.formatString, locale);
            } else if (!ObjectUtilities.equal((Object)context.formatString, (Object)formatStringRaw) || !ObjectUtilities.equal((Object)context.locale, (Object)locale)) {
                context.formatString = String.valueOf(formatStringRaw);
                context.locale = locale;
                context.decimalFormat = new FastDecimalFormat(context.formatString, locale);
            }
            return context.decimalFormat.format(retval);
        }
        catch (Exception e) {
            return element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value");
        }
    }

    public static class NumberFieldTypeContext {
        public ElementMetaData elementType;
        public FastDecimalFormat decimalFormat;
        public Locale locale;
        public String formatString;
    }
}

