/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.oozie.util.XLog;

public class HCatCredentialHelper {
    private static final String USER_NAME = "user.name";
    private static final String HIVE_METASTORE_SASL_ENABLED = "hive.metastore.sasl.enabled";
    private static final String HIVE_METASTORE_KERBEROS_PRINCIPAL = "hive.metastore.kerberos.principal";
    private static final String HIVE_METASTORE_LOCAL = "hive.metastore.local";
    private static final String HADOOP_RPC_PROTECTION = "hadoop.rpc.protection";

    public void set(JobConf launcherJobConf, String principal, String server) throws Exception {
        try {
            HiveMetaStoreClient client = this.getHCatClient(launcherJobConf, principal, server);
            XLog.getLog(this.getClass()).debug("HCatCredentialHelper: set: User name for which token will be asked from HCat: " + launcherJobConf.get(USER_NAME));
            String tokenStrForm = client.getDelegationToken(launcherJobConf.get(USER_NAME), UserGroupInformation.getLoginUser().getShortUserName());
            Token hcatToken = new Token();
            hcatToken.decodeFromUrlString(tokenStrForm);
            launcherJobConf.getCredentials().addToken(new Text("HCat Token"), hcatToken);
            XLog.getLog(this.getClass()).debug("Added the HCat token in job conf");
        }
        catch (Exception ex) {
            XLog.getLog(this.getClass()).debug("set Exception" + ex.getMessage());
            throw ex;
        }
    }

    public HiveMetaStoreClient getHCatClient(JobConf launcherJobConf, String principal, String server) throws MetaException {
        HiveConf hiveConf = null;
        HiveMetaStoreClient hiveclient = null;
        hiveConf = new HiveConf();
        XLog.getLog(this.getClass()).debug("getHCatClient: Principal: " + principal + " Server: " + server);
        hiveConf.set(HIVE_METASTORE_SASL_ENABLED, "true");
        hiveConf.set(HIVE_METASTORE_KERBEROS_PRINCIPAL, principal);
        hiveConf.set(HIVE_METASTORE_LOCAL, "false");
        hiveConf.set(HiveConf.ConfVars.METASTOREURIS.varname, server);
        String protection = launcherJobConf.get(HADOOP_RPC_PROTECTION, SaslRpcServer.QualityOfProtection.AUTHENTICATION.name().toLowerCase());
        XLog.getLog(this.getClass()).debug("getHCatClient, setting rpc protection to " + protection);
        hiveConf.set(HADOOP_RPC_PROTECTION, protection);
        hiveclient = new HiveMetaStoreClient(hiveConf);
        return hiveclient;
    }
}

