/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.util.ClassSize;

@InterfaceAudience.Private
public class ScanInfo {
    private byte[] family;
    private int minVersions;
    private int maxVersions;
    private long ttl;
    private KeepDeletedCells keepDeletedCells;
    private long timeToPurgeDeletes;
    private KeyValue.KVComparator comparator;
    public static final long FIXED_OVERHEAD = ClassSize.align((int)(ClassSize.OBJECT + 2 * ClassSize.REFERENCE + 8 + 16 + 1));

    public ScanInfo(HColumnDescriptor family, long ttl, long timeToPurgeDeletes, KeyValue.KVComparator comparator) {
        this(family.getName(), family.getMinVersions(), family.getMaxVersions(), ttl, family.getKeepDeletedCellsAsEnum(), timeToPurgeDeletes, comparator);
    }

    public ScanInfo(byte[] family, int minVersions, int maxVersions, long ttl, KeepDeletedCells keepDeletedCells, long timeToPurgeDeletes, KeyValue.KVComparator comparator) {
        this.family = family;
        this.minVersions = minVersions;
        this.maxVersions = maxVersions;
        this.ttl = ttl;
        this.keepDeletedCells = keepDeletedCells;
        this.timeToPurgeDeletes = timeToPurgeDeletes;
        this.comparator = comparator;
    }

    public byte[] getFamily() {
        return this.family;
    }

    public int getMinVersions() {
        return this.minVersions;
    }

    public int getMaxVersions() {
        return this.maxVersions;
    }

    public long getTtl() {
        return this.ttl;
    }

    public KeepDeletedCells getKeepDeletedCells() {
        return this.keepDeletedCells;
    }

    public long getTimeToPurgeDeletes() {
        return this.timeToPurgeDeletes;
    }

    public KeyValue.KVComparator getComparator() {
        return this.comparator;
    }
}

