/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.protobuf.Service;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.quotas.MasterQuotaManager;

@InterfaceAudience.Private
public interface MasterServices
extends Server {
    public AssignmentManager getAssignmentManager();

    public MasterFileSystem getMasterFileSystem();

    public ServerManager getServerManager();

    public ExecutorService getExecutorService();

    public TableLockManager getTableLockManager();

    public MasterCoprocessorHost getMasterCoprocessorHost();

    public MasterQuotaManager getMasterQuotaManager();

    public void checkTableModifiable(TableName var1) throws IOException, TableNotFoundException, TableNotDisabledException;

    public void createTable(HTableDescriptor var1, byte[][] var2) throws IOException;

    public void deleteTable(TableName var1) throws IOException;

    public void truncateTable(TableName var1, boolean var2) throws IOException;

    public void modifyTable(TableName var1, HTableDescriptor var2) throws IOException;

    public void enableTable(TableName var1) throws IOException;

    public void disableTable(TableName var1) throws IOException;

    public void addColumn(TableName var1, HColumnDescriptor var2) throws IOException;

    public void modifyColumn(TableName var1, HColumnDescriptor var2) throws IOException;

    public void deleteColumn(TableName var1, byte[] var2) throws IOException;

    public TableDescriptors getTableDescriptors();

    public boolean isServerShutdownHandlerEnabled();

    public boolean registerService(Service var1);

    public void dispatchMergingRegions(HRegionInfo var1, HRegionInfo var2, boolean var3) throws IOException;

    public boolean isInitialized();

    public void createNamespace(NamespaceDescriptor var1) throws IOException;

    public void modifyNamespace(NamespaceDescriptor var1) throws IOException;

    public void deleteNamespace(String var1) throws IOException;

    public NamespaceDescriptor getNamespaceDescriptor(String var1) throws IOException;

    public List<NamespaceDescriptor> listNamespaceDescriptors() throws IOException;

    public List<HTableDescriptor> listTableDescriptorsByNamespace(String var1) throws IOException;

    public List<TableName> listTableNamesByNamespace(String var1) throws IOException;
}

