/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.addxml;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.addxml.AddXMLMeta;
import org.pentaho.di.trans.steps.addxml.XMLField;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.step.TableItemInsertListener;

public class AddXMLDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = AddXMLMeta.class;
    private CTabFolder wTabFolder;
    private FormData fdTabFolder;
    private CTabItem wContentTab;
    private CTabItem wFieldsTab;
    private FormData fdContentComp;
    private FormData fdFieldsComp;
    private Label wlOmitXMLHeader;
    private Button wOmitXMLHeader;
    private FormData fdlOmitXMLHeader;
    private FormData fdOmitXMLHeader;
    private Label wlOmitNullValues;
    private Button wOmitNullValues;
    private FormData fdlOmitNullValues;
    private FormData fdOmitNullValues;
    private Label wlEncoding;
    private CCombo wEncoding;
    private FormData fdlEncoding;
    private FormData fdEncoding;
    private Label wlOutputValue;
    private CCombo wOutputValue;
    private FormData fdlOutputValue;
    private FormData fdOutputValue;
    private Label wlRepeatElement;
    private CCombo wRepeatElement;
    private FormData fdlRepeatElement;
    private FormData fdRepeatElement;
    private TableView wFields;
    private FormData fdFields;
    private AddXMLMeta input;
    private Button wMinWidth;
    private Listener lsMinWidth;
    private boolean gotEncodings = false;
    private ColumnInfo[] colinf;
    private Map<String, Integer> inputFields;

    public AddXMLDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (AddXMLMeta)((Object)in);
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        int x;
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddXMLDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"AddXMLDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"System.Label.StepName", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.wContentTab = new CTabItem(this.wTabFolder, 0);
        this.wContentTab.setText(BaseMessages.getString(PKG, (String)"AddXMLDialog.ContentTab.TabTitle", (String[])new String[0]));
        FormLayout contentLayout = new FormLayout();
        contentLayout.marginWidth = 3;
        contentLayout.marginHeight = 3;
        Composite wContentComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wContentComp);
        wContentComp.setLayout((Layout)contentLayout);
        this.wlEncoding = new Label(wContentComp, 131072);
        this.wlEncoding.setText(BaseMessages.getString(PKG, (String)"AddXMLDialog.Encoding.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlEncoding);
        this.fdlEncoding = new FormData();
        this.fdlEncoding.left = new FormAttachment(0, 0);
        this.fdlEncoding.top = new FormAttachment(null, margin);
        this.fdlEncoding.right = new FormAttachment(middle, -margin);
        this.wlEncoding.setLayoutData((Object)this.fdlEncoding);
        this.wEncoding = new CCombo(wContentComp, 2056);
        this.wEncoding.setEditable(true);
        this.props.setLook((Control)this.wEncoding);
        this.wEncoding.addModifyListener(lsMod);
        this.fdEncoding = new FormData();
        this.fdEncoding.left = new FormAttachment(middle, 0);
        this.fdEncoding.top = new FormAttachment(null, margin);
        this.fdEncoding.right = new FormAttachment(100, 0);
        this.wEncoding.setLayoutData((Object)this.fdEncoding);
        this.wEncoding.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)AddXMLDialog.this.shell.getDisplay(), 1);
                AddXMLDialog.this.shell.setCursor(busy);
                AddXMLDialog.this.setEncodings();
                AddXMLDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        this.wlOutputValue = new Label(wContentComp, 131072);
        this.wlOutputValue.setText(BaseMessages.getString(PKG, (String)"AddXMLDialog.OutputValue.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlOutputValue);
        this.fdlOutputValue = new FormData();
        this.fdlOutputValue.left = new FormAttachment(0, 0);
        this.fdlOutputValue.top = new FormAttachment((Control)this.wEncoding, margin);
        this.fdlOutputValue.right = new FormAttachment(middle, -margin);
        this.wlOutputValue.setLayoutData((Object)this.fdlOutputValue);
        this.wOutputValue = new CCombo(wContentComp, 2056);
        this.wOutputValue.setEditable(true);
        this.props.setLook((Control)this.wOutputValue);
        this.wOutputValue.addModifyListener(lsMod);
        this.fdOutputValue = new FormData();
        this.fdOutputValue.left = new FormAttachment(middle, 0);
        this.fdOutputValue.top = new FormAttachment((Control)this.wEncoding, margin);
        this.fdOutputValue.right = new FormAttachment(100, 0);
        this.wOutputValue.setLayoutData((Object)this.fdOutputValue);
        this.wlRepeatElement = new Label(wContentComp, 131072);
        this.wlRepeatElement.setText(BaseMessages.getString(PKG, (String)"AddXMLDialog.RepeatElement.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlRepeatElement);
        this.fdlRepeatElement = new FormData();
        this.fdlRepeatElement.left = new FormAttachment(0, 0);
        this.fdlRepeatElement.top = new FormAttachment((Control)this.wOutputValue, margin);
        this.fdlRepeatElement.right = new FormAttachment(middle, -margin);
        this.wlRepeatElement.setLayoutData((Object)this.fdlRepeatElement);
        this.wRepeatElement = new CCombo(wContentComp, 2056);
        this.wRepeatElement.setEditable(true);
        this.props.setLook((Control)this.wRepeatElement);
        this.wRepeatElement.addModifyListener(lsMod);
        this.fdRepeatElement = new FormData();
        this.fdRepeatElement.left = new FormAttachment(middle, 0);
        this.fdRepeatElement.top = new FormAttachment((Control)this.wOutputValue, margin);
        this.fdRepeatElement.right = new FormAttachment(100, 0);
        this.wRepeatElement.setLayoutData((Object)this.fdRepeatElement);
        this.wlOmitXMLHeader = new Label(wContentComp, 131072);
        this.wlOmitXMLHeader.setText(BaseMessages.getString(PKG, (String)"AddXMLDialog.OmitXMLHeader.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlOmitXMLHeader);
        this.fdlOmitXMLHeader = new FormData();
        this.fdlOmitXMLHeader.left = new FormAttachment(0, 0);
        this.fdlOmitXMLHeader.top = new FormAttachment((Control)this.wRepeatElement, margin);
        this.fdlOmitXMLHeader.right = new FormAttachment(middle, -margin);
        this.wlOmitXMLHeader.setLayoutData((Object)this.fdlOmitXMLHeader);
        this.wOmitXMLHeader = new Button(wContentComp, 32);
        this.props.setLook((Control)this.wOmitXMLHeader);
        this.fdOmitXMLHeader = new FormData();
        this.fdOmitXMLHeader.left = new FormAttachment(middle, 0);
        this.fdOmitXMLHeader.top = new FormAttachment((Control)this.wRepeatElement, margin);
        this.fdOmitXMLHeader.right = new FormAttachment(100, 0);
        this.wOmitXMLHeader.setLayoutData((Object)this.fdOmitXMLHeader);
        this.wOmitXMLHeader.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddXMLDialog.this.input.setChanged();
            }
        });
        this.wlOmitNullValues = new Label(wContentComp, 131072);
        this.wlOmitNullValues.setText(BaseMessages.getString(PKG, (String)"AddXMLDialog.OmitNullValues.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlOmitNullValues);
        this.fdlOmitNullValues = new FormData();
        this.fdlOmitNullValues.left = new FormAttachment(0, 0);
        this.fdlOmitNullValues.top = new FormAttachment((Control)this.wOmitXMLHeader, margin);
        this.fdlOmitNullValues.right = new FormAttachment(middle, -margin);
        this.wlOmitNullValues.setLayoutData((Object)this.fdlOmitNullValues);
        this.wOmitNullValues = new Button(wContentComp, 32);
        this.props.setLook((Control)this.wOmitNullValues);
        this.fdOmitNullValues = new FormData();
        this.fdOmitNullValues.left = new FormAttachment(middle, 0);
        this.fdOmitNullValues.top = new FormAttachment((Control)this.wOmitXMLHeader, margin);
        this.fdOmitNullValues.right = new FormAttachment(100, 0);
        this.wOmitNullValues.setLayoutData((Object)this.fdOmitNullValues);
        this.wOmitNullValues.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddXMLDialog.this.input.setChanged();
            }
        });
        this.fdContentComp = new FormData();
        this.fdContentComp.left = new FormAttachment(0, 0);
        this.fdContentComp.top = new FormAttachment(0, 0);
        this.fdContentComp.right = new FormAttachment(100, 0);
        this.fdContentComp.bottom = new FormAttachment(100, 0);
        wContentComp.setLayoutData((Object)this.fdContentComp);
        wContentComp.layout();
        this.wContentTab.setControl((Control)wContentComp);
        this.wFieldsTab = new CTabItem(this.wTabFolder, 0);
        this.wFieldsTab.setText(BaseMessages.getString(PKG, (String)"AddXMLDialog.FieldsTab.TabTitle", (String[])new String[0]));
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginWidth = 5;
        fieldsLayout.marginHeight = 5;
        Composite wFieldsComp = new Composite((Composite)this.wTabFolder, 0);
        wFieldsComp.setLayout((Layout)fieldsLayout);
        this.props.setLook((Control)wFieldsComp);
        this.wGet = new Button(wFieldsComp, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"AddXMLDialog.Get.Button", (String[])new String[0]));
        this.wGet.setToolTipText(BaseMessages.getString(PKG, (String)"AddXMLDialog.Get.Tooltip", (String[])new String[0]));
        this.wMinWidth = new Button(wFieldsComp, 8);
        this.wMinWidth.setText(BaseMessages.getString(PKG, (String)"AddXMLDialog.MinWidth.Label", (String[])new String[0]));
        this.wMinWidth.setToolTipText(BaseMessages.getString(PKG, (String)"AddXMLDialog.MinWidth.Tooltip", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wGet, this.wMinWidth}, margin, null);
        int FieldsRows = this.input.getOutputFields().length;
        String[] dats = Const.getDateFormats();
        String[] nums = Const.getNumberFormats();
        int totsize = dats.length + nums.length;
        String[] formats = new String[totsize];
        for (x = 0; x < dats.length; ++x) {
            formats[x] = dats[x];
        }
        for (x = 0; x < nums.length; ++x) {
            formats[dats.length + x] = nums[x];
        }
        this.colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"AddXMLDialog.Fieldname.Column", (String[])new String[0]), 2, new String[]{""}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"AddXMLDialog.ElementName.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"AddXMLDialog.Type.Column", (String[])new String[0]), 2, ValueMeta.getTypes()), new ColumnInfo(BaseMessages.getString(PKG, (String)"AddXMLDialog.Format.Column", (String[])new String[0]), 2, formats), new ColumnInfo(BaseMessages.getString(PKG, (String)"AddXMLDialog.Length.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"AddXMLDialog.Precision.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"AddXMLDialog.Currency.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"AddXMLDialog.Decimal.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"AddXMLDialog.Group.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"AddXMLDialog.Null.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"AddXMLDialog.Attribute.Column", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0])}, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"AddXMLDialog.AttributeParentName.Column", (String[])new String[0]), 1, false)};
        this.wFields = new TableView((VariableSpace)this.transMeta, wFieldsComp, 67586, this.colinf, FieldsRows, lsMod, this.props);
        this.fdFields = new FormData();
        this.fdFields.left = new FormAttachment(0, 0);
        this.fdFields.top = new FormAttachment(0, 0);
        this.fdFields.right = new FormAttachment(100, 0);
        this.fdFields.bottom = new FormAttachment((Control)this.wGet, -margin);
        this.wFields.setLayoutData((Object)this.fdFields);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                StepMeta stepMeta = AddXMLDialog.this.transMeta.findStep(AddXMLDialog.this.stepname);
                if (stepMeta != null) {
                    try {
                        RowMetaInterface row = AddXMLDialog.this.transMeta.getPrevStepFields(stepMeta);
                        for (int i = 0; i < row.size(); ++i) {
                            AddXMLDialog.this.inputFields.put(row.getValueMeta(i).getName(), i);
                        }
                        AddXMLDialog.this.setComboBoxes();
                    }
                    catch (KettleException e) {
                        AddXMLDialog.this.logError(BaseMessages.getString((Class)PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                    }
                }
            }
        };
        new Thread(runnable).start();
        this.fdFieldsComp = new FormData();
        this.fdFieldsComp.left = new FormAttachment(0, 0);
        this.fdFieldsComp.top = new FormAttachment(0, 0);
        this.fdFieldsComp.right = new FormAttachment(100, 0);
        this.fdFieldsComp.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)this.fdFieldsComp);
        wFieldsComp.layout();
        this.wFieldsTab.setControl((Control)wFieldsComp);
        this.fdTabFolder = new FormData();
        this.fdTabFolder.left = new FormAttachment(0, 0);
        this.fdTabFolder.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdTabFolder.right = new FormAttachment(100, 0);
        this.fdTabFolder.bottom = new FormAttachment(100, -50);
        this.wTabFolder.setLayoutData((Object)this.fdTabFolder);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, margin, (Control)this.wTabFolder);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                AddXMLDialog.this.ok();
            }
        };
        this.lsGet = new Listener(){

            public void handleEvent(Event e) {
                AddXMLDialog.this.get();
            }
        };
        this.lsMinWidth = new Listener(){

            public void handleEvent(Event e) {
                AddXMLDialog.this.setMinimalWidth();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                AddXMLDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wGet.addListener(13, this.lsGet);
        this.wMinWidth.addListener(13, this.lsMinWidth);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                AddXMLDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                AddXMLDialog.this.cancel();
            }
        });
        this.lsResize = new Listener(){

            public void handleEvent(Event event) {
                Point size = AddXMLDialog.this.shell.getSize();
                AddXMLDialog.this.wFields.setSize(size.x - 10, size.y - 50);
                ((AddXMLDialog)AddXMLDialog.this).wFields.table.setSize(size.x - 10, size.y - 50);
                AddXMLDialog.this.wFields.redraw();
            }
        };
        this.shell.addListener(11, this.lsResize);
        this.wTabFolder.setSelection(0);
        this.setSize();
        this.getData();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.colinf[0].setComboValues(fieldNames);
    }

    private void setEncodings() {
        if (!this.gotEncodings) {
            this.gotEncodings = true;
            this.wEncoding.removeAll();
            ArrayList<Charset> values = new ArrayList<Charset>(Charset.availableCharsets().values());
            for (int i = 0; i < values.size(); ++i) {
                Charset charSet = (Charset)values.get(i);
                this.wEncoding.add(charSet.displayName());
            }
            String defEncoding = Const.getEnvironmentVariable((String)"file.encoding", (String)"UTF-8");
            int idx = Const.indexOfString((String)defEncoding, (String[])this.wEncoding.getItems());
            if (idx >= 0) {
                this.wEncoding.select(idx);
            } else {
                this.wEncoding.select(Const.indexOfString((String)"UTF-8", (String[])this.wEncoding.getItems()));
            }
        }
    }

    public void getData() {
        if (this.input.getEncoding() != null) {
            this.wEncoding.setText(this.input.getEncoding());
        }
        if (this.input.getValueName() != null) {
            this.wOutputValue.setText(this.input.getValueName());
        }
        if (this.input.getRootNode() != null) {
            this.wRepeatElement.setText(this.input.getRootNode());
        }
        this.wOmitXMLHeader.setSelection(this.input.isOmitXMLheader());
        this.wOmitNullValues.setSelection(this.input.isOmitNullValues());
        this.logDebug(BaseMessages.getString(PKG, (String)"AddXMLDialog.Log.GettingFieldsInfo", (String[])new String[0]));
        for (int i = 0; i < this.input.getOutputFields().length; ++i) {
            XMLField field = this.input.getOutputFields()[i];
            TableItem item = this.wFields.table.getItem(i);
            if (field.getFieldName() != null) {
                item.setText(1, field.getFieldName());
            }
            if (field.getElementName() != null) {
                item.setText(2, field.getElementName());
            }
            item.setText(3, field.getTypeDesc());
            if (field.getFormat() != null) {
                item.setText(4, field.getFormat());
            }
            if (field.getLength() >= 0) {
                item.setText(5, "" + field.getLength());
            }
            if (field.getPrecision() >= 0) {
                item.setText(6, "" + field.getPrecision());
            }
            if (field.getCurrencySymbol() != null) {
                item.setText(7, field.getCurrencySymbol());
            }
            if (field.getDecimalSymbol() != null) {
                item.setText(8, field.getDecimalSymbol());
            }
            if (field.getGroupingSymbol() != null) {
                item.setText(9, field.getGroupingSymbol());
            }
            if (field.getNullString() != null) {
                item.setText(10, field.getNullString());
            }
            item.setText(11, field.isAttribute() ? BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]));
            if (field.getAttributeParentName() == null) continue;
            item.setText(12, field.getAttributeParentName());
        }
        this.wFields.optWidth(true);
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.backupChanged);
        this.dispose();
    }

    private void getInfo(AddXMLMeta tfoi) {
        tfoi.setEncoding(this.wEncoding.getText());
        tfoi.setValueName(this.wOutputValue.getText());
        tfoi.setRootNode(this.wRepeatElement.getText());
        tfoi.setOmitXMLheader(this.wOmitXMLHeader.getSelection());
        tfoi.setOmitNullValues(this.wOmitNullValues.getSelection());
        int nrfields = this.wFields.nrNonEmpty();
        tfoi.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            XMLField field = new XMLField();
            TableItem item = this.wFields.getNonEmpty(i);
            field.setFieldName(item.getText(1));
            field.setElementName(item.getText(2));
            if (field.getFieldName().equals(field.getElementName())) {
                field.setElementName("");
            }
            field.setType(item.getText(3));
            field.setFormat(item.getText(4));
            field.setLength(Const.toInt((String)item.getText(5), (int)-1));
            field.setPrecision(Const.toInt((String)item.getText(6), (int)-1));
            field.setCurrencySymbol(item.getText(7));
            field.setDecimalSymbol(item.getText(8));
            field.setGroupingSymbol(item.getText(9));
            field.setNullString(item.getText(10));
            field.setAttribute(BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]).equals(item.getText(11)));
            field.setAttributeParentName(item.getText(12));
            tfoi.getOutputFields()[i] = field;
        }
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        this.getInfo(this.input);
        this.dispose();
    }

    private void get() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null) {
                BaseStepDialog.getFieldsFromPrevious((RowMetaInterface)r, (TableView)this.wFields, (int)1, (int[])new int[]{1, 2}, (int[])new int[]{3}, (int)5, (int)6, (TableItemInsertListener)new TableItemInsertListener(){

                    public boolean tableItemInserted(TableItem tableItem, ValueMetaInterface v) {
                        if (v.isNumber() && v.getLength() > 0) {
                            int m;
                            int le = v.getLength();
                            int pr = v.getPrecision();
                            if (v.getPrecision() <= 0) {
                                pr = 0;
                            }
                            String mask = " ";
                            for (m = 0; m < le - pr; ++m) {
                                mask = mask + "0";
                            }
                            if (pr > 0) {
                                mask = mask + ".";
                            }
                            for (m = 0; m < pr; ++m) {
                                mask = mask + "0";
                            }
                            tableItem.setText(4, mask);
                        }
                        return true;
                    }
                });
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    public void setMinimalWidth() {
        int nrNonEmptyFields = this.wFields.nrNonEmpty();
        block6: for (int i = 0; i < nrNonEmptyFields; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            item.setText(5, "");
            item.setText(6, "");
            int type = ValueMeta.getType((String)item.getText(2));
            switch (type) {
                case 2: {
                    item.setText(4, "");
                    continue block6;
                }
                case 5: {
                    item.setText(4, "0");
                    continue block6;
                }
                case 1: {
                    item.setText(4, "0.#####");
                    continue block6;
                }
                case 3: {
                    continue block6;
                }
            }
        }
        this.wFields.optWidth(true);
    }
}

