/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.simpleworkflow.flow.worker;

import com.cloudera.com.amazonaws.services.simpleworkflow.flow.StartTimerFailedException;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.WorkflowClock;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.common.FlowHelpers;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.core.ExternalTask;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.core.ExternalTaskCancellationHandler;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.core.ExternalTaskCompletionHandle;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.worker.DecisionsHelper;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.worker.OpenRequestInfo;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.HistoryEvent;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.StartTimerDecisionAttributes;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.StartTimerFailedEventAttributes;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.TimerCanceledEventAttributes;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.TimerFiredEventAttributes;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WorkflowClockImpl
implements WorkflowClock {
    private static final Log log = LogFactory.getLog(WorkflowClockImpl.class);
    private final DecisionsHelper decisions;
    private final Map<String, OpenRequestInfo<?, ?>> scheduledTimers = new HashMap();
    private long replayCurrentTimeMilliseconds;
    private boolean replaying = true;

    WorkflowClockImpl(DecisionsHelper decisions) {
        this.decisions = decisions;
    }

    @Override
    public long currentTimeMillis() {
        return this.replayCurrentTimeMilliseconds;
    }

    void setReplayCurrentTimeMilliseconds(long replayCurrentTimeMilliseconds) {
        this.replayCurrentTimeMilliseconds = replayCurrentTimeMilliseconds;
    }

    @Override
    public boolean isReplaying() {
        return this.replaying;
    }

    void setReplaying(boolean replaying) {
        this.replaying = replaying;
    }

    @Override
    public Promise<Void> createTimer(long delaySeconds) {
        return this.createTimer(delaySeconds, null);
    }

    @Override
    public <T> Promise<T> createTimer(long delaySeconds, final T userContext) {
        if (delaySeconds < 0L) {
            throw new IllegalArgumentException("Negative delaySeconds: " + delaySeconds);
        }
        if (delaySeconds == 0L) {
            return Promise.asPromise(userContext);
        }
        final OpenRequestInfo context = new OpenRequestInfo(userContext);
        final StartTimerDecisionAttributes timer = new StartTimerDecisionAttributes();
        timer.setStartToFireTimeout(FlowHelpers.secondsToDuration(delaySeconds));
        final String timerId = this.decisions.getNextId();
        timer.setTimerId(timerId);
        String taskName = "timerId=" + timer.getTimerId() + ", delaySeconds=" + timer.getStartToFireTimeout();
        new ExternalTask(new Promise[0]){

            protected ExternalTaskCancellationHandler doExecute(ExternalTaskCompletionHandle handle) throws Throwable {
                WorkflowClockImpl.this.decisions.startTimer(timer, userContext);
                context.setCompletionHandle(handle);
                WorkflowClockImpl.this.scheduledTimers.put(timerId, context);
                return new TimerCancellationHandler(timerId);
            }
        }.setName(taskName);
        context.setResultDescription("createTimer " + taskName);
        return context.getResult();
    }

    void handleTimerFired(Long eventId, TimerFiredEventAttributes attributes) {
        String timerId = attributes.getTimerId();
        if (this.decisions.handleTimerClosed(timerId)) {
            OpenRequestInfo<?, ?> scheduled = this.scheduledTimers.remove(timerId);
            if (scheduled != null) {
                ExternalTaskCompletionHandle completionHandle = scheduled.getCompletionHandle();
                scheduled.getResult().set(scheduled.getUserContext());
                completionHandle.complete();
            }
        } else {
            log.debug((Object)"handleTimerFired not complete");
        }
    }

    void handleStartTimerFailed(HistoryEvent event) {
        StartTimerFailedEventAttributes attributes = event.getStartTimerFailedEventAttributes();
        String timerId = attributes.getTimerId();
        if (this.decisions.handleStartTimerFailed(event)) {
            OpenRequestInfo<?, ?> scheduled = this.scheduledTimers.remove(timerId);
            if (scheduled != null) {
                ExternalTaskCompletionHandle completionHandle = scheduled.getCompletionHandle();
                Object createTimerUserContext = scheduled.getUserContext();
                String cause = attributes.getCause();
                StartTimerFailedException failure = new StartTimerFailedException(event.getEventId(), timerId, createTimerUserContext, cause);
                completionHandle.fail(failure);
            }
        } else {
            log.debug((Object)"handleStartTimerFailed not complete");
        }
    }

    void handleTimerCanceled(HistoryEvent event) {
        TimerCanceledEventAttributes attributes = event.getTimerCanceledEventAttributes();
        String timerId = attributes.getTimerId();
        if (this.decisions.handleTimerCanceled(event)) {
            OpenRequestInfo<?, ?> scheduled = this.scheduledTimers.remove(timerId);
            if (scheduled != null) {
                ExternalTaskCompletionHandle completionHandle = scheduled.getCompletionHandle();
                CancellationException exception = new CancellationException();
                completionHandle.fail(exception);
            }
        } else {
            log.debug((Object)"handleTimerCanceled not complete");
        }
    }

    private final class TimerCancellationHandler
    implements ExternalTaskCancellationHandler {
        private final String timerId;

        private TimerCancellationHandler(String timerId) {
            this.timerId = timerId;
        }

        public void handleCancellation(Throwable cause) {
            WorkflowClockImpl.this.decisions.cancelTimer(this.timerId, new Runnable(){

                public void run() {
                    OpenRequestInfo scheduled = (OpenRequestInfo)WorkflowClockImpl.this.scheduledTimers.remove(TimerCancellationHandler.this.timerId);
                    ExternalTaskCompletionHandle context = scheduled.getCompletionHandle();
                    context.complete();
                }
            });
        }
    }
}

