/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.simpleworkflow.flow.worker;

import com.cloudera.com.amazonaws.services.simpleworkflow.flow.common.WorkflowExecutionUtils;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.DecisionTask;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.EventType;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.HistoryEvent;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HistoryHelper {
    private static final Log historyLog = LogFactory.getLog((String)(HistoryHelper.class.getName() + ".history"));
    private final EventsIterator events;

    public HistoryHelper(Iterator<DecisionTask> decisionTasks) {
        this.events = new EventsIterator(decisionTasks);
    }

    public EventsIterator getEvents() {
        return this.events;
    }

    public String toString() {
        return WorkflowExecutionUtils.prettyPrintHistory(this.events.getEvents(), true);
    }

    public DecisionTask getDecisionTask() {
        return this.events.getDecisionTask();
    }

    public long getLastNonReplayEventId() {
        Long result = this.getDecisionTask().getPreviousStartedEventId();
        if (result == null) {
            return 0L;
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EventsIterator
    implements Iterator<HistoryEvent> {
        private final Iterator<DecisionTask> decisionTasks;
        private DecisionTask decisionTask;
        private List<HistoryEvent> events;
        private int index;

        public EventsIterator(Iterator<DecisionTask> decisionTasks) {
            this.decisionTasks = decisionTasks;
            if (decisionTasks.hasNext()) {
                this.decisionTask = decisionTasks.next();
                this.events = this.decisionTask.getEvents();
                if (historyLog.isTraceEnabled()) {
                    historyLog.trace((Object)WorkflowExecutionUtils.prettyPrintHistory(this.events, true));
                }
            } else {
                this.decisionTask = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.decisionTask != null && (this.index < this.events.size() || this.decisionTasks.hasNext());
        }

        @Override
        public HistoryEvent next() {
            if (this.index == this.events.size()) {
                this.decisionTask = this.decisionTasks.next();
                this.events = this.decisionTask.getEvents();
                if (historyLog.isTraceEnabled()) {
                    historyLog.trace((Object)WorkflowExecutionUtils.prettyPrintHistory(this.events, true));
                }
                this.index = 0;
            }
            return this.events.get(this.index++);
        }

        public DecisionTask getDecisionTask() {
            return this.decisionTask;
        }

        public List<HistoryEvent> getEvents() {
            return this.events;
        }

        public boolean isNextDecisionTimedOut() {
            int i = this.index;
            while (true) {
                if (i < this.events.size()) {
                    HistoryEvent event = this.events.get(i);
                    EventType eventType = EventType.fromValue(event.getEventType());
                    if (eventType.equals((Object)EventType.DecisionTaskTimedOut)) {
                        return true;
                    }
                    if (eventType.equals((Object)EventType.DecisionTaskCompleted)) {
                        return false;
                    }
                    ++i;
                    continue;
                }
                if (!this.decisionTasks.hasNext()) {
                    return false;
                }
                this.decisionTask = this.decisionTasks.next();
                List<HistoryEvent> nextPageEvents = this.decisionTask.getEvents();
                if (historyLog.isTraceEnabled()) {
                    historyLog.trace((Object)WorkflowExecutionUtils.prettyPrintHistory(nextPageEvents, true));
                }
                this.events.addAll(nextPageEvents);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

