/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.simpleworkflow.flow.junit;

import com.cloudera.com.amazonaws.services.simpleworkflow.flow.core.AsyncScope;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.core.Settable;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.core.TryCatchFinally;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.junit.WorkflowTestBase;
import java.util.concurrent.Callable;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowTestStatement
extends Statement {
    private final Callable<WorkflowTestBase> workflowTestAccessor;
    private final Statement base;
    private Long timeout;
    boolean completed;
    private Throwable failure;
    boolean waitingOnTimer;
    private Class<? extends Throwable> expectedException;
    private boolean flowTestRunner;

    public WorkflowTestStatement(Callable<WorkflowTestBase> workflowTestAccessor, Statement base, Long timeout, Class<? extends Throwable> expectedException) {
        this.workflowTestAccessor = workflowTestAccessor;
        this.base = base;
        this.timeout = timeout;
        this.expectedException = expectedException;
    }

    public void evaluate() throws Throwable {
        if (!this.flowTestRunner) {
            throw new IllegalStateException("WorkflowTest rule can be used only with flow specific test runners: FlowBlockJUnit4ClassRunner and FlowSpringJUnit4ClassRunner");
        }
        final WorkflowTestBase workflowTest = this.workflowTestAccessor.call();
        Thread t = null;
        if (this.timeout == null || this.timeout == 0L) {
            try {
                this.asyncEvaluate(workflowTest);
                this.completed = true;
            }
            catch (Throwable e) {
                this.failure = e;
            }
        } else {
            t = new Thread(){

                public void run() {
                    try {
                        WorkflowTestStatement.this.asyncEvaluate(workflowTest);
                        WorkflowTestStatement.this.completed = true;
                    }
                    catch (Throwable e) {
                        WorkflowTestStatement.this.failure = e;
                    }
                }
            };
            t.start();
            t.join(this.timeout);
        }
        if (this.failure != null) {
            if (this.expectedException != null && this.expectedException.isAssignableFrom(this.failure.getClass())) {
                return;
            }
            throw this.failure;
        }
        if (!this.completed) {
            if (this.waitingOnTimer) {
                AssertionError e = new AssertionError((Object)("Test timed out after " + this.timeout + " milliseconds. The following asynchrous tasks are outstanding: \n" + workflowTest.scope.getAsynchronousThreadDumpAsString()));
                throw e;
            }
            AssertionError e = new AssertionError((Object)("Test timed out after " + this.timeout + " milliseconds"));
            if (t != null) {
                ((Throwable)((Object)e)).setStackTrace(t.getStackTrace());
            }
            throw e;
        }
        if (this.expectedException != null) {
            throw new AssertionError((Object)("Expected exception: " + this.expectedException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncEvaluate(final WorkflowTestBase workflowTest) throws Throwable, InterruptedException {
        try {
            workflowTest.scope = new AsyncScope(){

                protected void doAsync() throws Throwable {
                    new TryCatchFinally(){

                        protected void doTry() throws Throwable {
                            workflowTest.beforeEvaluate(workflowTest.decisionContext);
                            WorkflowTestStatement.this.base.evaluate();
                        }

                        protected void doCatch(Throwable e) throws Throwable {
                            if (e instanceof IllegalStateException && "Called outside of the workflow definition code.".equals(e.getMessage())) {
                                throw new RuntimeException("Possible use of \"timeout\" parameter of @Test annotation without using Flow JUnit runner. Supported runners are FlowBlockJUnit4ClassRunner and FlowSpringJUnit4ClassRunner.", e);
                            }
                            throw e;
                        }

                        protected void doFinally() throws Throwable {
                            workflowTest.afterEvaluate();
                        }
                    };
                }
            };
            boolean outstandingTasks = false;
            while (!workflowTest.scope.isComplete()) {
                outstandingTasks = workflowTest.scope.eventLoop();
                if (workflowTest.waits.size() == 0) {
                    Long toNextTimerDelay = workflowTest.workflowClock.fireTimers();
                    if (toNextTimerDelay == null) break;
                    long timeToSleep = (long)((double)toNextTimerDelay.longValue() / workflowTest.clockAcceleration);
                    if (timeToSleep > 5L) {
                        this.waitingOnTimer = true;
                        try {
                            Thread.sleep(timeToSleep);
                        }
                        finally {
                            this.waitingOnTimer = false;
                        }
                    }
                    workflowTest.workflowClock.advanceMilliseconds(toNextTimerDelay);
                    continue;
                }
                for (Settable<Void> listener : workflowTest.waits) {
                    listener.set(null);
                }
                workflowTest.waits.clear();
            }
            if (!workflowTest.disableOutstandingTasksCheck && !outstandingTasks) {
                throw new IllegalStateException("There are outstanding tasks after test completed execution: \n" + workflowTest.scope.getAsynchronousThreadDumpAsString());
            }
        }
        finally {
            workflowTest.afterEvaluate();
        }
    }

    public void setTestTimeoutActualTimeMilliseconds(long timeout) {
        if (timeout > 0L) {
            this.timeout = timeout;
        }
    }

    public void setExpectedException(Class<? extends Throwable> expectedException) {
        this.expectedException = expectedException;
    }

    public void setFlowTestRunner(boolean flowTestRunner) {
        this.flowTestRunner = flowTestRunner;
    }
}

