/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.s3.model;

import com.cloudera.com.amazonaws.internal.MetricAware;
import com.cloudera.com.amazonaws.internal.SdkFilterInputStream;
import com.cloudera.com.amazonaws.metrics.AwsSdkMetrics;
import com.cloudera.com.amazonaws.metrics.MetricFilterInputStream;
import com.cloudera.com.amazonaws.services.s3.metrics.S3ServiceMetric;
import com.cloudera.org.apache.http.client.methods.HttpRequestBase;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;

public class S3ObjectInputStream
extends SdkFilterInputStream {
    private final HttpRequestBase httpRequest;

    public S3ObjectInputStream(InputStream in, HttpRequestBase httpRequest) {
        this(in, httpRequest, S3ObjectInputStream.wrapWithByteCounting(in));
    }

    public S3ObjectInputStream(InputStream in, HttpRequestBase httpRequest, boolean collectMetrics) {
        super(collectMetrics ? new MetricFilterInputStream(S3ServiceMetric.S3DownloadThroughput, in) : in);
        this.httpRequest = httpRequest;
    }

    private static boolean wrapWithByteCounting(InputStream in) {
        if (!AwsSdkMetrics.isMetricsEnabled()) {
            return false;
        }
        if (in instanceof MetricAware) {
            MetricAware aware = (MetricAware)((Object)in);
            return !aware.isMetricActivated();
        }
        return true;
    }

    public void abort() throws IOException {
        this.getHttpRequest().abort();
        try {
            this.close();
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    public HttpRequestBase getHttpRequest() {
        return this.httpRequest;
    }
}

