/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.redshift.model.transform;

import com.cloudera.com.amazonaws.services.redshift.model.ClusterNode;
import com.cloudera.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.cloudera.com.amazonaws.transform.StaxUnmarshallerContext;
import com.cloudera.com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterNodeStaxUnmarshaller
implements Unmarshaller<ClusterNode, StaxUnmarshallerContext> {
    private static ClusterNodeStaxUnmarshaller instance;

    @Override
    public ClusterNode unmarshall(StaxUnmarshallerContext context) throws Exception {
        ClusterNode clusterNode = new ClusterNode();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return clusterNode;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("NodeRole", targetDepth)) {
                    clusterNode.setNodeRole(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PrivateIPAddress", targetDepth)) {
                    clusterNode.setPrivateIPAddress(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("PublicIPAddress", targetDepth)) continue;
                clusterNode.setPublicIPAddress(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return clusterNode;
    }

    public static ClusterNodeStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ClusterNodeStaxUnmarshaller();
        }
        return instance;
    }
}

