/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.identitymanagement.model.transform;

import com.cloudera.com.amazonaws.services.identitymanagement.model.PasswordPolicy;
import com.cloudera.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.cloudera.com.amazonaws.transform.StaxUnmarshallerContext;
import com.cloudera.com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasswordPolicyStaxUnmarshaller
implements Unmarshaller<PasswordPolicy, StaxUnmarshallerContext> {
    private static PasswordPolicyStaxUnmarshaller instance;

    @Override
    public PasswordPolicy unmarshall(StaxUnmarshallerContext context) throws Exception {
        PasswordPolicy passwordPolicy = new PasswordPolicy();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return passwordPolicy;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("MinimumPasswordLength", targetDepth)) {
                    passwordPolicy.setMinimumPasswordLength(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("RequireSymbols", targetDepth)) {
                    passwordPolicy.setRequireSymbols(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("RequireNumbers", targetDepth)) {
                    passwordPolicy.setRequireNumbers(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("RequireUppercaseCharacters", targetDepth)) {
                    passwordPolicy.setRequireUppercaseCharacters(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("RequireLowercaseCharacters", targetDepth)) {
                    passwordPolicy.setRequireLowercaseCharacters(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AllowUsersToChangePassword", targetDepth)) {
                    passwordPolicy.setAllowUsersToChangePassword(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ExpirePasswords", targetDepth)) {
                    passwordPolicy.setExpirePasswords(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("MaxPasswordAge", targetDepth)) continue;
                passwordPolicy.setMaxPasswordAge(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return passwordPolicy;
    }

    public static PasswordPolicyStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new PasswordPolicyStaxUnmarshaller();
        }
        return instance;
    }
}

