/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.identitymanagement.model;

import com.cloudera.com.amazonaws.internal.ListWithAutoConstructFlag;
import com.cloudera.com.amazonaws.services.identitymanagement.model.Group;
import com.cloudera.com.amazonaws.services.identitymanagement.model.User;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetGroupResult
implements Serializable {
    private Group group;
    private ListWithAutoConstructFlag<User> users;
    private Boolean isTruncated;
    private String marker;

    public Group getGroup() {
        return this.group;
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    public GetGroupResult withGroup(Group group) {
        this.group = group;
        return this;
    }

    public List<User> getUsers() {
        if (this.users == null) {
            this.users = new ListWithAutoConstructFlag();
            this.users.setAutoConstruct(true);
        }
        return this.users;
    }

    public void setUsers(Collection<User> users) {
        if (users == null) {
            this.users = null;
            return;
        }
        ListWithAutoConstructFlag usersCopy = new ListWithAutoConstructFlag(users.size());
        usersCopy.addAll(users);
        this.users = usersCopy;
    }

    public GetGroupResult withUsers(User ... users) {
        if (this.getUsers() == null) {
            this.setUsers(new ArrayList<User>(users.length));
        }
        for (User value : users) {
            this.getUsers().add(value);
        }
        return this;
    }

    public GetGroupResult withUsers(Collection<User> users) {
        if (users == null) {
            this.users = null;
        } else {
            ListWithAutoConstructFlag usersCopy = new ListWithAutoConstructFlag(users.size());
            usersCopy.addAll(users);
            this.users = usersCopy;
        }
        return this;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public void setIsTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
    }

    public GetGroupResult withIsTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
        return this;
    }

    public Boolean getIsTruncated() {
        return this.isTruncated;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public GetGroupResult withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGroup() != null) {
            sb.append("Group: " + this.getGroup() + ",");
        }
        if (this.getUsers() != null) {
            sb.append("Users: " + this.getUsers() + ",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: " + this.isTruncated() + ",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGroup() == null ? 0 : this.getGroup().hashCode());
        hashCode = 31 * hashCode + (this.getUsers() == null ? 0 : this.getUsers().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGroupResult)) {
            return false;
        }
        GetGroupResult other = (GetGroupResult)obj;
        if (other.getGroup() == null ^ this.getGroup() == null) {
            return false;
        }
        if (other.getGroup() != null && !other.getGroup().equals(this.getGroup())) {
            return false;
        }
        if (other.getUsers() == null ^ this.getUsers() == null) {
            return false;
        }
        if (other.getUsers() != null && !other.getUsers().equals(this.getUsers())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }
}

