/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.glacier.model.transform;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.DefaultRequest;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.http.HttpMethodName;
import com.cloudera.com.amazonaws.services.glacier.model.ListMultipartUploadsRequest;
import com.cloudera.com.amazonaws.transform.Marshaller;
import com.cloudera.com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListMultipartUploadsRequestMarshaller
implements Marshaller<Request<ListMultipartUploadsRequest>, ListMultipartUploadsRequest> {
    @Override
    public Request<ListMultipartUploadsRequest> marshall(ListMultipartUploadsRequest listMultipartUploadsRequest) {
        if (listMultipartUploadsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListMultipartUploadsRequest> request = new DefaultRequest<ListMultipartUploadsRequest>(listMultipartUploadsRequest, "AmazonGlacier");
        String target = "Glacier.ListMultipartUploads";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/multipart-uploads?marker={marker};limit={limit}";
        uriResourcePath = uriResourcePath.replace("{accountId}", listMultipartUploadsRequest.getAccountId() == null ? "" : StringUtils.fromString(listMultipartUploadsRequest.getAccountId()));
        uriResourcePath = uriResourcePath.replace("{vaultName}", listMultipartUploadsRequest.getVaultName() == null ? "" : StringUtils.fromString(listMultipartUploadsRequest.getVaultName()));
        uriResourcePath = uriResourcePath.replace("{marker}", listMultipartUploadsRequest.getUploadIdMarker() == null ? "" : StringUtils.fromString(listMultipartUploadsRequest.getUploadIdMarker()));
        uriResourcePath = uriResourcePath.replace("{limit}", listMultipartUploadsRequest.getLimit() == null ? "" : StringUtils.fromString(listMultipartUploadsRequest.getLimit()));
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        return request;
    }
}

