/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.elastictranscoder.model.transform;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.DefaultRequest;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.http.HttpMethodName;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.ReadJobRequest;
import com.cloudera.com.amazonaws.transform.Marshaller;
import com.cloudera.com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadJobRequestMarshaller
implements Marshaller<Request<ReadJobRequest>, ReadJobRequest> {
    @Override
    public Request<ReadJobRequest> marshall(ReadJobRequest readJobRequest) {
        if (readJobRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ReadJobRequest> request = new DefaultRequest<ReadJobRequest>(readJobRequest, "AmazonElasticTranscoder");
        String target = "EtsCustomerService.ReadJob";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "2012-09-25/jobs/{Id}";
        uriResourcePath = uriResourcePath.replace("{Id}", readJobRequest.getId() == null ? "" : StringUtils.fromString(readJobRequest.getId()));
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        return request;
    }
}

