/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.elastictranscoder;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.AmazonServiceException;
import com.cloudera.com.amazonaws.AmazonWebServiceClient;
import com.cloudera.com.amazonaws.AmazonWebServiceRequest;
import com.cloudera.com.amazonaws.AmazonWebServiceResponse;
import com.cloudera.com.amazonaws.ClientConfiguration;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.Response;
import com.cloudera.com.amazonaws.ResponseMetadata;
import com.cloudera.com.amazonaws.auth.AWSCredentials;
import com.cloudera.com.amazonaws.auth.AWSCredentialsProvider;
import com.cloudera.com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.cloudera.com.amazonaws.handlers.HandlerChainFactory;
import com.cloudera.com.amazonaws.http.ExecutionContext;
import com.cloudera.com.amazonaws.http.HttpResponseHandler;
import com.cloudera.com.amazonaws.http.JsonErrorResponseHandler;
import com.cloudera.com.amazonaws.http.JsonResponseHandler;
import com.cloudera.com.amazonaws.internal.StaticCredentialsProvider;
import com.cloudera.com.amazonaws.metrics.RequestMetricCollector;
import com.cloudera.com.amazonaws.services.elastictranscoder.AmazonElasticTranscoder;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.CancelJobRequest;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.CancelJobResult;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.CreateJobRequest;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.CreateJobResult;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.CreatePipelineRequest;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.CreatePipelineResult;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.CreatePresetRequest;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.CreatePresetResult;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.DeletePipelineRequest;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.DeletePipelineResult;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.DeletePresetRequest;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.DeletePresetResult;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.ListJobsByPipelineRequest;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.ListJobsByPipelineResult;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.ListJobsByStatusRequest;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.ListJobsByStatusResult;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.ListPipelinesRequest;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.ListPipelinesResult;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.ListPresetsRequest;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.ListPresetsResult;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.ReadJobRequest;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.ReadJobResult;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.ReadPipelineRequest;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.ReadPipelineResult;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.ReadPresetRequest;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.ReadPresetResult;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.TestRoleRequest;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.TestRoleResult;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.UpdatePipelineNotificationsRequest;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.UpdatePipelineNotificationsResult;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.UpdatePipelineRequest;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.UpdatePipelineResult;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.UpdatePipelineStatusRequest;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.UpdatePipelineStatusResult;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.AccessDeniedExceptionUnmarshaller;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.CancelJobRequestMarshaller;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.CancelJobResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.CreateJobRequestMarshaller;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.CreateJobResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.CreatePipelineRequestMarshaller;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.CreatePipelineResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.CreatePresetRequestMarshaller;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.CreatePresetResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.DeletePipelineRequestMarshaller;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.DeletePipelineResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.DeletePresetRequestMarshaller;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.DeletePresetResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.IncompatibleVersionExceptionUnmarshaller;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.InternalServiceExceptionUnmarshaller;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.LimitExceededExceptionUnmarshaller;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.ListJobsByPipelineRequestMarshaller;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.ListJobsByPipelineResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.ListJobsByStatusRequestMarshaller;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.ListJobsByStatusResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.ListPipelinesRequestMarshaller;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.ListPipelinesResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.ListPresetsRequestMarshaller;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.ListPresetsResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.ReadJobRequestMarshaller;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.ReadJobResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.ReadPipelineRequestMarshaller;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.ReadPipelineResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.ReadPresetRequestMarshaller;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.ReadPresetResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.ResourceInUseExceptionUnmarshaller;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.TestRoleRequestMarshaller;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.TestRoleResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.UpdatePipelineNotificationsRequestMarshaller;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.UpdatePipelineNotificationsResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.UpdatePipelineRequestMarshaller;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.UpdatePipelineResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.UpdatePipelineStatusRequestMarshaller;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.UpdatePipelineStatusResultJsonUnmarshaller;
import com.cloudera.com.amazonaws.services.elastictranscoder.model.transform.ValidationExceptionUnmarshaller;
import com.cloudera.com.amazonaws.transform.JsonErrorUnmarshaller;
import com.cloudera.com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonElasticTranscoderClient
extends AmazonWebServiceClient
implements AmazonElasticTranscoder {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonElasticTranscoder.class);
    protected List<JsonErrorUnmarshaller> jsonErrorUnmarshallers;

    public AmazonElasticTranscoderClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonElasticTranscoderClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonElasticTranscoderClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonElasticTranscoderClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(AmazonElasticTranscoderClient.adjustClientConfiguration(clientConfiguration));
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonElasticTranscoderClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonElasticTranscoderClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AmazonElasticTranscoderClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(AmazonElasticTranscoderClient.adjustClientConfiguration(clientConfiguration), requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.jsonErrorUnmarshallers = new ArrayList<JsonErrorUnmarshaller>();
        this.jsonErrorUnmarshallers.add(new ResourceInUseExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InternalServiceExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new ValidationExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new LimitExceededExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new IncompatibleVersionExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new AccessDeniedExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new ResourceNotFoundExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshaller());
        this.setEndpoint("elastictranscoder.us-east-1.amazonaws.com/");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/cloudera/com/amazonaws/services/elastictranscoder/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/cloudera/com/amazonaws/services/elastictranscoder/request.handler2s"));
    }

    private static ClientConfiguration adjustClientConfiguration(ClientConfiguration orig) {
        ClientConfiguration config = orig;
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdatePipelineStatusResult updatePipelineStatus(UpdatePipelineStatusRequest updatePipelineStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updatePipelineStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdatePipelineStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdatePipelineStatusRequestMarshaller().marshall(updatePipelineStatusRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            UpdatePipelineStatusResultJsonUnmarshaller unmarshaller = new UpdatePipelineStatusResultJsonUnmarshaller();
            JsonResponseHandler<UpdatePipelineStatusResult> responseHandler = new JsonResponseHandler<UpdatePipelineStatusResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            UpdatePipelineStatusResult updatePipelineStatusResult = (UpdatePipelineStatusResult)response.getAwsResponse();
            return updatePipelineStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdatePipelineNotificationsResult updatePipelineNotifications(UpdatePipelineNotificationsRequest updatePipelineNotificationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updatePipelineNotificationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdatePipelineNotificationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdatePipelineNotificationsRequestMarshaller().marshall(updatePipelineNotificationsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            UpdatePipelineNotificationsResultJsonUnmarshaller unmarshaller = new UpdatePipelineNotificationsResultJsonUnmarshaller();
            JsonResponseHandler<UpdatePipelineNotificationsResult> responseHandler = new JsonResponseHandler<UpdatePipelineNotificationsResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            UpdatePipelineNotificationsResult updatePipelineNotificationsResult = (UpdatePipelineNotificationsResult)response.getAwsResponse();
            return updatePipelineNotificationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReadJobResult readJob(ReadJobRequest readJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(readJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ReadJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ReadJobRequestMarshaller().marshall(readJobRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ReadJobResultJsonUnmarshaller unmarshaller = new ReadJobResultJsonUnmarshaller();
            JsonResponseHandler<ReadJobResult> responseHandler = new JsonResponseHandler<ReadJobResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            ReadJobResult readJobResult = (ReadJobResult)response.getAwsResponse();
            return readJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListJobsByStatusResult listJobsByStatus(ListJobsByStatusRequest listJobsByStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listJobsByStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListJobsByStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListJobsByStatusRequestMarshaller().marshall(listJobsByStatusRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListJobsByStatusResultJsonUnmarshaller unmarshaller = new ListJobsByStatusResultJsonUnmarshaller();
            JsonResponseHandler<ListJobsByStatusResult> responseHandler = new JsonResponseHandler<ListJobsByStatusResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            ListJobsByStatusResult listJobsByStatusResult = (ListJobsByStatusResult)response.getAwsResponse();
            return listJobsByStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReadPresetResult readPreset(ReadPresetRequest readPresetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(readPresetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ReadPresetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ReadPresetRequestMarshaller().marshall(readPresetRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ReadPresetResultJsonUnmarshaller unmarshaller = new ReadPresetResultJsonUnmarshaller();
            JsonResponseHandler<ReadPresetResult> responseHandler = new JsonResponseHandler<ReadPresetResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            ReadPresetResult readPresetResult = (ReadPresetResult)response.getAwsResponse();
            return readPresetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePipelineResult createPipeline(CreatePipelineRequest createPipelineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createPipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreatePipelineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreatePipelineRequestMarshaller().marshall(createPipelineRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            CreatePipelineResultJsonUnmarshaller unmarshaller = new CreatePipelineResultJsonUnmarshaller();
            JsonResponseHandler<CreatePipelineResult> responseHandler = new JsonResponseHandler<CreatePipelineResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            CreatePipelineResult createPipelineResult = (CreatePipelineResult)response.getAwsResponse();
            return createPipelineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelJobResult cancelJob(CancelJobRequest cancelJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(cancelJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CancelJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CancelJobRequestMarshaller().marshall(cancelJobRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            CancelJobResultJsonUnmarshaller unmarshaller = new CancelJobResultJsonUnmarshaller();
            JsonResponseHandler<CancelJobResult> responseHandler = new JsonResponseHandler<CancelJobResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            CancelJobResult cancelJobResult = (CancelJobResult)response.getAwsResponse();
            return cancelJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdatePipelineResult updatePipeline(UpdatePipelineRequest updatePipelineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updatePipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdatePipelineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdatePipelineRequestMarshaller().marshall(updatePipelineRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            UpdatePipelineResultJsonUnmarshaller unmarshaller = new UpdatePipelineResultJsonUnmarshaller();
            JsonResponseHandler<UpdatePipelineResult> responseHandler = new JsonResponseHandler<UpdatePipelineResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            UpdatePipelineResult updatePipelineResult = (UpdatePipelineResult)response.getAwsResponse();
            return updatePipelineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPresetsResult listPresets(ListPresetsRequest listPresetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPresetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPresetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPresetsRequestMarshaller().marshall(listPresetsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListPresetsResultJsonUnmarshaller unmarshaller = new ListPresetsResultJsonUnmarshaller();
            JsonResponseHandler<ListPresetsResult> responseHandler = new JsonResponseHandler<ListPresetsResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            ListPresetsResult listPresetsResult = (ListPresetsResult)response.getAwsResponse();
            return listPresetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePipelineResult deletePipeline(DeletePipelineRequest deletePipelineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deletePipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeletePipelineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeletePipelineRequestMarshaller().marshall(deletePipelineRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DeletePipelineResultJsonUnmarshaller unmarshaller = new DeletePipelineResultJsonUnmarshaller();
            JsonResponseHandler<DeletePipelineResult> responseHandler = new JsonResponseHandler<DeletePipelineResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DeletePipelineResult deletePipelineResult = (DeletePipelineResult)response.getAwsResponse();
            return deletePipelineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestRoleResult testRole(TestRoleRequest testRoleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(testRoleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TestRoleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TestRoleRequestMarshaller().marshall(testRoleRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            TestRoleResultJsonUnmarshaller unmarshaller = new TestRoleResultJsonUnmarshaller();
            JsonResponseHandler<TestRoleResult> responseHandler = new JsonResponseHandler<TestRoleResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            TestRoleResult testRoleResult = (TestRoleResult)response.getAwsResponse();
            return testRoleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPipelinesResult listPipelines(ListPipelinesRequest listPipelinesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPipelinesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPipelinesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPipelinesRequestMarshaller().marshall(listPipelinesRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListPipelinesResultJsonUnmarshaller unmarshaller = new ListPipelinesResultJsonUnmarshaller();
            JsonResponseHandler<ListPipelinesResult> responseHandler = new JsonResponseHandler<ListPipelinesResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            ListPipelinesResult listPipelinesResult = (ListPipelinesResult)response.getAwsResponse();
            return listPipelinesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReadPipelineResult readPipeline(ReadPipelineRequest readPipelineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(readPipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ReadPipelineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ReadPipelineRequestMarshaller().marshall(readPipelineRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ReadPipelineResultJsonUnmarshaller unmarshaller = new ReadPipelineResultJsonUnmarshaller();
            JsonResponseHandler<ReadPipelineResult> responseHandler = new JsonResponseHandler<ReadPipelineResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            ReadPipelineResult readPipelineResult = (ReadPipelineResult)response.getAwsResponse();
            return readPipelineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePresetResult createPreset(CreatePresetRequest createPresetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createPresetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreatePresetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreatePresetRequestMarshaller().marshall(createPresetRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            CreatePresetResultJsonUnmarshaller unmarshaller = new CreatePresetResultJsonUnmarshaller();
            JsonResponseHandler<CreatePresetResult> responseHandler = new JsonResponseHandler<CreatePresetResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            CreatePresetResult createPresetResult = (CreatePresetResult)response.getAwsResponse();
            return createPresetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePresetResult deletePreset(DeletePresetRequest deletePresetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deletePresetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeletePresetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeletePresetRequestMarshaller().marshall(deletePresetRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DeletePresetResultJsonUnmarshaller unmarshaller = new DeletePresetResultJsonUnmarshaller();
            JsonResponseHandler<DeletePresetResult> responseHandler = new JsonResponseHandler<DeletePresetResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DeletePresetResult deletePresetResult = (DeletePresetResult)response.getAwsResponse();
            return deletePresetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateJobResult createJob(CreateJobRequest createJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateJobRequestMarshaller().marshall(createJobRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            CreateJobResultJsonUnmarshaller unmarshaller = new CreateJobResultJsonUnmarshaller();
            JsonResponseHandler<CreateJobResult> responseHandler = new JsonResponseHandler<CreateJobResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            CreateJobResult createJobResult = (CreateJobResult)response.getAwsResponse();
            return createJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListJobsByPipelineResult listJobsByPipeline(ListJobsByPipelineRequest listJobsByPipelineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listJobsByPipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListJobsByPipelineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListJobsByPipelineRequestMarshaller().marshall(listJobsByPipelineRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListJobsByPipelineResultJsonUnmarshaller unmarshaller = new ListJobsByPipelineResultJsonUnmarshaller();
            JsonResponseHandler<ListJobsByPipelineResult> responseHandler = new JsonResponseHandler<ListJobsByPipelineResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            ListJobsByPipelineResult listJobsByPipelineResult = (ListJobsByPipelineResult)response.getAwsResponse();
            return listJobsByPipelineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    @Override
    public ListPresetsResult listPresets() throws AmazonServiceException, AmazonClientException {
        return this.listPresets(new ListPresetsRequest());
    }

    @Override
    public ListPipelinesResult listPipelines() throws AmazonServiceException, AmazonClientException {
        return this.listPipelines(new ListPipelinesRequest());
    }

    @Override
    public void setEndpoint(String endpoint) {
        super.setEndpoint(endpoint);
    }

    @Override
    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        super.setEndpoint(endpoint, serviceName, regionId);
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandler errorResponseHandler = new JsonErrorResponseHandler(this.jsonErrorUnmarshallers);
        Response result = this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
        return result;
    }
}

