/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.elasticmapreduce.model;

import com.cloudera.com.amazonaws.AmazonWebServiceRequest;
import com.cloudera.com.amazonaws.internal.ListWithAutoConstructFlag;
import com.cloudera.com.amazonaws.services.elasticmapreduce.model.StepConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddJobFlowStepsRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String jobFlowId;
    private ListWithAutoConstructFlag<StepConfig> steps;

    public AddJobFlowStepsRequest() {
    }

    public AddJobFlowStepsRequest(String jobFlowId) {
        this.setJobFlowId(jobFlowId);
    }

    public AddJobFlowStepsRequest(String jobFlowId, List<StepConfig> steps) {
        this.setJobFlowId(jobFlowId);
        this.setSteps(steps);
    }

    public String getJobFlowId() {
        return this.jobFlowId;
    }

    public void setJobFlowId(String jobFlowId) {
        this.jobFlowId = jobFlowId;
    }

    public AddJobFlowStepsRequest withJobFlowId(String jobFlowId) {
        this.jobFlowId = jobFlowId;
        return this;
    }

    public List<StepConfig> getSteps() {
        if (this.steps == null) {
            this.steps = new ListWithAutoConstructFlag();
            this.steps.setAutoConstruct(true);
        }
        return this.steps;
    }

    public void setSteps(Collection<StepConfig> steps) {
        if (steps == null) {
            this.steps = null;
            return;
        }
        ListWithAutoConstructFlag stepsCopy = new ListWithAutoConstructFlag(steps.size());
        stepsCopy.addAll(steps);
        this.steps = stepsCopy;
    }

    public AddJobFlowStepsRequest withSteps(StepConfig ... steps) {
        if (this.getSteps() == null) {
            this.setSteps(new ArrayList<StepConfig>(steps.length));
        }
        for (StepConfig value : steps) {
            this.getSteps().add(value);
        }
        return this;
    }

    public AddJobFlowStepsRequest withSteps(Collection<StepConfig> steps) {
        if (steps == null) {
            this.steps = null;
        } else {
            ListWithAutoConstructFlag stepsCopy = new ListWithAutoConstructFlag(steps.size());
            stepsCopy.addAll(steps);
            this.steps = stepsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getJobFlowId() != null) {
            sb.append("JobFlowId: " + this.getJobFlowId() + ",");
        }
        if (this.getSteps() != null) {
            sb.append("Steps: " + this.getSteps());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getJobFlowId() == null ? 0 : this.getJobFlowId().hashCode());
        hashCode = 31 * hashCode + (this.getSteps() == null ? 0 : this.getSteps().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddJobFlowStepsRequest)) {
            return false;
        }
        AddJobFlowStepsRequest other = (AddJobFlowStepsRequest)obj;
        if (other.getJobFlowId() == null ^ this.getJobFlowId() == null) {
            return false;
        }
        if (other.getJobFlowId() != null && !other.getJobFlowId().equals(this.getJobFlowId())) {
            return false;
        }
        if (other.getSteps() == null ^ this.getSteps() == null) {
            return false;
        }
        return other.getSteps() == null || other.getSteps().equals(this.getSteps());
    }
}

