/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.ec2.model;

import com.cloudera.com.amazonaws.AmazonWebServiceRequest;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.internal.ListWithAutoConstructFlag;
import com.cloudera.com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.cloudera.com.amazonaws.services.ec2.model.transform.UnmonitorInstancesRequestMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnmonitorInstancesRequest
extends AmazonWebServiceRequest
implements Serializable,
DryRunSupportedRequest<UnmonitorInstancesRequest> {
    private ListWithAutoConstructFlag<String> instanceIds;

    public UnmonitorInstancesRequest() {
    }

    public UnmonitorInstancesRequest(List<String> instanceIds) {
        this.setInstanceIds(instanceIds);
    }

    public List<String> getInstanceIds() {
        if (this.instanceIds == null) {
            this.instanceIds = new ListWithAutoConstructFlag();
            this.instanceIds.setAutoConstruct(true);
        }
        return this.instanceIds;
    }

    public void setInstanceIds(Collection<String> instanceIds) {
        if (instanceIds == null) {
            this.instanceIds = null;
            return;
        }
        ListWithAutoConstructFlag instanceIdsCopy = new ListWithAutoConstructFlag(instanceIds.size());
        instanceIdsCopy.addAll(instanceIds);
        this.instanceIds = instanceIdsCopy;
    }

    public UnmonitorInstancesRequest withInstanceIds(String ... instanceIds) {
        if (this.getInstanceIds() == null) {
            this.setInstanceIds(new ArrayList<String>(instanceIds.length));
        }
        for (String value : instanceIds) {
            this.getInstanceIds().add(value);
        }
        return this;
    }

    public UnmonitorInstancesRequest withInstanceIds(Collection<String> instanceIds) {
        if (instanceIds == null) {
            this.instanceIds = null;
        } else {
            ListWithAutoConstructFlag instanceIdsCopy = new ListWithAutoConstructFlag(instanceIds.size());
            instanceIdsCopy.addAll(instanceIds);
            this.instanceIds = instanceIdsCopy;
        }
        return this;
    }

    @Override
    public Request<UnmonitorInstancesRequest> getDryRunRequest() {
        Request<UnmonitorInstancesRequest> request = new UnmonitorInstancesRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceIds() != null) {
            sb.append("InstanceIds: " + this.getInstanceIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceIds() == null ? 0 : this.getInstanceIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnmonitorInstancesRequest)) {
            return false;
        }
        UnmonitorInstancesRequest other = (UnmonitorInstancesRequest)obj;
        if (other.getInstanceIds() == null ^ this.getInstanceIds() == null) {
            return false;
        }
        return other.getInstanceIds() == null || other.getInstanceIds().equals(this.getInstanceIds());
    }
}

