/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.ec2.model;

import com.cloudera.com.amazonaws.internal.ListWithAutoConstructFlag;
import com.cloudera.com.amazonaws.services.ec2.model.GroupIdentifier;
import com.cloudera.com.amazonaws.services.ec2.model.Instance;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reservation
implements Serializable {
    private String reservationId;
    private String ownerId;
    private String requesterId;
    private ListWithAutoConstructFlag<GroupIdentifier> groups;
    private ListWithAutoConstructFlag<String> groupNames;
    private ListWithAutoConstructFlag<Instance> instances;

    public String getReservationId() {
        return this.reservationId;
    }

    public void setReservationId(String reservationId) {
        this.reservationId = reservationId;
    }

    public Reservation withReservationId(String reservationId) {
        this.reservationId = reservationId;
        return this;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public Reservation withOwnerId(String ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    public String getRequesterId() {
        return this.requesterId;
    }

    public void setRequesterId(String requesterId) {
        this.requesterId = requesterId;
    }

    public Reservation withRequesterId(String requesterId) {
        this.requesterId = requesterId;
        return this;
    }

    public List<GroupIdentifier> getGroups() {
        if (this.groups == null) {
            this.groups = new ListWithAutoConstructFlag();
            this.groups.setAutoConstruct(true);
        }
        return this.groups;
    }

    public void setGroups(Collection<GroupIdentifier> groups) {
        if (groups == null) {
            this.groups = null;
            return;
        }
        ListWithAutoConstructFlag groupsCopy = new ListWithAutoConstructFlag(groups.size());
        groupsCopy.addAll(groups);
        this.groups = groupsCopy;
    }

    public Reservation withGroups(GroupIdentifier ... groups) {
        if (this.getGroups() == null) {
            this.setGroups(new ArrayList<GroupIdentifier>(groups.length));
        }
        for (GroupIdentifier value : groups) {
            this.getGroups().add(value);
        }
        return this;
    }

    public Reservation withGroups(Collection<GroupIdentifier> groups) {
        if (groups == null) {
            this.groups = null;
        } else {
            ListWithAutoConstructFlag groupsCopy = new ListWithAutoConstructFlag(groups.size());
            groupsCopy.addAll(groups);
            this.groups = groupsCopy;
        }
        return this;
    }

    public List<String> getGroupNames() {
        if (this.groupNames == null) {
            this.groupNames = new ListWithAutoConstructFlag();
            this.groupNames.setAutoConstruct(true);
        }
        return this.groupNames;
    }

    public void setGroupNames(Collection<String> groupNames) {
        if (groupNames == null) {
            this.groupNames = null;
            return;
        }
        ListWithAutoConstructFlag groupNamesCopy = new ListWithAutoConstructFlag(groupNames.size());
        groupNamesCopy.addAll(groupNames);
        this.groupNames = groupNamesCopy;
    }

    public Reservation withGroupNames(String ... groupNames) {
        if (this.getGroupNames() == null) {
            this.setGroupNames(new ArrayList<String>(groupNames.length));
        }
        for (String value : groupNames) {
            this.getGroupNames().add(value);
        }
        return this;
    }

    public Reservation withGroupNames(Collection<String> groupNames) {
        if (groupNames == null) {
            this.groupNames = null;
        } else {
            ListWithAutoConstructFlag groupNamesCopy = new ListWithAutoConstructFlag(groupNames.size());
            groupNamesCopy.addAll(groupNames);
            this.groupNames = groupNamesCopy;
        }
        return this;
    }

    public List<Instance> getInstances() {
        if (this.instances == null) {
            this.instances = new ListWithAutoConstructFlag();
            this.instances.setAutoConstruct(true);
        }
        return this.instances;
    }

    public void setInstances(Collection<Instance> instances) {
        if (instances == null) {
            this.instances = null;
            return;
        }
        ListWithAutoConstructFlag instancesCopy = new ListWithAutoConstructFlag(instances.size());
        instancesCopy.addAll(instances);
        this.instances = instancesCopy;
    }

    public Reservation withInstances(Instance ... instances) {
        if (this.getInstances() == null) {
            this.setInstances(new ArrayList<Instance>(instances.length));
        }
        for (Instance value : instances) {
            this.getInstances().add(value);
        }
        return this;
    }

    public Reservation withInstances(Collection<Instance> instances) {
        if (instances == null) {
            this.instances = null;
        } else {
            ListWithAutoConstructFlag instancesCopy = new ListWithAutoConstructFlag(instances.size());
            instancesCopy.addAll(instances);
            this.instances = instancesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getReservationId() != null) {
            sb.append("ReservationId: " + this.getReservationId() + ",");
        }
        if (this.getOwnerId() != null) {
            sb.append("OwnerId: " + this.getOwnerId() + ",");
        }
        if (this.getRequesterId() != null) {
            sb.append("RequesterId: " + this.getRequesterId() + ",");
        }
        if (this.getGroups() != null) {
            sb.append("Groups: " + this.getGroups() + ",");
        }
        if (this.getGroupNames() != null) {
            sb.append("GroupNames: " + this.getGroupNames() + ",");
        }
        if (this.getInstances() != null) {
            sb.append("Instances: " + this.getInstances());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getReservationId() == null ? 0 : this.getReservationId().hashCode());
        hashCode = 31 * hashCode + (this.getOwnerId() == null ? 0 : this.getOwnerId().hashCode());
        hashCode = 31 * hashCode + (this.getRequesterId() == null ? 0 : this.getRequesterId().hashCode());
        hashCode = 31 * hashCode + (this.getGroups() == null ? 0 : this.getGroups().hashCode());
        hashCode = 31 * hashCode + (this.getGroupNames() == null ? 0 : this.getGroupNames().hashCode());
        hashCode = 31 * hashCode + (this.getInstances() == null ? 0 : this.getInstances().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Reservation)) {
            return false;
        }
        Reservation other = (Reservation)obj;
        if (other.getReservationId() == null ^ this.getReservationId() == null) {
            return false;
        }
        if (other.getReservationId() != null && !other.getReservationId().equals(this.getReservationId())) {
            return false;
        }
        if (other.getOwnerId() == null ^ this.getOwnerId() == null) {
            return false;
        }
        if (other.getOwnerId() != null && !other.getOwnerId().equals(this.getOwnerId())) {
            return false;
        }
        if (other.getRequesterId() == null ^ this.getRequesterId() == null) {
            return false;
        }
        if (other.getRequesterId() != null && !other.getRequesterId().equals(this.getRequesterId())) {
            return false;
        }
        if (other.getGroups() == null ^ this.getGroups() == null) {
            return false;
        }
        if (other.getGroups() != null && !other.getGroups().equals(this.getGroups())) {
            return false;
        }
        if (other.getGroupNames() == null ^ this.getGroupNames() == null) {
            return false;
        }
        if (other.getGroupNames() != null && !other.getGroupNames().equals(this.getGroupNames())) {
            return false;
        }
        if (other.getInstances() == null ^ this.getInstances() == null) {
            return false;
        }
        return other.getInstances() == null || other.getInstances().equals(this.getInstances());
    }
}

