/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.ec2.model;

import com.cloudera.com.amazonaws.internal.ListWithAutoConstructFlag;
import com.cloudera.com.amazonaws.services.ec2.model.GroupIdentifier;
import com.cloudera.com.amazonaws.services.ec2.model.NetworkInterfaceAssociation;
import com.cloudera.com.amazonaws.services.ec2.model.NetworkInterfaceAttachment;
import com.cloudera.com.amazonaws.services.ec2.model.NetworkInterfacePrivateIpAddress;
import com.cloudera.com.amazonaws.services.ec2.model.NetworkInterfaceStatus;
import com.cloudera.com.amazonaws.services.ec2.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkInterface
implements Serializable {
    private String networkInterfaceId;
    private String subnetId;
    private String vpcId;
    private String availabilityZone;
    private String description;
    private String ownerId;
    private String requesterId;
    private Boolean requesterManaged;
    private String status;
    private String macAddress;
    private String privateIpAddress;
    private String privateDnsName;
    private Boolean sourceDestCheck;
    private ListWithAutoConstructFlag<GroupIdentifier> groups;
    private NetworkInterfaceAttachment attachment;
    private NetworkInterfaceAssociation association;
    private ListWithAutoConstructFlag<Tag> tagSet;
    private ListWithAutoConstructFlag<NetworkInterfacePrivateIpAddress> privateIpAddresses;

    public String getNetworkInterfaceId() {
        return this.networkInterfaceId;
    }

    public void setNetworkInterfaceId(String networkInterfaceId) {
        this.networkInterfaceId = networkInterfaceId;
    }

    public NetworkInterface withNetworkInterfaceId(String networkInterfaceId) {
        this.networkInterfaceId = networkInterfaceId;
        return this;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public NetworkInterface withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public NetworkInterface withVpcId(String vpcId) {
        this.vpcId = vpcId;
        return this;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public NetworkInterface withAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public NetworkInterface withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public NetworkInterface withOwnerId(String ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    public String getRequesterId() {
        return this.requesterId;
    }

    public void setRequesterId(String requesterId) {
        this.requesterId = requesterId;
    }

    public NetworkInterface withRequesterId(String requesterId) {
        this.requesterId = requesterId;
        return this;
    }

    public Boolean isRequesterManaged() {
        return this.requesterManaged;
    }

    public void setRequesterManaged(Boolean requesterManaged) {
        this.requesterManaged = requesterManaged;
    }

    public NetworkInterface withRequesterManaged(Boolean requesterManaged) {
        this.requesterManaged = requesterManaged;
        return this;
    }

    public Boolean getRequesterManaged() {
        return this.requesterManaged;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public NetworkInterface withStatus(String status) {
        this.status = status;
        return this;
    }

    public void setStatus(NetworkInterfaceStatus status) {
        this.status = status.toString();
    }

    public NetworkInterface withStatus(NetworkInterfaceStatus status) {
        this.status = status.toString();
        return this;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public NetworkInterface withMacAddress(String macAddress) {
        this.macAddress = macAddress;
        return this;
    }

    public String getPrivateIpAddress() {
        return this.privateIpAddress;
    }

    public void setPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
    }

    public NetworkInterface withPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
        return this;
    }

    public String getPrivateDnsName() {
        return this.privateDnsName;
    }

    public void setPrivateDnsName(String privateDnsName) {
        this.privateDnsName = privateDnsName;
    }

    public NetworkInterface withPrivateDnsName(String privateDnsName) {
        this.privateDnsName = privateDnsName;
        return this;
    }

    public Boolean isSourceDestCheck() {
        return this.sourceDestCheck;
    }

    public void setSourceDestCheck(Boolean sourceDestCheck) {
        this.sourceDestCheck = sourceDestCheck;
    }

    public NetworkInterface withSourceDestCheck(Boolean sourceDestCheck) {
        this.sourceDestCheck = sourceDestCheck;
        return this;
    }

    public Boolean getSourceDestCheck() {
        return this.sourceDestCheck;
    }

    public List<GroupIdentifier> getGroups() {
        if (this.groups == null) {
            this.groups = new ListWithAutoConstructFlag();
            this.groups.setAutoConstruct(true);
        }
        return this.groups;
    }

    public void setGroups(Collection<GroupIdentifier> groups) {
        if (groups == null) {
            this.groups = null;
            return;
        }
        ListWithAutoConstructFlag groupsCopy = new ListWithAutoConstructFlag(groups.size());
        groupsCopy.addAll(groups);
        this.groups = groupsCopy;
    }

    public NetworkInterface withGroups(GroupIdentifier ... groups) {
        if (this.getGroups() == null) {
            this.setGroups(new ArrayList<GroupIdentifier>(groups.length));
        }
        for (GroupIdentifier value : groups) {
            this.getGroups().add(value);
        }
        return this;
    }

    public NetworkInterface withGroups(Collection<GroupIdentifier> groups) {
        if (groups == null) {
            this.groups = null;
        } else {
            ListWithAutoConstructFlag groupsCopy = new ListWithAutoConstructFlag(groups.size());
            groupsCopy.addAll(groups);
            this.groups = groupsCopy;
        }
        return this;
    }

    public NetworkInterfaceAttachment getAttachment() {
        return this.attachment;
    }

    public void setAttachment(NetworkInterfaceAttachment attachment) {
        this.attachment = attachment;
    }

    public NetworkInterface withAttachment(NetworkInterfaceAttachment attachment) {
        this.attachment = attachment;
        return this;
    }

    public NetworkInterfaceAssociation getAssociation() {
        return this.association;
    }

    public void setAssociation(NetworkInterfaceAssociation association) {
        this.association = association;
    }

    public NetworkInterface withAssociation(NetworkInterfaceAssociation association) {
        this.association = association;
        return this;
    }

    public List<Tag> getTagSet() {
        if (this.tagSet == null) {
            this.tagSet = new ListWithAutoConstructFlag();
            this.tagSet.setAutoConstruct(true);
        }
        return this.tagSet;
    }

    public void setTagSet(Collection<Tag> tagSet) {
        if (tagSet == null) {
            this.tagSet = null;
            return;
        }
        ListWithAutoConstructFlag tagSetCopy = new ListWithAutoConstructFlag(tagSet.size());
        tagSetCopy.addAll(tagSet);
        this.tagSet = tagSetCopy;
    }

    public NetworkInterface withTagSet(Tag ... tagSet) {
        if (this.getTagSet() == null) {
            this.setTagSet(new ArrayList<Tag>(tagSet.length));
        }
        for (Tag value : tagSet) {
            this.getTagSet().add(value);
        }
        return this;
    }

    public NetworkInterface withTagSet(Collection<Tag> tagSet) {
        if (tagSet == null) {
            this.tagSet = null;
        } else {
            ListWithAutoConstructFlag tagSetCopy = new ListWithAutoConstructFlag(tagSet.size());
            tagSetCopy.addAll(tagSet);
            this.tagSet = tagSetCopy;
        }
        return this;
    }

    public List<NetworkInterfacePrivateIpAddress> getPrivateIpAddresses() {
        if (this.privateIpAddresses == null) {
            this.privateIpAddresses = new ListWithAutoConstructFlag();
            this.privateIpAddresses.setAutoConstruct(true);
        }
        return this.privateIpAddresses;
    }

    public void setPrivateIpAddresses(Collection<NetworkInterfacePrivateIpAddress> privateIpAddresses) {
        if (privateIpAddresses == null) {
            this.privateIpAddresses = null;
            return;
        }
        ListWithAutoConstructFlag privateIpAddressesCopy = new ListWithAutoConstructFlag(privateIpAddresses.size());
        privateIpAddressesCopy.addAll(privateIpAddresses);
        this.privateIpAddresses = privateIpAddressesCopy;
    }

    public NetworkInterface withPrivateIpAddresses(NetworkInterfacePrivateIpAddress ... privateIpAddresses) {
        if (this.getPrivateIpAddresses() == null) {
            this.setPrivateIpAddresses(new ArrayList<NetworkInterfacePrivateIpAddress>(privateIpAddresses.length));
        }
        for (NetworkInterfacePrivateIpAddress value : privateIpAddresses) {
            this.getPrivateIpAddresses().add(value);
        }
        return this;
    }

    public NetworkInterface withPrivateIpAddresses(Collection<NetworkInterfacePrivateIpAddress> privateIpAddresses) {
        if (privateIpAddresses == null) {
            this.privateIpAddresses = null;
        } else {
            ListWithAutoConstructFlag privateIpAddressesCopy = new ListWithAutoConstructFlag(privateIpAddresses.size());
            privateIpAddressesCopy.addAll(privateIpAddresses);
            this.privateIpAddresses = privateIpAddressesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNetworkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: " + this.getNetworkInterfaceId() + ",");
        }
        if (this.getSubnetId() != null) {
            sb.append("SubnetId: " + this.getSubnetId() + ",");
        }
        if (this.getVpcId() != null) {
            sb.append("VpcId: " + this.getVpcId() + ",");
        }
        if (this.getAvailabilityZone() != null) {
            sb.append("AvailabilityZone: " + this.getAvailabilityZone() + ",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription() + ",");
        }
        if (this.getOwnerId() != null) {
            sb.append("OwnerId: " + this.getOwnerId() + ",");
        }
        if (this.getRequesterId() != null) {
            sb.append("RequesterId: " + this.getRequesterId() + ",");
        }
        if (this.isRequesterManaged() != null) {
            sb.append("RequesterManaged: " + this.isRequesterManaged() + ",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: " + this.getStatus() + ",");
        }
        if (this.getMacAddress() != null) {
            sb.append("MacAddress: " + this.getMacAddress() + ",");
        }
        if (this.getPrivateIpAddress() != null) {
            sb.append("PrivateIpAddress: " + this.getPrivateIpAddress() + ",");
        }
        if (this.getPrivateDnsName() != null) {
            sb.append("PrivateDnsName: " + this.getPrivateDnsName() + ",");
        }
        if (this.isSourceDestCheck() != null) {
            sb.append("SourceDestCheck: " + this.isSourceDestCheck() + ",");
        }
        if (this.getGroups() != null) {
            sb.append("Groups: " + this.getGroups() + ",");
        }
        if (this.getAttachment() != null) {
            sb.append("Attachment: " + this.getAttachment() + ",");
        }
        if (this.getAssociation() != null) {
            sb.append("Association: " + this.getAssociation() + ",");
        }
        if (this.getTagSet() != null) {
            sb.append("TagSet: " + this.getTagSet() + ",");
        }
        if (this.getPrivateIpAddresses() != null) {
            sb.append("PrivateIpAddresses: " + this.getPrivateIpAddresses());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNetworkInterfaceId() == null ? 0 : this.getNetworkInterfaceId().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetId() == null ? 0 : this.getSubnetId().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getOwnerId() == null ? 0 : this.getOwnerId().hashCode());
        hashCode = 31 * hashCode + (this.getRequesterId() == null ? 0 : this.getRequesterId().hashCode());
        hashCode = 31 * hashCode + (this.isRequesterManaged() == null ? 0 : this.isRequesterManaged().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getMacAddress() == null ? 0 : this.getMacAddress().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateIpAddress() == null ? 0 : this.getPrivateIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateDnsName() == null ? 0 : this.getPrivateDnsName().hashCode());
        hashCode = 31 * hashCode + (this.isSourceDestCheck() == null ? 0 : this.isSourceDestCheck().hashCode());
        hashCode = 31 * hashCode + (this.getGroups() == null ? 0 : this.getGroups().hashCode());
        hashCode = 31 * hashCode + (this.getAttachment() == null ? 0 : this.getAttachment().hashCode());
        hashCode = 31 * hashCode + (this.getAssociation() == null ? 0 : this.getAssociation().hashCode());
        hashCode = 31 * hashCode + (this.getTagSet() == null ? 0 : this.getTagSet().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateIpAddresses() == null ? 0 : this.getPrivateIpAddresses().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterface)) {
            return false;
        }
        NetworkInterface other = (NetworkInterface)obj;
        if (other.getNetworkInterfaceId() == null ^ this.getNetworkInterfaceId() == null) {
            return false;
        }
        if (other.getNetworkInterfaceId() != null && !other.getNetworkInterfaceId().equals(this.getNetworkInterfaceId())) {
            return false;
        }
        if (other.getSubnetId() == null ^ this.getSubnetId() == null) {
            return false;
        }
        if (other.getSubnetId() != null && !other.getSubnetId().equals(this.getSubnetId())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        if (other.getAvailabilityZone() != null && !other.getAvailabilityZone().equals(this.getAvailabilityZone())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getOwnerId() == null ^ this.getOwnerId() == null) {
            return false;
        }
        if (other.getOwnerId() != null && !other.getOwnerId().equals(this.getOwnerId())) {
            return false;
        }
        if (other.getRequesterId() == null ^ this.getRequesterId() == null) {
            return false;
        }
        if (other.getRequesterId() != null && !other.getRequesterId().equals(this.getRequesterId())) {
            return false;
        }
        if (other.isRequesterManaged() == null ^ this.isRequesterManaged() == null) {
            return false;
        }
        if (other.isRequesterManaged() != null && !other.isRequesterManaged().equals(this.isRequesterManaged())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getMacAddress() == null ^ this.getMacAddress() == null) {
            return false;
        }
        if (other.getMacAddress() != null && !other.getMacAddress().equals(this.getMacAddress())) {
            return false;
        }
        if (other.getPrivateIpAddress() == null ^ this.getPrivateIpAddress() == null) {
            return false;
        }
        if (other.getPrivateIpAddress() != null && !other.getPrivateIpAddress().equals(this.getPrivateIpAddress())) {
            return false;
        }
        if (other.getPrivateDnsName() == null ^ this.getPrivateDnsName() == null) {
            return false;
        }
        if (other.getPrivateDnsName() != null && !other.getPrivateDnsName().equals(this.getPrivateDnsName())) {
            return false;
        }
        if (other.isSourceDestCheck() == null ^ this.isSourceDestCheck() == null) {
            return false;
        }
        if (other.isSourceDestCheck() != null && !other.isSourceDestCheck().equals(this.isSourceDestCheck())) {
            return false;
        }
        if (other.getGroups() == null ^ this.getGroups() == null) {
            return false;
        }
        if (other.getGroups() != null && !other.getGroups().equals(this.getGroups())) {
            return false;
        }
        if (other.getAttachment() == null ^ this.getAttachment() == null) {
            return false;
        }
        if (other.getAttachment() != null && !other.getAttachment().equals(this.getAttachment())) {
            return false;
        }
        if (other.getAssociation() == null ^ this.getAssociation() == null) {
            return false;
        }
        if (other.getAssociation() != null && !other.getAssociation().equals(this.getAssociation())) {
            return false;
        }
        if (other.getTagSet() == null ^ this.getTagSet() == null) {
            return false;
        }
        if (other.getTagSet() != null && !other.getTagSet().equals(this.getTagSet())) {
            return false;
        }
        if (other.getPrivateIpAddresses() == null ^ this.getPrivateIpAddresses() == null) {
            return false;
        }
        return other.getPrivateIpAddresses() == null || other.getPrivateIpAddresses().equals(this.getPrivateIpAddresses());
    }
}

