/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.cloudwatch.model;

import com.cloudera.com.amazonaws.internal.ListWithAutoConstructFlag;
import com.cloudera.com.amazonaws.services.cloudwatch.model.Dimension;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Metric
implements Serializable {
    private String namespace;
    private String metricName;
    private ListWithAutoConstructFlag<Dimension> dimensions;

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public Metric withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public Metric withMetricName(String metricName) {
        this.metricName = metricName;
        return this;
    }

    public List<Dimension> getDimensions() {
        if (this.dimensions == null) {
            this.dimensions = new ListWithAutoConstructFlag();
            this.dimensions.setAutoConstruct(true);
        }
        return this.dimensions;
    }

    public void setDimensions(Collection<Dimension> dimensions) {
        if (dimensions == null) {
            this.dimensions = null;
            return;
        }
        ListWithAutoConstructFlag dimensionsCopy = new ListWithAutoConstructFlag(dimensions.size());
        dimensionsCopy.addAll(dimensions);
        this.dimensions = dimensionsCopy;
    }

    public Metric withDimensions(Dimension ... dimensions) {
        if (this.getDimensions() == null) {
            this.setDimensions(new ArrayList<Dimension>(dimensions.length));
        }
        for (Dimension value : dimensions) {
            this.getDimensions().add(value);
        }
        return this;
    }

    public Metric withDimensions(Collection<Dimension> dimensions) {
        if (dimensions == null) {
            this.dimensions = null;
        } else {
            ListWithAutoConstructFlag dimensionsCopy = new ListWithAutoConstructFlag(dimensions.size());
            dimensionsCopy.addAll(dimensions);
            this.dimensions = dimensionsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNamespace() != null) {
            sb.append("Namespace: " + this.getNamespace() + ",");
        }
        if (this.getMetricName() != null) {
            sb.append("MetricName: " + this.getMetricName() + ",");
        }
        if (this.getDimensions() != null) {
            sb.append("Dimensions: " + this.getDimensions());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNamespace() == null ? 0 : this.getNamespace().hashCode());
        hashCode = 31 * hashCode + (this.getMetricName() == null ? 0 : this.getMetricName().hashCode());
        hashCode = 31 * hashCode + (this.getDimensions() == null ? 0 : this.getDimensions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Metric)) {
            return false;
        }
        Metric other = (Metric)obj;
        if (other.getNamespace() == null ^ this.getNamespace() == null) {
            return false;
        }
        if (other.getNamespace() != null && !other.getNamespace().equals(this.getNamespace())) {
            return false;
        }
        if (other.getMetricName() == null ^ this.getMetricName() == null) {
            return false;
        }
        if (other.getMetricName() != null && !other.getMetricName().equals(this.getMetricName())) {
            return false;
        }
        if (other.getDimensions() == null ^ this.getDimensions() == null) {
            return false;
        }
        return other.getDimensions() == null || other.getDimensions().equals(this.getDimensions());
    }
}

