/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.cloudwatch.model;

import com.cloudera.com.amazonaws.internal.ListWithAutoConstructFlag;
import com.cloudera.com.amazonaws.services.cloudwatch.model.Datapoint;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetMetricStatisticsResult
implements Serializable {
    private String label;
    private ListWithAutoConstructFlag<Datapoint> datapoints;

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public GetMetricStatisticsResult withLabel(String label) {
        this.label = label;
        return this;
    }

    public List<Datapoint> getDatapoints() {
        if (this.datapoints == null) {
            this.datapoints = new ListWithAutoConstructFlag();
            this.datapoints.setAutoConstruct(true);
        }
        return this.datapoints;
    }

    public void setDatapoints(Collection<Datapoint> datapoints) {
        if (datapoints == null) {
            this.datapoints = null;
            return;
        }
        ListWithAutoConstructFlag datapointsCopy = new ListWithAutoConstructFlag(datapoints.size());
        datapointsCopy.addAll(datapoints);
        this.datapoints = datapointsCopy;
    }

    public GetMetricStatisticsResult withDatapoints(Datapoint ... datapoints) {
        if (this.getDatapoints() == null) {
            this.setDatapoints(new ArrayList<Datapoint>(datapoints.length));
        }
        for (Datapoint value : datapoints) {
            this.getDatapoints().add(value);
        }
        return this;
    }

    public GetMetricStatisticsResult withDatapoints(Collection<Datapoint> datapoints) {
        if (datapoints == null) {
            this.datapoints = null;
        } else {
            ListWithAutoConstructFlag datapointsCopy = new ListWithAutoConstructFlag(datapoints.size());
            datapointsCopy.addAll(datapoints);
            this.datapoints = datapointsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLabel() != null) {
            sb.append("Label: " + this.getLabel() + ",");
        }
        if (this.getDatapoints() != null) {
            sb.append("Datapoints: " + this.getDatapoints());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLabel() == null ? 0 : this.getLabel().hashCode());
        hashCode = 31 * hashCode + (this.getDatapoints() == null ? 0 : this.getDatapoints().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetricStatisticsResult)) {
            return false;
        }
        GetMetricStatisticsResult other = (GetMetricStatisticsResult)obj;
        if (other.getLabel() == null ^ this.getLabel() == null) {
            return false;
        }
        if (other.getLabel() != null && !other.getLabel().equals(this.getLabel())) {
            return false;
        }
        if (other.getDatapoints() == null ^ this.getDatapoints() == null) {
            return false;
        }
        return other.getDatapoints() == null || other.getDatapoints().equals(this.getDatapoints());
    }
}

