/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.Mozilla;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.mozilla.nsIBaseWindow;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

class MozillaDelegate {
    Browser browser;
    Shell eventShell;
    long mozillaHandle;
    long embedHandle;
    boolean hasFocus;
    Listener listener;
    static Callback eventCallback;
    static long eventProc;
    static final int STOP_PROPOGATE = 1;
    static boolean IsSparc;
    static /* synthetic */ Class class$org$eclipse$swt$internal$Library;

    MozillaDelegate(Browser browser) {
        if (IsSparc) {
            byte[] byArray = Converter.wcsToMbcs(null, "libCrun.so.1", true);
            OS.dlopen(byArray, OS.RTLD_NOW | OS.RTLD_GLOBAL);
        }
        this.browser = browser;
    }

    static long eventProc(long l, long l2, long l3) {
        long l4 = OS.gtk_widget_get_parent(l);
        if ((l4 = OS.gtk_widget_get_parent(l4)) == 0L) {
            return 0L;
        }
        Widget widget = Display.getCurrent().findWidget(l4);
        if (widget != null && widget instanceof Browser) {
            return ((Mozilla)((Browser)widget).webBrowser).delegate.gtk_event(l, l2, l3);
        }
        return 0L;
    }

    static Browser findBrowser(long l) {
        long l2 = OS.gtk_widget_get_parent(l);
        Display display = Display.getCurrent();
        return (Browser)display.findWidget(l2);
    }

    static String getCacheParentPath() {
        return MozillaDelegate.getProfilePath();
    }

    static String[] getJSLibraryNames() {
        return new String[]{"libxul.so"};
    }

    static String getJSLibraryName_Pre4() {
        return "libmozjs.so";
    }

    static String getLibraryName() {
        return "libxpcom.so";
    }

    static String getProfilePath() {
        long l;
        String string = System.getProperty("user.home");
        if (string.equals("?") && (l = C.getenv(MozillaDelegate.wcsToMbcs(null, "HOME", true))) != 0L) {
            int n = C.strlen(l);
            byte[] byArray = new byte[n];
            C.memmove(byArray, l, (long)n);
            string = new String(MozillaDelegate.mbcsToWcs(null, byArray));
        }
        return string + Mozilla.SEPARATOR_OS + ".mozilla" + Mozilla.SEPARATOR_OS + "eclipse";
    }

    static String getSWTInitLibraryName() {
        return "swt-xpcominit";
    }

    static void loadAdditionalLibraries(String string) {
        Object object;
        if (Mozilla.IsPre_4) {
            return;
        }
        String string2 = "libswt-xulrunner-fix.so";
        File file = new File(MozillaDelegate.getProfilePath() + "/libs/" + Mozilla.OS() + '/' + Mozilla.Arch());
        File file2 = new File(file, string2);
        if (!file2.exists() && (object = (Object)(class$org$eclipse$swt$internal$Library == null ? (class$org$eclipse$swt$internal$Library = MozillaDelegate.class$("org.eclipse.swt.internal.Library")) : class$org$eclipse$swt$internal$Library).getResourceAsStream('/' + string2)) != null) {
            if (!file.exists()) {
                file.mkdirs();
            }
            byte[] byArray = new byte[4096];
            try {
                int n;
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                while ((n = ((InputStream)object).read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
                fileOutputStream.close();
                ((InputStream)object).close();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (file2.exists()) {
            object = Converter.wcsToMbcs(null, file2.getAbsolutePath(), true);
            OS.dlopen((byte[])object, OS.RTLD_NOW | OS.RTLD_GLOBAL);
        }
    }

    static char[] mbcsToWcs(String string, byte[] byArray) {
        return Converter.mbcsToWcs(string, byArray);
    }

    static boolean needsSpinup() {
        return true;
    }

    static boolean supportsXULRunner17() {
        return false;
    }

    static byte[] wcsToMbcs(String string, String string2, boolean bl) {
        return Converter.wcsToMbcs(string, string2, bl);
    }

    void addWindowSubclass() {
    }

    int createBaseWindow(nsIBaseWindow nsIBaseWindow2) {
        return nsIBaseWindow2.Create();
    }

    long getHandle() {
        if (OS.GTK3) {
            this.embedHandle = OS.gtk_box_new(0, 0);
            OS.gtk_box_set_homogeneous(this.embedHandle, false);
        } else {
            this.embedHandle = OS.gtk_hbox_new(false, 0);
        }
        OS.gtk_container_add(this.browser.handle, this.embedHandle);
        OS.gtk_widget_show(this.embedHandle);
        return this.embedHandle;
    }

    long getSiteWindow() {
        return this.embedHandle;
    }

    long gtk_event(long l, long l2, long l3) {
        GdkEvent gdkEvent = new GdkEvent();
        OS.memmove(gdkEvent, l2, (long)GdkEvent.sizeof);
        if (gdkEvent.type == 4 && !this.hasFocus) {
            this.browser.setFocus();
        }
        if (l3 == 1L) {
            return 1L;
        }
        return 0L;
    }

    void handleFocus() {
        if (this.hasFocus) {
            return;
        }
        this.hasFocus = true;
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == MozillaDelegate.this.browser) {
                    return;
                }
                if (event.type != 12) {
                    ((Mozilla)MozillaDelegate.this.browser.webBrowser).Deactivate();
                    MozillaDelegate.this.hasFocus = false;
                }
                MozillaDelegate.this.eventShell.getDisplay().removeFilter(15, this);
                MozillaDelegate.this.eventShell.removeListener(27, this);
                MozillaDelegate.this.eventShell.removeListener(12, this);
                MozillaDelegate.this.eventShell = null;
                MozillaDelegate.this.listener = null;
            }
        };
        this.eventShell = this.browser.getShell();
        this.eventShell.getDisplay().addFilter(15, this.listener);
        this.eventShell.addListener(27, this.listener);
        this.eventShell.addListener(12, this.listener);
    }

    void handleMouseDown() {
        int n = this.browser.getShell().getStyle();
        if ((n & 0x4000) != 0 && ((n & 0x80000) == 0 || (this.browser.getStyle() & 0x80000) == 0)) {
            this.browser.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (MozillaDelegate.this.browser == null || MozillaDelegate.this.browser.isDisposed()) {
                        return;
                    }
                    ((Mozilla)MozillaDelegate.this.browser.webBrowser).Activate();
                }
            });
        }
    }

    boolean hookEnterExit() {
        return false;
    }

    void init() {
        long l;
        if (eventCallback == null && (eventProc = (eventCallback = new Callback(this.getClass(), "eventProc", 3)).getAddress()) == 0L) {
            this.browser.dispose();
            Mozilla.error(3);
        }
        if ((l = OS.gtk_container_get_children(this.embedHandle)) != 0L) {
            this.mozillaHandle = OS.g_list_data(l);
            OS.g_list_free(l);
            if (this.mozillaHandle != 0L) {
                OS.g_signal_connect(this.mozillaHandle, OS.event, eventProc, 0L);
                OS.g_signal_connect(this.mozillaHandle, OS.key_press_event, eventProc, 1L);
                OS.g_signal_connect(this.mozillaHandle, OS.key_release_event, eventProc, 1L);
                OS.g_signal_connect(this.mozillaHandle, OS.button_press_event, eventProc, 1L);
            }
        }
    }

    void onDispose(long l) {
        if (this.listener != null) {
            this.eventShell.getDisplay().removeFilter(15, this.listener);
            this.eventShell.removeListener(27, this.listener);
            this.eventShell.removeListener(12, this.listener);
            this.eventShell = null;
            this.listener = null;
        }
        this.browser = null;
    }

    void removeWindowSubclass() {
    }

    boolean sendTraverse() {
        return true;
    }

    void setSize(long l, int n, int n2) {
        OS.gtk_widget_set_size_request(l, n, n2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = System.getProperty("os.arch").toLowerCase();
        IsSparc = (string.startsWith("sunos") || string.startsWith("solaris")) && string2.startsWith("sparc");
    }
}

