/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.bridge;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.util.concurrent.SettableFuture;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeatureEvent;
import org.apache.karaf.features.FeaturesListener;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.RepositoryEvent;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.pentaho.capabilities.api.ICapability;
import org.pentaho.capabilities.api.ICapabilityProvider;
import org.pentaho.capabilities.impl.DefaultCapabilityManager;
import org.pentaho.osgi.bridge.KarafCapability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarafCapabilityProvider
extends ServiceTracker<FeaturesService, FeaturesService>
implements ICapabilityProvider,
FeaturesListener {
    public static final String KARAF = "Karaf";
    private BundleContext bundleContext;
    private FeaturesService featuresService;
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final boolean UNINSTALL = false;
    private static final boolean INSTALL = true;
    Cache<String, InstallFuture> futures = CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(1024L).expireAfterWrite(20L, TimeUnit.SECONDS).removalListener((RemovalListener)new RemovalListener<String, InstallFuture>(){

        public void onRemoval(RemovalNotification<String, InstallFuture> removalNotification) {
            switch (removalNotification.getCause()) {
                case EXPLICIT: {
                    break;
                }
                case REPLACED: 
                case COLLECTED: 
                case EXPIRED: 
                case SIZE: {
                    SettableFuture<Boolean> value = ((InstallFuture)removalNotification.getValue()).future;
                    if (value == null) break;
                    value.set((Object)false);
                }
            }
        }
    }).build();

    public KarafCapabilityProvider(BundleContext bundleContext) {
        super(bundleContext, FeaturesService.class, null);
        this.bundleContext = bundleContext;
        this.bundleContext.registerService(FeaturesListener.class, (Object)this, null);
    }

    public FeaturesService addingService(ServiceReference<FeaturesService> reference) {
        this.featuresService = (FeaturesService)this.bundleContext.getService(reference);
        if (!this.initialized.getAndSet(true)) {
            DefaultCapabilityManager.getInstance().registerCapabilityProvider((ICapabilityProvider)this);
        }
        return (FeaturesService)super.addingService(reference);
    }

    public String getId() {
        return KARAF;
    }

    public Set<String> listCapabilities() {
        HashSet<String> ids = new HashSet<String>();
        try {
            for (Feature feature : this.featuresService.listFeatures()) {
                ids.add(feature.getName());
            }
        }
        catch (Exception e) {
            this.logger.error("Unknown error trying to retrieve available Karaf features", (Throwable)e);
            return ids;
        }
        return ids;
    }

    public ICapability getCapabilityById(String id) {
        try {
            Feature feature = this.featuresService.getFeature(id);
            if (feature == null) {
                this.logger.error("No feature found matching id: " + id);
                return null;
            }
            return new KarafCapability(this.featuresService, feature, this);
        }
        catch (Exception e) {
            this.logger.error("Unknown error retrieving feature: " + id, (Throwable)e);
            return null;
        }
    }

    public Set<ICapability> getAllCapabilities() {
        HashSet<ICapability> capabilities = new HashSet<ICapability>();
        try {
            for (Feature feature : this.featuresService.listFeatures()) {
                ICapability capabilityById = this.getCapabilityById(feature.getName());
                if (capabilityById == null) continue;
                capabilities.add(capabilityById);
            }
        }
        catch (Exception e) {
            this.logger.error("Unknown error trying to retrieve available Karaf features", (Throwable)e);
            return capabilities;
        }
        return capabilities;
    }

    public void watchForInstall(Feature feature, SettableFuture<Boolean> future) {
        this.futures.put((Object)feature.getId(), (Object)new InstallFuture(future, true));
    }

    public void watchForUnInstall(Feature feature, SettableFuture<Boolean> uninstallFuture) {
        this.futures.put((Object)feature.getId(), (Object)new InstallFuture(uninstallFuture, false));
    }

    public void featureEvent(FeatureEvent featureEvent) {
        String feature = featureEvent.getFeature().getId();
        InstallFuture installFutureWrapper = (InstallFuture)this.futures.getIfPresent((Object)feature);
        if (installFutureWrapper == null) {
            return;
        }
        switch (featureEvent.getType()) {
            case FeatureInstalled: {
                SettableFuture<Boolean> future = installFutureWrapper.future;
                if (future == null) break;
                this.futures.invalidate((Object)feature);
                future.set((Object)installFutureWrapper.install);
                break;
            }
            case FeatureUninstalled: {
                SettableFuture<Boolean> future = installFutureWrapper.future;
                if (future == null) break;
                this.futures.invalidate((Object)feature);
                future.set((Object)(!installFutureWrapper.install ? 1 : 0));
            }
        }
    }

    public void repositoryEvent(RepositoryEvent repositoryEvent) {
    }

    private class InstallFuture {
        SettableFuture<Boolean> future;
        boolean install;

        public InstallFuture(SettableFuture<Boolean> future, boolean install) {
            this.future = future;
            this.install = install;
        }
    }
}

