/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.cassandrasstableoutput;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.cassandrasstableoutput.SSTableOutput;
import org.pentaho.di.trans.steps.cassandrasstableoutput.SSTableOutputData;
import org.w3c.dom.Node;

@Step(id="SSTableOutput", image="Cassandra.svg", name="SSTable Output", description="Writes to a filesystem directory as a Cassandra SSTable", categoryDescription="Big Data")
public class SSTableOutputMeta
extends BaseStepMeta
implements StepMetaInterface {
    protected static final Class<?> PKG = SSTableOutputMeta.class;
    protected String m_yamlPath;
    protected String directory;
    protected String cassandraKeyspace;
    protected String columnFamily = "";
    protected String keyField = "";
    protected String bufferSize = "16";

    public String getYamlPath() {
        return this.m_yamlPath;
    }

    public void setYamlPath(String path) {
        this.m_yamlPath = path;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public void setCassandraKeyspace(String keyspace) {
        this.cassandraKeyspace = keyspace;
    }

    public String getCassandraKeyspace() {
        return this.cassandraKeyspace;
    }

    public void setColumnFamilyName(String colFam) {
        this.columnFamily = colFam;
    }

    public String getColumnFamilyName() {
        return this.columnFamily;
    }

    public void setKeyField(String keyField) {
        this.keyField = keyField;
    }

    public String getKeyField() {
        return this.keyField;
    }

    public String getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(String bufferSize) {
        this.bufferSize = bufferSize;
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer();
        if (!Const.isEmpty((String)this.m_yamlPath)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"yaml_path", (String)this.m_yamlPath));
        }
        if (!Const.isEmpty((String)this.directory)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"output_directory", (String)this.directory));
        }
        if (!Const.isEmpty((String)this.cassandraKeyspace)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"cassandra_keyspace", (String)this.cassandraKeyspace));
        }
        if (!Const.isEmpty((String)this.cassandraKeyspace)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"cassandra_keyspace", (String)this.cassandraKeyspace));
        }
        if (!Const.isEmpty((String)this.columnFamily)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"column_family", (String)this.columnFamily));
        }
        if (!Const.isEmpty((String)this.keyField)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"key_field", (String)this.keyField));
        }
        if (!Const.isEmpty((String)this.bufferSize)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"buffer_size_mb", (String)this.bufferSize));
        }
        return retval.toString();
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.m_yamlPath = XMLHandler.getTagValue((Node)stepnode, (String)"yaml_path");
        this.directory = XMLHandler.getTagValue((Node)stepnode, (String)"output_directory");
        this.cassandraKeyspace = XMLHandler.getTagValue((Node)stepnode, (String)"cassandra_keyspace");
        this.columnFamily = XMLHandler.getTagValue((Node)stepnode, (String)"column_family");
        this.keyField = XMLHandler.getTagValue((Node)stepnode, (String)"key_field");
        this.bufferSize = XMLHandler.getTagValue((Node)stepnode, (String)"buffer_size_mb");
    }

    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        this.m_yamlPath = rep.getStepAttributeString(id_step, 0, "yaml_path");
        this.directory = rep.getStepAttributeString(id_step, 0, "output_directory");
        this.cassandraKeyspace = rep.getStepAttributeString(id_step, 0, "cassandra_keyspace");
        this.columnFamily = rep.getStepAttributeString(id_step, 0, "column_family");
        this.keyField = rep.getStepAttributeString(id_step, 0, "key_field");
        this.bufferSize = rep.getStepAttributeString(id_step, 0, "buffer_size_mb");
    }

    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        if (!Const.isEmpty((String)this.m_yamlPath)) {
            rep.saveStepAttribute(id_transformation, id_step, "yaml_path", this.m_yamlPath);
        }
        if (!Const.isEmpty((String)this.directory)) {
            rep.saveStepAttribute(id_transformation, id_step, "output_directory", this.directory);
        }
        if (!Const.isEmpty((String)this.cassandraKeyspace)) {
            rep.saveStepAttribute(id_transformation, id_step, "cassandra_keyspace", this.cassandraKeyspace);
        }
        if (!Const.isEmpty((String)this.columnFamily)) {
            rep.saveStepAttribute(id_transformation, id_step, "column_family", this.columnFamily);
        }
        if (!Const.isEmpty((String)this.keyField)) {
            rep.saveStepAttribute(id_transformation, id_step, "key_field", this.keyField);
        }
        if (!Const.isEmpty((String)this.bufferSize)) {
            rep.saveStepAttribute(id_transformation, id_step, "buffer_size_mb", this.bufferSize);
        }
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, "Not receiving any fields from previous steps!", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, "Step is connected to previous one, receiving " + prev.size() + " fields", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, "Step is receiving info from other steps.", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, "No input received from other steps!", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        return new SSTableOutput(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public StepDataInterface getStepData() {
        return new SSTableOutputData();
    }

    public void setDefault() {
        this.directory = System.getProperty("java.io.tmpdir");
        this.bufferSize = "16";
        this.columnFamily = "";
    }

    public String getDialogClassName() {
        return "org.pentaho.di.trans.steps.cassandrasstableoutput.SSTableOutputDialog";
    }
}

