/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.models.annotations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotation;
import org.pentaho.agilebi.modeler.models.annotations.data.DataProvider;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.persist.MetaStoreAttribute;
import org.pentaho.metastore.persist.MetaStoreElementType;
import org.w3c.dom.Document;

@MetaStoreElementType(name="ModelAnnotationGroup", description="ModelAnnotationGroup")
public class ModelAnnotationGroup
extends ArrayList<ModelAnnotation> {
    @MetaStoreAttribute
    private String id;
    @MetaStoreAttribute
    private String name;
    @MetaStoreAttribute
    private String description;
    @MetaStoreAttribute
    private boolean sharedDimension;
    @MetaStoreAttribute
    private List<DataProvider> dataProviders = new ArrayList<DataProvider>();
    @MetaStoreAttribute
    private List<ModelAnnotation> modelAnnotations;

    public ModelAnnotationGroup() {
    }

    public ModelAnnotationGroup(ModelAnnotation ... modelAnnotations) {
        super(Arrays.asList(modelAnnotations));
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<ModelAnnotation> getModelAnnotations() {
        return this;
    }

    public void setModelAnnotations(List<ModelAnnotation> modelAnnotations) {
        this.removeRange(0, this.size());
        if (modelAnnotations != null) {
            this.addAll(modelAnnotations);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isSharedDimension() {
        return this.sharedDimension;
    }

    public void setSharedDimension(boolean sharedDimension) {
        this.sharedDimension = sharedDimension;
    }

    public List<DataProvider> getDataProviders() {
        return this.dataProviders;
    }

    public void setDataProviders(List<DataProvider> dataProviders) {
        this.dataProviders = dataProviders;
    }

    @Override
    public boolean equals(Object obj) {
        try {
            if (!EqualsBuilder.reflectionEquals((Object)this, (Object)obj)) {
                return false;
            }
            ModelAnnotationGroup objGroup = (ModelAnnotationGroup)obj;
            if (this.size() != objGroup.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (((ModelAnnotation)this.get(i)).equals(objGroup.get(i))) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Map<ApplyStatus, List<ModelAnnotation>> applyAnnotations(Document mondrianSchema) throws ModelerException {
        return this.applyAnnotations(mondrianSchema, this);
    }

    private Map<ApplyStatus, List<ModelAnnotation>> applyAnnotations(final Document mondrianSchema, ModelAnnotationGroup toApply) throws ModelerException {
        AnnotateStrategy strategy = new AnnotateStrategy(){

            @Override
            public boolean apply(ModelAnnotation modelAnnotation) throws ModelerException {
                return modelAnnotation.apply(mondrianSchema);
            }

            @Override
            public Map<ApplyStatus, List<ModelAnnotation>> applyAll(ModelAnnotationGroup modelAnnotations) throws ModelerException {
                return ModelAnnotationGroup.this.applyAnnotations(mondrianSchema, modelAnnotations);
            }

            @Override
            public boolean isEmptyModel() {
                return !mondrianSchema.hasChildNodes();
            }
        };
        return this.applyAnnotations(strategy, toApply);
    }

    public Map<ApplyStatus, List<ModelAnnotation>> applyAnnotations(ModelerWorkspace model, IMetaStore metaStore) throws ModelerException {
        return this.applyAnnotations(model, metaStore, this);
    }

    private Map<ApplyStatus, List<ModelAnnotation>> applyAnnotations(final ModelerWorkspace model, final IMetaStore metaStore, ModelAnnotationGroup toApply) throws ModelerException {
        AnnotateStrategy strategy = new AnnotateStrategy(){

            @Override
            public boolean apply(ModelAnnotation modelAnnotation) throws ModelerException {
                return modelAnnotation.apply(model, metaStore);
            }

            @Override
            public Map<ApplyStatus, List<ModelAnnotation>> applyAll(ModelAnnotationGroup modelAnnotations) throws ModelerException {
                return ModelAnnotationGroup.this.applyAnnotations(model, metaStore, modelAnnotations);
            }

            @Override
            public boolean isEmptyModel() {
                return model.getModel().getDimensions().size() == 0 && model.getModel().getMeasures().size() == 0;
            }
        };
        return this.applyAnnotations(strategy, toApply);
    }

    private Map<ApplyStatus, List<ModelAnnotation>> applyAnnotations(AnnotateStrategy strategy, ModelAnnotationGroup toApply) throws ModelerException {
        Map<ApplyStatus, List<ModelAnnotation>> statusMap;
        block7: {
            ModelAnnotationGroup failedAnnotations;
            block6: {
                if (strategy.isEmptyModel()) {
                    return Collections.emptyMap();
                }
                statusMap = this.initStatusMap();
                failedAnnotations = new ModelAnnotationGroup();
                for (ModelAnnotation modelAnnotation : toApply) {
                    if (modelAnnotation.getAnnotation() == null) {
                        statusMap.get((Object)ApplyStatus.NULL_ANNOTATION).add(modelAnnotation);
                        continue;
                    }
                    boolean applied = strategy.apply(modelAnnotation);
                    if (applied) {
                        statusMap.get((Object)ApplyStatus.SUCCESS).add(modelAnnotation);
                        continue;
                    }
                    failedAnnotations.add(modelAnnotation);
                }
                if (failedAnnotations.size() >= toApply.size()) break block6;
                Map<ApplyStatus, List<ModelAnnotation>> recurStatusMap = strategy.applyAll(failedAnnotations);
                for (ApplyStatus applyStatus : ApplyStatus.values()) {
                    statusMap.get((Object)applyStatus).addAll((Collection<ModelAnnotation>)recurStatusMap.get((Object)applyStatus));
                }
                break block7;
            }
            if (failedAnnotations.size() <= 0) break block7;
            for (ModelAnnotation failedAnnotation : failedAnnotations) {
                statusMap.get((Object)ApplyStatus.FAILED).add(failedAnnotation);
            }
        }
        return statusMap;
    }

    private Map<ApplyStatus, List<ModelAnnotation>> initStatusMap() {
        HashMap<ApplyStatus, List<ModelAnnotation>> statusMap = new HashMap<ApplyStatus, List<ModelAnnotation>>();
        for (ApplyStatus applyStatus : ApplyStatus.values()) {
            statusMap.put(applyStatus, new ArrayList());
        }
        return statusMap;
    }

    private static interface AnnotateStrategy {
        public boolean apply(ModelAnnotation var1) throws ModelerException;

        public Map<ApplyStatus, List<ModelAnnotation>> applyAll(ModelAnnotationGroup var1) throws ModelerException;

        public boolean isEmptyModel();
    }

    public static enum ApplyStatus {
        SUCCESS,
        FAILED,
        NULL_ANNOTATION;

    }
}

