/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.models.annotations;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerPerspective;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.models.annotations.AnnotationType;
import org.pentaho.agilebi.modeler.models.annotations.CreateDimensionKey;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotation;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotationGroup;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotationManager;
import org.pentaho.agilebi.modeler.models.annotations.ModelProperty;
import org.pentaho.agilebi.modeler.models.annotations.SharedDimensionImportStrategy;
import org.pentaho.agilebi.modeler.models.annotations.data.DataProvider;
import org.pentaho.agilebi.modeler.nodes.DimensionMetaData;
import org.pentaho.agilebi.modeler.nodes.DimensionMetaDataCollection;
import org.pentaho.agilebi.modeler.util.ISpoonModelerSource;
import org.pentaho.agilebi.modeler.util.ModelerWorkspaceHelper;
import org.pentaho.agilebi.modeler.util.TableModelerSource;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.IPhysicalModel;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.LogicalRelationship;
import org.pentaho.metadata.model.LogicalTable;
import org.pentaho.metadata.model.SqlPhysicalTable;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.persist.MetaStoreAttribute;
import org.w3c.dom.Document;

public class LinkDimension
extends AnnotationType {
    public static final String NAME_ID = "name";
    public static final String NAME_NAME = "Dimension Name";
    public static final int NAME_ORDER = 0;
    public static final String SHARED_DIMENSION_ID = "sharedDimension";
    public static final String SHARED_DIMENSION_NAME = "Shared Dimension";
    public static final int SHARED_DIMENSION_ORDER = 1;
    public static final String FIELD_ID = "field";
    public static final String FIELD_NAME = "Field Name";
    public static final int FIELD_ORDER = 2;
    @MetaStoreAttribute
    @ModelProperty(id="name", name="Dimension Name", order=0)
    private String name;
    @MetaStoreAttribute
    @ModelProperty(id="sharedDimension", name="Shared Dimension", order=1)
    private String sharedDimension;
    @MetaStoreAttribute
    @ModelProperty(id="field", name="Field Name", order=2, hideUI=true)
    private String field;
    private Map<ModelAnnotationGroup.ApplyStatus, List<ModelAnnotation>> sharedApplyStatus;

    @Override
    public boolean apply(ModelerWorkspace factWorkspace, IMetaStore metaStore) throws ModelerException {
        ModelAnnotationManager modelAnnotationManager = new ModelAnnotationManager(true);
        try {
            if (!modelAnnotationManager.containsGroup(this.getSharedDimension(), metaStore)) {
                return false;
            }
            this.assignFactTable(factWorkspace);
            ModelAnnotationGroup sharedAnnotations = modelAnnotationManager.readGroup(this.getSharedDimension(), metaStore);
            List<DataProvider> dataProviders = sharedAnnotations.getDataProviders();
            DataProvider dataProvider = this.locateDataProvider(dataProviders, factWorkspace, metaStore);
            if (dataProvider == null) {
                return false;
            }
            ModelerWorkspace dimensionWorkspace = this.autoModelSharedDimension(factWorkspace, dataProvider);
            this.sharedApplyStatus = sharedAnnotations.applyAnnotations(dimensionWorkspace, metaStore);
            if (this.sharedApplyStatus.get((Object)ModelAnnotationGroup.ApplyStatus.FAILED) != null && this.sharedApplyStatus.get((Object)ModelAnnotationGroup.ApplyStatus.FAILED).size() > 0) {
                return false;
            }
            String dimKey = this.locateDimensionKey(sharedAnnotations);
            if (Const.isEmpty((String)dimKey)) {
                return false;
            }
            this.removeAutoLevel(factWorkspace, this.locateLevel(factWorkspace, this.field));
            this.removeAutoMeasure(factWorkspace, this.field);
            this.moveDimensionToModel(dimensionWorkspace, factWorkspace, this.field, dimKey);
            factWorkspace.getWorkspaceHelper().populateDomain(factWorkspace);
            return true;
        }
        catch (KettlePluginException e) {
            throw new ModelerException(e);
        }
        catch (MetaStoreException e) {
            throw new ModelerException(e);
        }
    }

    private DataProvider locateDataProvider(List<DataProvider> dataProviders, ModelerWorkspace workspace, IMetaStore metaStore) throws MetaStoreException, KettlePluginException, ModelerException {
        ModelAnnotationManager manager = new ModelAnnotationManager(true);
        DatabaseMeta factDbMeta = ((ISpoonModelerSource)workspace.getModelSource()).getDatabaseMeta();
        for (DataProvider dataProvider : dataProviders) {
            DatabaseMeta sharedDbMeta = manager.loadDatabaseMeta(dataProvider.getDatabaseMetaNameRef(), metaStore);
            if (sharedDbMeta == null || !this.dbMetaEquals(factDbMeta, sharedDbMeta)) continue;
            return dataProvider;
        }
        return null;
    }

    private boolean dbMetaEquals(DatabaseMeta factDbMeta, DatabaseMeta sharedDbMeta) {
        return factDbMeta.getName() != null && factDbMeta.getName().equals(sharedDbMeta.getName()) && this.hostNameEquals(factDbMeta, sharedDbMeta) && this.dbNameEquals(factDbMeta, sharedDbMeta) && factDbMeta.getDriverClass() != null && factDbMeta.getDriverClass().equals(sharedDbMeta.getDriverClass());
    }

    private boolean hostNameEquals(DatabaseMeta factDbMeta, DatabaseMeta sharedDbMeta) {
        return factDbMeta.getHostname() != null && factDbMeta.environmentSubstitute(factDbMeta.getHostname()).equals(sharedDbMeta.getHostname()) || factDbMeta.getHostname() == null && sharedDbMeta.getHostname() == null;
    }

    private boolean dbNameEquals(DatabaseMeta factDbMeta, DatabaseMeta sharedDbMeta) {
        return factDbMeta.getDatabaseName() != null && factDbMeta.environmentSubstitute(factDbMeta.getDatabaseName()).equals(sharedDbMeta.getDatabaseName()) || factDbMeta.getDatabaseName() == null && sharedDbMeta.getDatabaseName() == null;
    }

    private void assignFactTable(ModelerWorkspace workspace) {
        List logicalTables = workspace.getLogicalModel(ModelerPerspective.ANALYSIS).getLogicalTables();
        ((LogicalTable)logicalTables.get(0)).getPhysicalTable().setProperty("FACT_TABLE", (Object)true);
    }

    private String locateDimensionKey(ModelAnnotationGroup modelAnnotations) {
        for (ModelAnnotation modelAnnotation : modelAnnotations) {
            if (!modelAnnotation.getType().equals((Object)ModelAnnotation.Type.CREATE_DIMENSION_KEY)) continue;
            return ((CreateDimensionKey)modelAnnotation.getAnnotation()).getField();
        }
        return null;
    }

    private void moveDimensionToModel(ModelerWorkspace dimensionWorkspace, ModelerWorkspace factWorkspace, String factKey, String dimKey) throws ModelerException {
        DimensionMetaData dimension = this.getLastDimension(dimensionWorkspace);
        dimension.setName(this.getName());
        this.removeExistingDimension(factWorkspace);
        factWorkspace.addDimension(dimension);
        LogicalTable dimTable = (LogicalTable)dimensionWorkspace.getLogicalModel(ModelerPerspective.ANALYSIS).getLogicalTables().get(0);
        LogicalTable factTable = (LogicalTable)factWorkspace.getLogicalModel(ModelerPerspective.ANALYSIS).getLogicalTables().get(0);
        LogicalModel logicalModel = factWorkspace.getLogicalModel(ModelerPerspective.ANALYSIS);
        logicalModel.addLogicalTable(dimTable);
        List physicalTables = ((IPhysicalModel)factWorkspace.getDomain().getPhysicalModels().get(0)).getPhysicalTables();
        physicalTables.add((SqlPhysicalTable)dimTable.getPhysicalTable());
        logicalModel.addLogicalRelationship(new LogicalRelationship(logicalModel, factTable, dimTable, this.locateLogicalColumn(factWorkspace, factKey), this.locateLogicalColumn(dimensionWorkspace, dimKey)));
    }

    private void removeExistingDimension(ModelerWorkspace factWorkspace) {
        DimensionMetaDataCollection dimensions = factWorkspace.getModel().getDimensions();
        for (int i = 0; i < dimensions.size(); ++i) {
            DimensionMetaData dimension = (DimensionMetaData)dimensions.get(i);
            if (!dimension.getName().equalsIgnoreCase(this.getName())) continue;
            dimensions.remove(i);
            return;
        }
    }

    private DimensionMetaData getLastDimension(ModelerWorkspace dimensionWorkspace) {
        DimensionMetaDataCollection dimensions = dimensionWorkspace.getModel().getDimensions();
        return (DimensionMetaData)dimensions.get(dimensions.size() - 1);
    }

    private ModelerWorkspace autoModelSharedDimension(ModelerWorkspace workspace, DataProvider dataProvider) throws MetaStoreException, KettlePluginException, ModelerException {
        DatabaseMeta dbMeta = ((ISpoonModelerSource)workspace.getModelSource()).getDatabaseMeta();
        TableModelerSource source = new TableModelerSource(dbMeta, dataProvider.getTableName(), dataProvider.getSchemaName());
        Domain domain = source.generateDomain(new SharedDimensionImportStrategy(dataProvider));
        ModelerWorkspace model = new ModelerWorkspace(new ModelerWorkspaceHelper(workspace.getWorkspaceHelper().getLocale()), workspace.getGeoContext());
        model.setModelSource(source);
        model.setDomain(domain);
        model.getWorkspaceHelper().autoModelFlat(model);
        return model;
    }

    @Override
    public boolean apply(Document schema) throws ModelerException {
        return false;
    }

    @Override
    public void validate() throws ModelerException {
        if (StringUtils.isBlank((String)this.getName())) {
            throw new ModelerException(BaseMessages.getString((Class)MSG_CLASS, (String)"Modeler.LinkDimension.validation.DIMENSION_NAME_REQUIRED", (String[])new String[0]));
        }
        if (StringUtils.isBlank((String)this.getSharedDimension())) {
            throw new ModelerException(BaseMessages.getString((Class)MSG_CLASS, (String)"Modeler.LinkDimension.validation.SHARED_DIMENSION_REQUIRED", (String[])new String[0]));
        }
    }

    @Override
    public ModelAnnotation.Type getType() {
        return ModelAnnotation.Type.LINK_DIMENSION;
    }

    @Override
    public String getSummary() {
        StringBuilder summary = new StringBuilder(BaseMessages.getString((Class)MSG_CLASS, (String)"Modeler.LinkDimension.Summary", (String[])new String[]{this.getName(), this.getSharedDimension()}));
        if (this.sharedApplyStatus != null) {
            this.appendSummaries(summary, ModelAnnotationGroup.ApplyStatus.FAILED, "ModelAnnotation.log.AnnotationFailure");
            this.appendSummaries(summary, ModelAnnotationGroup.ApplyStatus.SUCCESS, "ModelAnnotation.log.AnnotationSuccess");
        }
        return summary.toString();
    }

    private void appendSummaries(StringBuilder summary, ModelAnnotationGroup.ApplyStatus status, String msgKey) {
        for (ModelAnnotation modelAnnotation : this.sharedApplyStatus.get((Object)status)) {
            summary.append("\n    ");
            summary.append(BaseMessages.getString((Class)MSG_CLASS, (String)msgKey, (String[])new String[]{((AnnotationType)modelAnnotation.getAnnotation()).getSummary()}));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSharedDimension() {
        return this.sharedDimension;
    }

    public void setSharedDimension(String sharedDimension) {
        this.sharedDimension = sharedDimension;
    }

    @Override
    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }
}

