/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.models.annotations;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mondrian.olap.MondrianDef;
import org.apache.commons.lang.StringUtils;
import org.pentaho.agilebi.modeler.BaseModelerWorkspaceHelper;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerPerspective;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.models.annotations.AnnotationType;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotation;
import org.pentaho.agilebi.modeler.models.annotations.ModelProperty;
import org.pentaho.agilebi.modeler.models.annotations.util.MondrianSchemaHandler;
import org.pentaho.agilebi.modeler.nodes.MeasureMetaData;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.metadata.automodel.PhysicalTableImporter;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.LogicalTable;
import org.pentaho.metadata.model.concept.types.AggregationType;
import org.pentaho.metadata.util.MondrianModelExporter;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.persist.MetaStoreAttribute;
import org.w3c.dom.Document;

public class CreateMeasure
extends AnnotationType {
    private static final long serialVersionUID = -2487305952482463126L;
    public static final String NAME_ID = "name";
    public static final String NAME_NAME = "Measure Name";
    public static final int NAME_ORDER = 0;
    public static final String AGGREGATE_TYPE_ID = "aggregateType";
    public static final String AGGREGATE_TYPE_NAME = "Aggregation Type";
    public static final int AGGREGATE_TYPE_ORDER = 1;
    public static final String FORMAT_STRING_ID = "formatString";
    public static final String FORMAT_STRING_NAME = "Format String";
    public static final int FORMAT_STRING_ORDER = 2;
    public static final String DESCRIPTION_ID = "description";
    public static final String DESCRIPTION_NAME = "Description";
    public static final int DESCRIPTION_ORDER = 3;
    public static final String BUSINESS_GROUP_ID = "businessGroup";
    public static final String BUSINESS_GROUP_NAME = "Business Group";
    public static final int BUSINESS_GROUP_ORDER = 4;
    public static final String FIELD_ID = "field";
    public static final String FIELD_NAME = "Field Name";
    public static final int FIELD_ORDER = 5;
    public static final String LEVEL_ID = "level";
    public static final String LEVEL_NAME = "Level Name";
    public static final int LEVEL_ORDER = 6;
    public static final String MEASURE_ID = "measure";
    public static final String MEASURE_NAME = "Measure";
    public static final int MEASURE_ORDER = 7;
    public static final String CUBE_ID = "cube";
    public static final String CUBE_NAME = "Cube Name";
    public static final int CUBE_ORDER = 8;
    public static final String HIDDEN_ID = "hidden";
    public static final String HIDDEN_NAME = "Hidden";
    public static final int HIDDEN_ORDER = 9;
    @MetaStoreAttribute
    @ModelProperty(id="name", name="Measure Name", order=0)
    private String name;
    @MetaStoreAttribute
    @ModelProperty(id="aggregateType", name="Aggregation Type", order=1)
    private AggregationType aggregateType = AggregationType.SUM;
    @MetaStoreAttribute
    @ModelProperty(id="formatString", name="Format String", order=2)
    private String formatString;
    @MetaStoreAttribute
    @ModelProperty(id="description", name="Description", order=3)
    private String description;
    @MetaStoreAttribute
    @ModelProperty(id="field", name="Field Name", order=5, hideUI=true)
    private String field;
    @MetaStoreAttribute
    @ModelProperty(id="level", name="Level Name", order=6, hideUI=true)
    private String level;
    @MetaStoreAttribute
    @ModelProperty(id="measure", name="Measure", order=7, hideUI=true)
    private String measure;
    @MetaStoreAttribute
    @ModelProperty(id="cube", name="Cube Name", order=8, hideUI=true)
    private String cube;
    @MetaStoreAttribute
    private String businessGroup;
    @MetaStoreAttribute
    @ModelProperty(id="hidden", name="Hidden", order=9)
    private boolean hidden;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AggregationType getAggregateType() {
        return this.aggregateType;
    }

    public void setAggregateType(AggregationType aggregateType) {
        this.aggregateType = aggregateType;
    }

    public String getFormatString() {
        return this.formatString;
    }

    public void setFormatString(String formatString) {
        this.formatString = formatString;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getBusinessGroup() {
        return this.businessGroup;
    }

    public void setBusinessGroup(String businessGroup) {
        this.businessGroup = businessGroup;
    }

    @Override
    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getMeasure() {
        return this.measure;
    }

    public void setMeasure(String measure) {
        this.measure = measure;
    }

    public String getCube() {
        return this.cube;
    }

    public void setCube(String cube) {
        this.cube = cube;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public boolean apply(ModelerWorkspace workspace, IMetaStore metaStore) throws ModelerException {
        List logicalTables = workspace.getLogicalModel(ModelerPerspective.ANALYSIS).getLogicalTables();
        for (LogicalTable logicalTable : logicalTables) {
            List logicalColumns = logicalTable.getLogicalColumns();
            for (LogicalColumn logicalColumn : logicalColumns) {
                if (!this.columnMatches(workspace, this.resolveField(workspace), logicalColumn) && !this.columnMatches(workspace, PhysicalTableImporter.beautifyName((String)this.resolveField(workspace)), logicalColumn)) continue;
                String targetColumn = (String)logicalColumn.getPhysicalColumn().getProperty("target_column");
                MeasureMetaData measureMetaData = new MeasureMetaData(targetColumn, this.getFormatString(), this.getName(), workspace.getWorkspaceHelper().getLocale());
                LogicalColumn columnClone = (LogicalColumn)logicalColumn.clone();
                columnClone.setId(BaseModelerWorkspaceHelper.uniquify(columnClone.getId(), logicalColumns));
                measureMetaData.setLogicalColumn(columnClone);
                measureMetaData.setName(this.getName());
                measureMetaData.setDefaultAggregation(this.getAggregateType());
                measureMetaData.setHidden(this.isHidden());
                if (this.getDescription() != null) {
                    measureMetaData.setDescription(this.getDescription());
                }
                this.removeAutoMeasure(workspace, this.resolveField(workspace));
                this.removeMeasure(workspace, this.getName());
                workspace.getModel().getMeasures().add(measureMetaData);
                this.removeAutoLevel(workspace, this.locateLevel(workspace, this.resolveField(workspace)));
                workspace.getWorkspaceHelper().populateDomain(workspace);
                return true;
            }
        }
        throw new ModelerException("Unable to apply Create Measure annotation: Column not found");
    }

    private String resolveField(ModelerWorkspace workspace) throws ModelerException {
        String field = this.getField();
        if (StringUtils.isBlank((String)field)) {
            if (!StringUtils.isBlank((String)this.getLevel()) && !StringUtils.isBlank((String)this.getCube())) {
                field = this.resolveFieldFromLevel(workspace, this.getLevel(), this.getCube());
                this.setField(field);
            } else if (!StringUtils.isBlank((String)this.getMeasure())) {
                field = this.resolveFieldFromMeasure(workspace, this.getMeasure(), this.getCube());
                this.setField(field);
            } else {
                throw new ModelerException(BaseMessages.getString((String)"ModelAnnotation.resolveField.UNABLE_TO_FIND_FIELD"));
            }
        }
        return field;
    }

    private String resolveField(Document schema) throws ModelerException {
        String field = this.getField();
        if (StringUtils.isBlank((String)field)) {
            if (!StringUtils.isBlank((String)this.measure)) {
                field = this.resolveFieldFromMeasure(schema, this.getMeasure());
                this.setField(field);
            } else {
                throw new ModelerException(BaseMessages.getString((String)"ModelAnnotation.resolveField.UNABLE_TO_FIND_FIELD"));
            }
        }
        return field;
    }

    private boolean columnMatches(ModelerWorkspace workspace, String column, LogicalColumn logicalColumn) {
        return column.equalsIgnoreCase(logicalColumn.getName(workspace.getWorkspaceHelper().getLocale()));
    }

    @Override
    protected void removeAutoMeasure(ModelerWorkspace workspace, String column) {
        LogicalColumn logicalColumn = this.locateLogicalColumn(workspace, column);
        String locale = workspace.getWorkspaceHelper().getLocale();
        Iterator i$ = workspace.getModel().getMeasures().iterator();
        while (i$.hasNext()) {
            MeasureMetaData measure = (MeasureMetaData)i$.next();
            if (!this.measureNameEquals(column, measure) || !measure.getLogicalColumn().getPhysicalColumn().getName(locale).equals(logicalColumn.getPhysicalColumn().getName(locale)) || !measure.getDefaultAggregation().equals((Object)AggregationType.SUM)) continue;
            workspace.getModel().getMeasures().remove(measure);
            break;
        }
    }

    private boolean measureNameEquals(String column, MeasureMetaData measure) {
        return measure.getName().equalsIgnoreCase(column) || measure.getName().equalsIgnoreCase(PhysicalTableImporter.beautifyName((String)column));
    }

    private void removeMeasure(ModelerWorkspace workspace, String measureName) {
        Iterator i$ = workspace.getModel().getMeasures().iterator();
        while (i$.hasNext()) {
            MeasureMetaData measure = (MeasureMetaData)i$.next();
            if (!measure.getName().equals(measureName)) continue;
            workspace.getModel().getMeasures().remove(measure);
            break;
        }
    }

    @Override
    public boolean apply(Document doc) throws ModelerException {
        MondrianSchemaHandler mondrianSchemaHandler = new MondrianSchemaHandler(doc);
        MondrianDef.Measure measure = new MondrianDef.Measure();
        measure.aggregator = MondrianModelExporter.convertToMondrian((AggregationType)this.getAggregateType());
        measure.name = this.getName();
        measure.column = this.resolveField(doc);
        measure.formatString = this.formatString;
        mondrianSchemaHandler.addMeasure(null, measure);
        return true;
    }

    @Override
    public void populate(Map<String, Serializable> propertiesMap) {
        Serializable value;
        super.populate(propertiesMap);
        if (propertiesMap.containsKey(AGGREGATE_TYPE_ID) && (value = propertiesMap.get(AGGREGATE_TYPE_ID)) != null) {
            this.setAggregateType(AggregationType.valueOf((String)value.toString()));
        }
    }

    @Override
    public ModelAnnotation.Type getType() {
        return ModelAnnotation.Type.CREATE_MEASURE;
    }

    @Override
    public String getSummary() {
        if (this.getAggregateType() != null) {
            return BaseMessages.getString((Class)MSG_CLASS, (String)"Modeler.CreateMeasure.Summary", (String[])new String[]{this.getName(), this.getAggregateType().name()});
        }
        return BaseMessages.getString((Class)MSG_CLASS, (String)"Modeler.CreateMeasure.NoAggregateSummary", (String[])new String[]{this.getName()});
    }

    @Override
    public void validate() throws ModelerException {
        if (StringUtils.isBlank((String)this.getField()) && (StringUtils.isBlank((String)this.getLevel()) || StringUtils.isBlank((String)this.getCube())) && (StringUtils.isBlank((String)this.getMeasure()) || StringUtils.isBlank((String)this.getCube()))) {
            throw new ModelerException(BaseMessages.getString((Class)MSG_CLASS, (String)"ModelAnnotation.CreateMeasure.validation.FIELD_OR_LEVEL_NOT_PROVIDED", (String[])new String[0]));
        }
        if (StringUtils.isBlank((String)this.getName())) {
            throw new ModelerException(BaseMessages.getString((Class)MSG_CLASS, (String)"ModelAnnotation.CreateMeasure.validation.MEASURE_NAME_REQUIRED", (String[])new String[0]));
        }
    }
}

