/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler;

import java.util.Iterator;
import java.util.Map;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerPerspective;
import org.pentaho.agilebi.modeler.ModelerTreeHelper;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.nodes.AbstractMetaDataModelNode;
import org.pentaho.agilebi.modeler.nodes.AvailableField;
import org.pentaho.agilebi.modeler.nodes.CategoryMetaData;
import org.pentaho.agilebi.modeler.nodes.CategoryMetaDataCollection;
import org.pentaho.agilebi.modeler.nodes.FieldMetaData;
import org.pentaho.agilebi.modeler.nodes.RelationalModelNode;
import org.pentaho.agilebi.modeler.propforms.ModelerNodePropertiesForm;
import org.pentaho.metadata.model.LogicalTable;
import org.pentaho.ui.xul.containers.XulDeck;
import org.pentaho.ui.xul.dom.Document;
import org.pentaho.ui.xul.util.AbstractModelNode;

public class CategoryTreeHelper
extends ModelerTreeHelper {
    public CategoryTreeHelper() {
    }

    public CategoryTreeHelper(Map<Class<? extends ModelerNodePropertiesForm>, ModelerNodePropertiesForm> propertiesForms, XulDeck propsDeck, ModelerWorkspace workspace, Document document) {
        super(propertiesForms, propsDeck, workspace, document);
    }

    @Override
    public void removeField() {
        if (this.getSelectedTreeItem() instanceof CategoryMetaDataCollection || this.getSelectedTreeItem() instanceof RelationalModelNode || this.getSelectedTreeItem() == null) {
            return;
        }
        if (this.getSelectedTreeItem() instanceof CategoryMetaData) {
            CategoryMetaData cat = (CategoryMetaData)this.getSelectedTreeItem();
            Iterator i$ = cat.iterator();
            while (i$.hasNext()) {
                FieldMetaData field = (FieldMetaData)i$.next();
                this.removeLogicalColumnFromParentTable(field);
            }
        } else if (this.getSelectedTreeItem() instanceof FieldMetaData) {
            this.removeLogicalColumnFromParentTable((FieldMetaData)this.getSelectedTreeItem());
        }
        this.workspace.setRelationalModelIsChanging(true);
        ((AbstractModelNode)this.getSelectedTreeItem()).getParent().remove(this.getSelectedTreeItem());
        this.setTreeSelectionChanged(null);
        this.workspace.setRelationalModelIsChanging(false, true);
    }

    @Override
    public void addField(Object[] selectedFields) throws ModelerException {
        boolean prevChangeState = this.workspace.isModelChanging();
        try {
            this.workspace.setRelationalModelIsChanging(true);
            super.addField(selectedFields);
        }
        catch (ModelerException e) {
            throw e;
        }
        finally {
            this.workspace.setRelationalModelIsChanging(prevChangeState);
        }
    }

    private AbstractMetaDataModelNode addAvailableField(AvailableField availableField, Object targetParent) {
        FieldMetaData theNode = null;
        if (targetParent != null && targetParent instanceof CategoryMetaData) {
            theNode = this.workspace.createFieldForParentWithNode((CategoryMetaData)targetParent, availableField);
            CategoryMetaData theCategory = (CategoryMetaData)targetParent;
            theCategory.add(theNode);
        }
        if (theNode != null) {
            theNode.setParent((AbstractMetaDataModelNode)targetParent);
        }
        return theNode;
    }

    @Override
    public void clearTreeModel() {
        this.workspace.setRelationalModelIsChanging(true);
        for (LogicalTable table : this.workspace.getLogicalModel(ModelerPerspective.REPORTING).getLogicalTables()) {
            table.getLogicalColumns().clear();
        }
        this.workspace.getRelationalModel().getCategories().clear();
        this.workspace.setRelationalModelIsChanging(false, true);
    }

    @Override
    protected boolean isModelChanging() {
        return this.workspace.isModelChanging();
    }

    @Override
    protected void setModelIsChanging(boolean changing) {
        this.workspace.setRelationalModelIsChanging(changing);
    }
}

