/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.avg;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.common.inject.internal.Nullable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.avg.InternalAvg;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;

public class AvgAggregator
extends NumericMetricsAggregator.SingleValue {
    private final ValuesSource.Numeric valuesSource;
    private SortedNumericDoubleValues values;
    private LongArray counts;
    private DoubleArray sums;
    private ValueFormatter formatter;

    public AvgAggregator(String name, long estimatedBucketsCount, ValuesSource.Numeric valuesSource, @Nullable ValueFormatter formatter, AggregationContext context, Aggregator parent) {
        super(name, estimatedBucketsCount, context, parent);
        this.valuesSource = valuesSource;
        this.formatter = formatter;
        if (valuesSource != null) {
            long initialSize = estimatedBucketsCount < 2L ? 1L : estimatedBucketsCount;
            this.counts = this.bigArrays.newLongArray(initialSize, true);
            this.sums = this.bigArrays.newDoubleArray(initialSize, true);
        }
    }

    @Override
    public boolean shouldCollect() {
        return this.valuesSource != null;
    }

    @Override
    public void setNextReader(AtomicReaderContext reader) {
        this.values = this.valuesSource.doubleValues();
    }

    @Override
    public void collect(int doc, long owningBucketOrdinal) throws IOException {
        this.counts = this.bigArrays.grow(this.counts, owningBucketOrdinal + 1L);
        this.sums = this.bigArrays.grow(this.sums, owningBucketOrdinal + 1L);
        this.values.setDocument(doc);
        int valueCount = this.values.count();
        this.counts.increment(owningBucketOrdinal, valueCount);
        double sum = 0.0;
        for (int i = 0; i < valueCount; ++i) {
            sum += this.values.valueAt(i);
        }
        this.sums.increment(owningBucketOrdinal, sum);
    }

    @Override
    public double metric(long owningBucketOrd) {
        return this.valuesSource == null ? Double.NaN : this.sums.get(owningBucketOrd) / (double)this.counts.get(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        if (this.valuesSource == null || owningBucketOrdinal >= this.counts.size()) {
            return new InternalAvg(this.name, 0.0, 0L, this.formatter);
        }
        return new InternalAvg(this.name, this.sums.get(owningBucketOrdinal), this.counts.get(owningBucketOrdinal), this.formatter);
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalAvg(this.name, 0.0, 0L, this.formatter);
    }

    @Override
    public void doClose() {
        Releasables.close(this.counts, this.sums);
    }

    public static class Factory
    extends ValuesSourceAggregatorFactory.LeafOnly<ValuesSource.Numeric> {
        public Factory(String name, String type, ValuesSourceConfig<ValuesSource.Numeric> valuesSourceConfig) {
            super(name, type, valuesSourceConfig);
        }

        @Override
        protected Aggregator createUnmapped(AggregationContext aggregationContext, Aggregator parent) {
            return new AvgAggregator(this.name, 0L, null, this.config.formatter(), aggregationContext, parent);
        }

        @Override
        protected Aggregator create(ValuesSource.Numeric valuesSource, long expectedBucketsCount, AggregationContext aggregationContext, Aggregator parent) {
            return new AvgAggregator(this.name, expectedBucketsCount, valuesSource, this.config.formatter(), aggregationContext, parent);
        }
    }
}

