/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.IOException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;

public abstract class RestChannel {
    protected final RestRequest request;
    protected final boolean detailedErrorsEnabled;
    private BytesStreamOutput bytesOut;

    protected RestChannel(RestRequest request, boolean detailedErrorsEnabled) {
        this.request = request;
        this.detailedErrorsEnabled = detailedErrorsEnabled;
    }

    public XContentBuilder newBuilder() throws IOException {
        return this.newBuilder(this.request.hasContent() ? this.request.content() : null);
    }

    public XContentBuilder newBuilder(@Nullable BytesReference autoDetectSource) throws IOException {
        XContentType contentType = XContentType.fromRestContentType(this.request.param("format", this.request.header("Content-Type")));
        if (contentType == null && autoDetectSource != null) {
            contentType = XContentFactory.xContentType(autoDetectSource);
        }
        if (contentType == null) {
            contentType = XContentType.JSON;
        }
        XContentBuilder builder = new XContentBuilder(XContentFactory.xContent(contentType), this.bytesOutput());
        if (this.request.paramAsBoolean("pretty", false)) {
            builder.prettyPrint().lfAtEnd();
        }
        builder.humanReadable(this.request.paramAsBoolean("human", builder.humanReadable()));
        String casing = this.request.param("case");
        if (casing != null && "camelCase".equals(casing)) {
            builder.fieldCaseConversion(XContentBuilder.FieldCaseConversion.CAMELCASE);
        } else {
            builder.fieldCaseConversion(XContentBuilder.FieldCaseConversion.NONE);
        }
        return builder;
    }

    public final BytesStreamOutput bytesOutput() {
        if (this.bytesOut == null) {
            this.bytesOut = this.newBytesOutput();
        } else {
            this.bytesOut.reset();
        }
        return this.bytesOut;
    }

    protected BytesStreamOutput newBytesOutput() {
        return new BytesStreamOutput();
    }

    public RestRequest request() {
        return this.request;
    }

    public boolean detailedErrorsEnabled() {
        return this.detailedErrorsEnabled;
    }

    public abstract void sendResponse(RestResponse var1);
}

