/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.base.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.ReleasableBytesStreamOutput;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.netty.NettyUtils;
import org.elasticsearch.common.netty.ReleaseChannelFutureListener;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.buffer.ChannelBuffers;
import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.common.netty.channel.ChannelFuture;
import org.elasticsearch.common.netty.channel.ChannelFutureListener;
import org.elasticsearch.common.netty.handler.codec.http.Cookie;
import org.elasticsearch.common.netty.handler.codec.http.CookieDecoder;
import org.elasticsearch.common.netty.handler.codec.http.CookieEncoder;
import org.elasticsearch.common.netty.handler.codec.http.DefaultHttpResponse;
import org.elasticsearch.common.netty.handler.codec.http.HttpMethod;
import org.elasticsearch.common.netty.handler.codec.http.HttpRequest;
import org.elasticsearch.common.netty.handler.codec.http.HttpResponseStatus;
import org.elasticsearch.common.netty.handler.codec.http.HttpVersion;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.netty.NettyHttpRequest;
import org.elasticsearch.http.netty.NettyHttpServerTransport;
import org.elasticsearch.http.netty.pipelining.OrderedDownstreamChannelEvent;
import org.elasticsearch.http.netty.pipelining.OrderedUpstreamMessageEvent;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.support.RestUtils;

public class NettyHttpChannel
extends HttpChannel {
    private static final ChannelBuffer END_JSONP;
    private final NettyHttpServerTransport transport;
    private final Channel channel;
    private final HttpRequest nettyRequest;
    private OrderedUpstreamMessageEvent orderedUpstreamMessageEvent = null;
    private Pattern corsPattern;
    private static final HttpResponseStatus TOO_MANY_REQUESTS;

    public NettyHttpChannel(NettyHttpServerTransport transport, NettyHttpRequest request, Pattern corsPattern, boolean detailedErrorsEnabled) {
        super(request, detailedErrorsEnabled);
        this.transport = transport;
        this.channel = request.getChannel();
        this.nettyRequest = request.request();
        this.corsPattern = corsPattern;
    }

    public NettyHttpChannel(NettyHttpServerTransport transport, NettyHttpRequest request, Pattern corsPattern, OrderedUpstreamMessageEvent orderedUpstreamMessageEvent, boolean detailedErrorsEnabled) {
        this(transport, request, corsPattern, detailedErrorsEnabled);
        this.orderedUpstreamMessageEvent = orderedUpstreamMessageEvent;
    }

    @Override
    public BytesStreamOutput newBytesOutput() {
        return new ReleasableBytesStreamOutput(this.transport.bigArrays);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendResponse(RestResponse response) {
        Map<String, List<String>> customHeaders;
        String opaque;
        DefaultHttpResponse resp;
        boolean http10 = this.nettyRequest.getProtocolVersion().equals(HttpVersion.HTTP_1_0);
        boolean close = "close".equalsIgnoreCase(this.nettyRequest.headers().get("Connection")) || http10 && !"keep-alive".equalsIgnoreCase(this.nettyRequest.headers().get("Connection"));
        HttpResponseStatus status = this.getStatus(response.status());
        if (http10) {
            resp = new DefaultHttpResponse(HttpVersion.HTTP_1_0, status);
            if (!close) {
                resp.headers().add("Connection", "Keep-Alive");
            }
        } else {
            resp = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
        }
        if (RestUtils.isBrowser(this.nettyRequest.headers().get("User-Agent")) && this.transport.settings().getAsBoolean("http.cors.enabled", (Boolean)false).booleanValue()) {
            String originHeader = this.request.header("Origin");
            if (!Strings.isNullOrEmpty(originHeader)) {
                if (this.corsPattern == null) {
                    resp.headers().add("Access-Control-Allow-Origin", this.transport.settings().get("http.cors.allow-origin", "*"));
                } else {
                    resp.headers().add("Access-Control-Allow-Origin", this.corsPattern.matcher(originHeader).matches() ? originHeader : "null");
                }
            }
            if (this.nettyRequest.getMethod() == HttpMethod.OPTIONS) {
                resp.headers().add("Access-Control-Max-Age", this.transport.settings().getAsInt("http.cors.max-age", (Integer)1728000));
                resp.headers().add("Access-Control-Allow-Methods", this.transport.settings().get("http.cors.allow-methods", "OPTIONS, HEAD, GET, POST, PUT, DELETE"));
                resp.headers().add("Access-Control-Allow-Headers", this.transport.settings().get("http.cors.allow-headers", "X-Requested-With, Content-Type, Content-Length"));
            }
            if (this.transport.settings().getAsBoolean("http.cors.allow-credentials", (Boolean)false).booleanValue()) {
                resp.headers().add("Access-Control-Allow-Credentials", "true");
            }
        }
        if ((opaque = this.nettyRequest.headers().get("X-Opaque-Id")) != null) {
            resp.headers().add("X-Opaque-Id", opaque);
        }
        if ((customHeaders = response.getHeaders()) != null) {
            for (Map.Entry<String, List<String>> headerEntry : customHeaders.entrySet()) {
                for (String headerValue : headerEntry.getValue()) {
                    resp.headers().add(headerEntry.getKey(), headerValue);
                }
            }
        }
        BytesReference content = response.content();
        boolean addedReleaseListener = false;
        try {
            ChannelFuture future;
            CookieDecoder cookieDecoder;
            Set<Cookie> cookies;
            String cookieString;
            ChannelBuffer buffer = response.contentThreadSafe() ? content.toChannelBuffer() : content.copyBytesArray().toChannelBuffer();
            String callback = this.request.param("callback");
            if (callback != null) {
                BytesRef callbackBytes = new BytesRef((CharSequence)callback);
                callbackBytes.bytes[callbackBytes.length] = 40;
                ++callbackBytes.length;
                buffer = ChannelBuffers.wrappedBuffer(NettyUtils.DEFAULT_GATHERING, ChannelBuffers.wrappedBuffer(callbackBytes.bytes, callbackBytes.offset, callbackBytes.length), buffer, ChannelBuffers.wrappedBuffer(END_JSONP));
                resp.headers().add("Content-Type", "application/javascript");
            }
            resp.setContent(buffer);
            if (!resp.headers().contains("Content-Type")) {
                resp.headers().add("Content-Type", response.contentType());
            }
            if (!resp.headers().contains("Content-Length")) {
                resp.headers().add("Content-Length", String.valueOf(buffer.readableBytes()));
            }
            if (this.transport.resetCookies && (cookieString = this.nettyRequest.headers().get("Cookie")) != null && !(cookies = (cookieDecoder = new CookieDecoder()).decode(cookieString)).isEmpty()) {
                CookieEncoder cookieEncoder = new CookieEncoder(true);
                for (Cookie cookie : cookies) {
                    cookieEncoder.addCookie(cookie);
                }
                resp.headers().add("Set-Cookie", cookieEncoder.encode());
            }
            if (this.orderedUpstreamMessageEvent != null) {
                OrderedDownstreamChannelEvent downstreamChannelEvent = new OrderedDownstreamChannelEvent(this.orderedUpstreamMessageEvent, 0, true, resp);
                future = downstreamChannelEvent.getFuture();
                this.channel.getPipeline().sendDownstream(downstreamChannelEvent);
            } else {
                future = this.channel.write(resp);
            }
            if (response.contentThreadSafe() && content instanceof Releasable) {
                future.addListener(new ReleaseChannelFutureListener((Releasable)((Object)content)));
                addedReleaseListener = true;
            }
            if (close) {
                future.addListener(ChannelFutureListener.CLOSE);
            }
        }
        finally {
            if (!addedReleaseListener && content instanceof Releasable) {
                ((Releasable)((Object)content)).close();
            }
        }
    }

    private HttpResponseStatus getStatus(RestStatus status) {
        switch (status) {
            case CONTINUE: {
                return HttpResponseStatus.CONTINUE;
            }
            case SWITCHING_PROTOCOLS: {
                return HttpResponseStatus.SWITCHING_PROTOCOLS;
            }
            case OK: {
                return HttpResponseStatus.OK;
            }
            case CREATED: {
                return HttpResponseStatus.CREATED;
            }
            case ACCEPTED: {
                return HttpResponseStatus.ACCEPTED;
            }
            case NON_AUTHORITATIVE_INFORMATION: {
                return HttpResponseStatus.NON_AUTHORITATIVE_INFORMATION;
            }
            case NO_CONTENT: {
                return HttpResponseStatus.NO_CONTENT;
            }
            case RESET_CONTENT: {
                return HttpResponseStatus.RESET_CONTENT;
            }
            case PARTIAL_CONTENT: {
                return HttpResponseStatus.PARTIAL_CONTENT;
            }
            case MULTI_STATUS: {
                return HttpResponseStatus.INTERNAL_SERVER_ERROR;
            }
            case MULTIPLE_CHOICES: {
                return HttpResponseStatus.MULTIPLE_CHOICES;
            }
            case MOVED_PERMANENTLY: {
                return HttpResponseStatus.MOVED_PERMANENTLY;
            }
            case FOUND: {
                return HttpResponseStatus.FOUND;
            }
            case SEE_OTHER: {
                return HttpResponseStatus.SEE_OTHER;
            }
            case NOT_MODIFIED: {
                return HttpResponseStatus.NOT_MODIFIED;
            }
            case USE_PROXY: {
                return HttpResponseStatus.USE_PROXY;
            }
            case TEMPORARY_REDIRECT: {
                return HttpResponseStatus.TEMPORARY_REDIRECT;
            }
            case BAD_REQUEST: {
                return HttpResponseStatus.BAD_REQUEST;
            }
            case UNAUTHORIZED: {
                return HttpResponseStatus.UNAUTHORIZED;
            }
            case PAYMENT_REQUIRED: {
                return HttpResponseStatus.PAYMENT_REQUIRED;
            }
            case FORBIDDEN: {
                return HttpResponseStatus.FORBIDDEN;
            }
            case NOT_FOUND: {
                return HttpResponseStatus.NOT_FOUND;
            }
            case METHOD_NOT_ALLOWED: {
                return HttpResponseStatus.METHOD_NOT_ALLOWED;
            }
            case NOT_ACCEPTABLE: {
                return HttpResponseStatus.NOT_ACCEPTABLE;
            }
            case PROXY_AUTHENTICATION: {
                return HttpResponseStatus.PROXY_AUTHENTICATION_REQUIRED;
            }
            case REQUEST_TIMEOUT: {
                return HttpResponseStatus.REQUEST_TIMEOUT;
            }
            case CONFLICT: {
                return HttpResponseStatus.CONFLICT;
            }
            case GONE: {
                return HttpResponseStatus.GONE;
            }
            case LENGTH_REQUIRED: {
                return HttpResponseStatus.LENGTH_REQUIRED;
            }
            case PRECONDITION_FAILED: {
                return HttpResponseStatus.PRECONDITION_FAILED;
            }
            case REQUEST_ENTITY_TOO_LARGE: {
                return HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE;
            }
            case REQUEST_URI_TOO_LONG: {
                return HttpResponseStatus.REQUEST_URI_TOO_LONG;
            }
            case UNSUPPORTED_MEDIA_TYPE: {
                return HttpResponseStatus.UNSUPPORTED_MEDIA_TYPE;
            }
            case REQUESTED_RANGE_NOT_SATISFIED: {
                return HttpResponseStatus.REQUESTED_RANGE_NOT_SATISFIABLE;
            }
            case EXPECTATION_FAILED: {
                return HttpResponseStatus.EXPECTATION_FAILED;
            }
            case UNPROCESSABLE_ENTITY: {
                return HttpResponseStatus.BAD_REQUEST;
            }
            case LOCKED: {
                return HttpResponseStatus.BAD_REQUEST;
            }
            case FAILED_DEPENDENCY: {
                return HttpResponseStatus.BAD_REQUEST;
            }
            case TOO_MANY_REQUESTS: {
                return TOO_MANY_REQUESTS;
            }
            case INTERNAL_SERVER_ERROR: {
                return HttpResponseStatus.INTERNAL_SERVER_ERROR;
            }
            case NOT_IMPLEMENTED: {
                return HttpResponseStatus.NOT_IMPLEMENTED;
            }
            case BAD_GATEWAY: {
                return HttpResponseStatus.BAD_GATEWAY;
            }
            case SERVICE_UNAVAILABLE: {
                return HttpResponseStatus.SERVICE_UNAVAILABLE;
            }
            case GATEWAY_TIMEOUT: {
                return HttpResponseStatus.GATEWAY_TIMEOUT;
            }
            case HTTP_VERSION_NOT_SUPPORTED: {
                return HttpResponseStatus.HTTP_VERSION_NOT_SUPPORTED;
            }
        }
        return HttpResponseStatus.INTERNAL_SERVER_ERROR;
    }

    static {
        BytesRef U_END_JSONP = new BytesRef((CharSequence)");");
        END_JSONP = ChannelBuffers.wrappedBuffer(U_END_JSONP.bytes, U_END_JSONP.offset, U_END_JSONP.length);
        TOO_MANY_REQUESTS = new HttpResponseStatus(429, "Too Many Requests");
    }
}

