/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.spi.container.WebApplication;
import com.sun.jersey.spi.spring.container.servlet.SpringServlet;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MediaType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.core.system.objfac.spring.PentahoBeanScopeValidatorPostProcessor;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class JAXRSServlet
extends SpringServlet {
    private static final long serialVersionUID = 457538570048660945L;
    private static final Log logger = LogFactory.getLog(JAXRSServlet.class);
    public static final String MIME_TYPE = "mime-type";
    public static final String GET_HEADERS = "getHeaders";
    public static final String ACCEPT = "accept";
    public static final String GET = "GET";

    protected ConfigurableApplicationContext getContext() {
        return (ConfigurableApplicationContext)this.getAppContext();
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String mimeType;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("servicing request for resource " + request.getPathInfo()));
        }
        if (request.getMethod().equals(GET) && (mimeType = request.getParameter(MIME_TYPE)) != null) {
            final HttpServletRequest originalRequest = request;
            request = (HttpServletRequest)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{HttpServletRequest.class}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if (method.getName().equals(JAXRSServlet.GET_HEADERS) && args.length > 0 && args[0].equals(JAXRSServlet.ACCEPT)) {
                        return new Enumeration(){
                            boolean hasMore = true;

                            @Override
                            public boolean hasMoreElements() {
                                return this.hasMore;
                            }

                            public Object nextElement() {
                                this.hasMore = false;
                                return mimeType;
                            }
                        };
                    }
                    return method.invoke((Object)originalRequest, args);
                }
            });
        }
        super.service(request, response);
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        super.service(req, res);
    }

    protected void initiate(ResourceConfig rc, WebApplication wa) {
        if (logger.isDebugEnabled()) {
            rc.getFeatures().put("com.sun.jersey.config.feature.Trace", true);
            rc.getFeatures().put("com.sun.jersey.config.feature.TracePerRequest", true);
        }
        super.initiate(rc, wa);
        if (logger.isDebugEnabled()) {
            Map writers = wa.getMessageBodyWorkers().getWriters(MediaType.WILDCARD_TYPE);
            logger.debug((Object)("Writers: " + writers));
        }
    }

    protected ApplicationContext getAppContext() {
        XmlWebApplicationContext wac = new XmlWebApplicationContext(){

            protected Resource getResourceByPath(String path) {
                return new FileSystemResource(new File(path));
            }
        };
        wac.setServletContext(this.getServletContext());
        wac.setServletConfig(this.getServletConfig());
        wac.setNamespace(this.getServletName());
        String springFile = PentahoSystem.getApplicationContext().getSolutionPath("system" + File.separator + "pentahoServices.spring.xml");
        wac.setConfigLocations(new String[]{springFile});
        wac.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new PentahoBeanScopeValidatorPostProcessor());
        wac.refresh();
        return wac;
    }
}

