/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.filters;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Encoder;
import org.pentaho.platform.api.engine.IPentahoRequestContext;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository2.ClientRepositoryPaths;
import org.pentaho.platform.repository2.unified.jcr.JcrRepositoryFileUtils;
import org.pentaho.platform.util.messages.LocaleHelper;

public class PentahoWebContextFilter
implements Filter {
    public static final String WEB_CONTEXT_JS = "webcontext.js";
    static final String FILTER_APPLIED = "__pentaho_web_context_filter_applied";
    static final String initialComment = "/** webcontext.js is created by a PentahoWebContextFilter. This filter searches for an incoming URI having \"webcontext.js\" in it. If it finds that, it write CONTEXT_PATH and FULLY_QUALIFIED_SERVER_URL and it values from the servlet request to this js **/ \n\n\n";
    static final byte[] initialCommentBytes = "/** webcontext.js is created by a PentahoWebContextFilter. This filter searches for an incoming URI having \"webcontext.js\" in it. If it finds that, it write CONTEXT_PATH and FULLY_QUALIFIED_SERVER_URL and it values from the servlet request to this js **/ \n\n\n".getBytes();
    String fullyQualifiedUrl = null;
    String serverProtocol = null;
    private static final String JS = ".js";
    private static final String CSS = ".css";
    private static final String CONTEXT = "context";
    private static final String GLOBAL = "global";
    private static final byte[] REQUIRE_JS_CFG_START = "var requireCfg = {waitSeconds: 30, paths: {}, shim: {}, map: {\"*\": {}}, bundles: {}, config: {service: {}}, packages: []};\n".getBytes();
    private static final String REQUIRE_JS = "requirejs";
    private static final ThreadLocal<byte[]> THREAD_LOCAL_CONTEXT_PATH = new ThreadLocal();
    private static final ThreadLocal<byte[]> THREAD_LOCAL_REQUIRE_SCRIPT = new ThreadLocal();

    public void destroy() {
    }

    protected void close(OutputStream out) {
        try {
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String requestStr = httpRequest.getRequestURI();
        if (requestStr != null && requestStr.endsWith(WEB_CONTEXT_JS) && httpRequest.getAttribute(FILTER_APPLIED) == null) {
            httpRequest.setAttribute(FILTER_APPLIED, (Object)Boolean.TRUE);
            IPentahoRequestContext requestContext = PentahoRequestContextHolder.getRequestContext();
            String contextPath = requestContext.getContextPath();
            try {
                String basicAuthFlag;
                response.setContentType("text/javascript");
                ServletOutputStream out = response.getOutputStream();
                out.write(initialCommentBytes);
                byte[] contextPathBytes = THREAD_LOCAL_CONTEXT_PATH.get();
                byte[] requireScriptBytes = THREAD_LOCAL_REQUIRE_SCRIPT.get();
                if (contextPathBytes == null) {
                    String webContext = "var CONTEXT_PATH = '" + contextPath + "';\n\n";
                    contextPathBytes = webContext.getBytes();
                    THREAD_LOCAL_CONTEXT_PATH.set(contextPathBytes);
                    if (requireScriptBytes == null) {
                        String requireJsLocation = "content/common-ui/resources/web/require.js";
                        String requireJsConfigLocation = "content/common-ui/resources/web/require-cfg.js";
                        String requireScript = "document.write(\"<script type='text/javascript' src='" + contextPath + requireJsLocation + "'></scr\"+\"ipt>\");\n" + "document.write(\"<script type='text/javascript' src='" + contextPath + requireJsConfigLocation + "'></scr\"+\"ipt>\");\n";
                        requireScriptBytes = requireScript.getBytes();
                        THREAD_LOCAL_REQUIRE_SCRIPT.set(requireScriptBytes);
                    }
                }
                if ((basicAuthFlag = (String)httpRequest.getSession().getAttribute("BasicAuth")) != null && basicAuthFlag.equals("true")) {
                    out.write(("document.write(\"<script type='text/javascript' src='" + contextPath + "js/postAuth.js'></scr\"+\"ipt>\");\n").getBytes("UTF-8"));
                }
                out.write(contextPathBytes);
                out.write(this.fullyQualifiedUrl.getBytes());
                out.write(this.serverProtocol.getBytes());
                Locale effectiveLocale = LocaleHelper.getLocale();
                if (!StringUtils.isEmpty((String)request.getParameter("locale"))) {
                    effectiveLocale = new Locale(request.getParameter("locale"));
                }
                out.write(REQUIRE_JS_CFG_START);
                this.printResourcesForContext(REQUIRE_JS, (OutputStream)out, httpRequest, false);
                out.write(requireScriptBytes);
                this.printSessionName((OutputStream)out);
                this.printLocale(effectiveLocale, (OutputStream)out);
                this.printHomeFolder((OutputStream)out);
                this.printReservedChars((OutputStream)out);
                this.printReservedCharsDisplay((OutputStream)out);
                this.printReservedRegexPattern((OutputStream)out);
                boolean requireJsOnly = "true".equals(request.getParameter("requireJsOnly"));
                if (!requireJsOnly) {
                    this.printResourcesForContext(GLOBAL, (OutputStream)out, httpRequest, false);
                    String contextName = request.getParameter(CONTEXT);
                    boolean cssOnly = "true".equals(request.getParameter("cssOnly"));
                    if (StringUtils.isNotEmpty((String)contextName)) {
                        this.printResourcesForContext(contextName, (OutputStream)out, httpRequest, cssOnly);
                    }
                }
                this.addCustomInfo((OutputStream)out);
                out.close();
                return;
            }
            finally {
                httpRequest.removeAttribute(FILTER_APPLIED);
            }
        }
        chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
    }

    private void printHomeFolder(OutputStream out) throws IOException {
        StringBuilder sb = new StringBuilder("<!-- Providing home folder location for UI defaults -->\n");
        if (PentahoSessionHolder.getSession() != null) {
            String homePath = ClientRepositoryPaths.getUserHomeFolderPath((String)StringEscapeUtils.escapeJavaScript((String)PentahoSessionHolder.getSession().getName()));
            sb.append("var HOME_FOLDER = '" + homePath + "';\n");
        } else {
            sb.append("var HOME_FOLDER = null;\n");
        }
        out.write(sb.toString().getBytes());
    }

    private void printReservedChars(OutputStream out) throws IOException {
        StringBuilder sb = new StringBuilder();
        Iterator i$ = JcrRepositoryFileUtils.getReservedChars().iterator();
        while (i$.hasNext()) {
            char c = ((Character)i$.next()).charValue();
            sb.append(c);
        }
        String scriptLine = "var RESERVED_CHARS = \"" + StringEscapeUtils.escapeJavaScript((String)sb.toString()) + "\";\n";
        out.write(scriptLine.getBytes());
    }

    private void printReservedCharsDisplay(OutputStream out) throws IOException {
        List reservedCharacters = JcrRepositoryFileUtils.getReservedChars();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < reservedCharacters.size(); ++i) {
            if (((Character)reservedCharacters.get(i)).charValue() >= '\u0007' && ((Character)reservedCharacters.get(i)).charValue() <= '\r') {
                sb.append(StringEscapeUtils.escapeJava((String)("" + reservedCharacters.get(i))));
            } else {
                sb.append(reservedCharacters.get(i));
            }
            if (i + 1 >= reservedCharacters.size()) continue;
            sb.append(", ");
        }
        String scriptLine = "var RESERVED_CHARS_DISPLAY = \"" + StringEscapeUtils.escapeJavaScript((String)sb.toString()) + "\";\n";
        out.write(scriptLine.getBytes());
    }

    private void printReservedRegexPattern(OutputStream out) throws IOException {
        String scriptLine = "var RESERVED_CHARS_REGEX_PATTERN = /" + PentahoWebContextFilter.makeReservedCharPattern() + "/;\n";
        out.write(scriptLine.getBytes());
    }

    private static String makeReservedCharPattern() {
        StringBuilder buf = new StringBuilder();
        buf.append(".*[");
        for (Character ch : JcrRepositoryFileUtils.getReservedChars()) {
            buf.append(StringEscapeUtils.escapeJavaScript((String)ch.toString()));
        }
        buf.append("]+.*");
        return buf.toString();
    }

    private void printSessionName(OutputStream out) throws IOException {
        StringBuilder sb = new StringBuilder("<!-- Providing name for session -->\n");
        if (PentahoSessionHolder.getSession() == null) {
            sb.append("var SESSION_NAME = null;\n");
        } else {
            sb.append("var SESSION_NAME = '" + StringEscapeUtils.escapeJavaScript((String)PentahoSessionHolder.getSession().getName()) + "';\n");
        }
        out.write(sb.toString().getBytes());
    }

    private void printLocale(Locale effectiveLocale, OutputStream out) throws IOException {
        StringBuilder sb = new StringBuilder("<!-- Providing computed Locale for session -->\n").append("var SESSION_LOCALE = '" + effectiveLocale.toString() + "';\n").append("if(typeof(pen) != 'undefined' && pen.define){pen.define('Locale', {locale:'" + effectiveLocale.toString() + "'})};");
        out.write(sb.toString().getBytes());
    }

    private void printResourcesForContext(String contextName, OutputStream out, HttpServletRequest request, boolean printCssOnly) throws IOException {
        IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class);
        Encoder encoder = ESAPI.encoder();
        HttpServletRequest req = request;
        String reqStr = "";
        Map paramMap = req.getParameterMap();
        if (paramMap.size() > 0) {
            StringBuilder sb = new StringBuilder();
            Map.Entry me2 = null;
            int sep = 63;
            for (Map.Entry me2 : paramMap.entrySet()) {
                for (int i = 0; i < ((String[])me2.getValue()).length; ++i) {
                    sb.append((char)sep).append(encoder.encodeForJavaScript(((String)me2.getKey()).toString())).append("=").append(encoder.encodeForJavaScript(((String[])me2.getValue())[i]));
                }
                if (sep != 63) continue;
                sep = 38;
            }
            reqStr = sb.toString();
        }
        List externalResources = pluginManager.getExternalResourcesForContext(contextName);
        out.write(("<!-- Injecting web resources defined in by plugins as external-resources for: " + encoder.encodeForHTML(contextName) + "-->\n").getBytes());
        if (externalResources != null) {
            for (String res : externalResources) {
                if (res == null) continue;
                if (res.endsWith(JS) && !printCssOnly) {
                    out.write(("document.write(\"<script language='javascript' type='text/javascript' src='\"+CONTEXT_PATH + \"" + res.trim() + reqStr + "'></scr\"+\"ipt>\");\n").getBytes());
                    continue;
                }
                if (!res.endsWith(CSS)) continue;
                out.write(("document.write(\"<link rel='stylesheet' type='text/css' href='\"+CONTEXT_PATH + \"" + res.trim() + reqStr + "'/>\");\n").getBytes());
            }
        }
    }

    protected void addCustomInfo(OutputStream out) throws IOException {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String fullyQualifiedServerURL = PentahoSystem.getApplicationContext().getFullyQualifiedServerURL();
        if (!fullyQualifiedServerURL.endsWith("/")) {
            fullyQualifiedServerURL = fullyQualifiedServerURL + "/";
        }
        String serverProtocolValue = fullyQualifiedServerURL.startsWith("http") ? fullyQualifiedServerURL.substring(0, fullyQualifiedServerURL.indexOf(":")) : "http";
        this.fullyQualifiedUrl = "var FULL_QUALIFIED_URL = '" + fullyQualifiedServerURL + "';\n\n";
        this.serverProtocol = "var SERVER_PROTOCOL = '" + serverProtocolValue + "';\n\n";
    }
}

