/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.context;

import java.io.File;
import java.io.FileOutputStream;
import java.text.MessageFormat;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.platform.web.http.PentahoHttpSessionHelper;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.web.context.support.XmlWebApplicationContext;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PentahoSolutionSpringApplicationContext
extends XmlWebApplicationContext {
    private static final String DEFAULT_NAMESPASE = "ns";
    private static final String SYSTEM_FOLDER = "system";
    private static final String DEFAULT_SPRING_XML = "pentaho-spring-beans.xml";
    private static final String IMPORT_TAG = "import";
    private static final String RESOURCE_ATTR = "resource";
    private static final String RESOURCE = "importExport.xml";
    private static final String IMPORT_COMMENT = "Import \"{0}\" was added by \"{1}\" class automatically";
    private static final XPathFactory XPATH_FACTORY = XPathFactory.newInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Resource getResourceByPath(String path) {
        Resource resource = null;
        String solutionPath = PentahoHttpSessionHelper.getSolutionPath(this.getServletContext());
        if (solutionPath != null) {
            File file = new File(solutionPath + File.separator + SYSTEM_FOLDER + File.separator + path);
            resource = new FileSystemResource(file);
        } else {
            resource = super.getResourceByPath(path);
        }
        KettleClientEnvironment.ClientType clientType = null;
        if (KettleClientEnvironment.isInitialized() && KettleClientEnvironment.getInstance() != null) {
            clientType = KettleClientEnvironment.getInstance().getClient();
        }
        if (path.toLowerCase().endsWith(DEFAULT_SPRING_XML) && (clientType == null || !clientType.equals((Object)KettleClientEnvironment.ClientType.SPOON))) {
            try {
                DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
                dFactory.setNamespaceAware(true);
                DocumentBuilder dBuilder = dFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(resource.getInputStream());
                Element node = doc.getDocumentElement();
                NodeList nodes = (NodeList)this.evaluateXPath(node, MessageFormat.format("./{0}:{1}[@{2}=''{3}'']", DEFAULT_NAMESPASE, IMPORT_TAG, RESOURCE_ATTR, RESOURCE), XPathConstants.NODESET);
                if (nodes.getLength() > 0) {
                    return resource;
                }
                Element importEl = doc.createElementNS(node.getNamespaceURI(), IMPORT_TAG);
                importEl.setAttribute(RESOURCE_ATTR, RESOURCE);
                Comment comment = doc.createComment(MessageFormat.format(IMPORT_COMMENT, RESOURCE, ((Object)((Object)this)).getClass().getSimpleName()));
                this.addLineBreak(node);
                node.appendChild(comment);
                this.addLineBreak(node);
                node.appendChild(importEl);
                this.addLineBreak(node);
                TransformerFactory tFactory = TransformerFactory.newInstance();
                Transformer transformer = tFactory.newTransformer();
                DOMSource source = new DOMSource(doc);
                FileOutputStream out = new FileOutputStream(resource.getFile());
                try {
                    StreamResult result = new StreamResult(out);
                    transformer.transform(source, result);
                }
                finally {
                    out.flush();
                    out.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return resource;
    }

    private void addLineBreak(Node node) {
        node.appendChild(node.getOwnerDocument().createTextNode("\n"));
    }

    private <T> T evaluateXPath(Node node, String exp, QName res) throws XPathExpressionException {
        XPath xpath = XPATH_FACTORY.newXPath();
        xpath.setNamespaceContext(new DefNamespaceContext(node.getNamespaceURI()));
        return (T)xpath.compile(exp).evaluate(node, res);
    }

    private static class DefNamespaceContext
    implements NamespaceContext {
        String defaultNS;

        public DefNamespaceContext(String defaultNS) {
            this.defaultNS = defaultNS;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (PentahoSolutionSpringApplicationContext.DEFAULT_NAMESPASE.equals(prefix)) {
                return this.defaultNS;
            }
            return null;
        }

        @Override
        public String getPrefix(String namespaceURI) {
            return null;
        }

        public Iterator<?> getPrefixes(String namespaceURI) {
            return null;
        }
    }
}

