/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources.services;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.security.userroledao.IPentahoRole;
import org.pentaho.platform.api.engine.security.userroledao.IPentahoUser;
import org.pentaho.platform.api.engine.security.userroledao.IUserRoleDao;
import org.pentaho.platform.api.engine.security.userroledao.NotFoundException;
import org.pentaho.platform.api.engine.security.userroledao.UncategorizedUserRoleDaoException;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.core.system.TenantUtils;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.repository2.userroledao.jackrabbit.security.DefaultPentahoPasswordEncoder;
import org.pentaho.platform.security.policy.rolebased.IRoleAuthorizationPolicyRoleBindingDao;
import org.pentaho.platform.security.policy.rolebased.RoleBindingStruct;
import org.pentaho.platform.web.http.api.resources.LocalizedLogicalRoleName;
import org.pentaho.platform.web.http.api.resources.LogicalRoleAssignment;
import org.pentaho.platform.web.http.api.resources.LogicalRoleAssignments;
import org.pentaho.platform.web.http.api.resources.RoleListWrapper;
import org.pentaho.platform.web.http.api.resources.SystemRolesMap;
import org.pentaho.platform.web.http.api.resources.User;
import org.pentaho.platform.web.http.api.resources.UserListWrapper;
import org.pentaho.platform.web.http.api.resources.services.FileService;

public class UserRoleDaoService {
    private IUserRoleDao roleDao;
    private IAuthorizationPolicy policy;
    private IRoleAuthorizationPolicyRoleBindingDao roleBindingDao;

    public UserListWrapper getUsers() throws Exception {
        return new UserListWrapper(this.getRoleDao().getUsers());
    }

    public RoleListWrapper getRolesForUser(String user) throws UncategorizedUserRoleDaoException {
        ITenant tenant = TenantUtils.getCurrentTenant();
        return new RoleListWrapper(this.getRoleDao().getUserRoles(tenant, user));
    }

    public void assignRolesToUser(String userName, String roleNames) throws NotFoundException, UncategorizedUserRoleDaoException, SecurityException {
        ITenant tenant;
        HashSet<String> assignedRoles;
        if (this.canAdminister()) {
            StringTokenizer tokenizer = new StringTokenizer(roleNames, "\t");
            assignedRoles = new HashSet<String>();
            tenant = TenantUtils.getCurrentTenant();
            for (IPentahoRole pentahoRole : this.getRoleDao().getUserRoles(tenant, userName)) {
                assignedRoles.add(pentahoRole.getName());
            }
            while (tokenizer.hasMoreTokens()) {
                assignedRoles.add(tokenizer.nextToken());
            }
        } else {
            throw new SecurityException();
        }
        this.getRoleDao().setUserRoles(tenant, userName, assignedRoles.toArray(new String[assignedRoles.size()]));
    }

    public void removeRolesFromUser(String userName, String roleNames) throws NotFoundException, UncategorizedUserRoleDaoException, SecurityException {
        ITenant tenant;
        HashSet<String> assignedRoles;
        if (this.canAdminister()) {
            StringTokenizer tokenizer = new StringTokenizer(roleNames, "\t");
            assignedRoles = new HashSet<String>();
            tenant = TenantUtils.getCurrentTenant();
            for (IPentahoRole pentahoRole : this.getRoleDao().getUserRoles(tenant, userName)) {
                assignedRoles.add(pentahoRole.getName());
            }
            while (tokenizer.hasMoreTokens()) {
                assignedRoles.remove(tokenizer.nextToken());
            }
        } else {
            throw new SecurityException();
        }
        this.getRoleDao().setUserRoles(tenant, userName, assignedRoles.toArray(new String[assignedRoles.size()]));
    }

    public void createRole(String roleName) throws Exception {
        if (this.canAdminister()) {
            if (!this.strNotEmpty(roleName)) {
                throw new ValidationFailedException();
            }
        } else {
            throw new SecurityException();
        }
        IUserRoleDao roleDao = (IUserRoleDao)PentahoSystem.get(IUserRoleDao.class, (String)"userRoleDaoProxy", (IPentahoSession)PentahoSessionHolder.getSession());
        roleDao.createRole(null, roleName, "", new String[0]);
    }

    public RoleListWrapper getRoles() throws UncategorizedUserRoleDaoException {
        return new RoleListWrapper(this.getRoleDao().getRoles());
    }

    public UserListWrapper getRoleMembers(String roleName) throws UncategorizedUserRoleDaoException, SecurityException {
        if (this.canAdminister()) {
            return new UserListWrapper(this.getRoleDao().getRoleMembers(TenantUtils.getCurrentTenant(), roleName));
        }
        throw new SecurityException();
    }

    private boolean containsReservedChars(String username) {
        StringBuffer reservedChars = new FileService().doGetReservedChars();
        return StringUtils.containsAny((CharSequence)username, (CharSequence)reservedChars);
    }

    private boolean strNotEmpty(String str) {
        return str != null && str.length() > 0;
    }

    private boolean userValid(User user) {
        String name = user.getUserName();
        String pass = user.getPassword();
        boolean nameValid = this.strNotEmpty(name) && !this.containsReservedChars(name);
        boolean passValid = this.strNotEmpty(pass);
        return nameValid && passValid;
    }

    private String decode(String toDecode) {
        try {
            return URLDecoder.decode(toDecode.replace("+", "%2B"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return toDecode;
        }
    }

    public void createUser(User user) throws Exception {
        if (this.canAdminister()) {
            if (!this.userValid(user)) {
                throw new ValidationFailedException();
            }
        } else {
            throw new SecurityException();
        }
        IUserRoleDao roleDao = (IUserRoleDao)PentahoSystem.get(IUserRoleDao.class, (String)"userRoleDaoProxy", (IPentahoSession)PentahoSessionHolder.getSession());
        roleDao.createUser(null, this.decode(user.getUserName()), this.decode(user.getPassword()), "", new String[0]);
    }

    private boolean inputValid(String userName, String newPass, String oldPass) {
        boolean userNameValid = userName != null && userName.length() > 0;
        boolean newPassValid = newPass != null && newPass.length() > 0;
        boolean oldPassValid = oldPass != null && oldPass.length() > 0;
        return userNameValid && newPassValid && oldPassValid;
    }

    private boolean credentialValid(IPentahoUser pentahoUser, String oldPass) {
        if (pentahoUser != null) {
            DefaultPentahoPasswordEncoder encoder = new DefaultPentahoPasswordEncoder();
            return encoder.isPasswordValid(pentahoUser.getPassword(), oldPass, null);
        }
        return false;
    }

    public void changeUserPassword(final String userName, final String newPass, String oldPass) throws Exception {
        IUserRoleDao roleDao;
        if (this.inputValid(userName, newPass, oldPass)) {
            roleDao = (IUserRoleDao)PentahoSystem.get(IUserRoleDao.class, (String)"userRoleDaoProxy", (IPentahoSession)PentahoSessionHolder.getSession());
            IPentahoUser pentahoUser = roleDao.getUser(null, userName);
            if (!this.credentialValid(pentahoUser, oldPass)) {
                throw new SecurityException();
            }
        } else {
            throw new ValidationFailedException();
        }
        SecurityHelper.getInstance().runAsSystem((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                roleDao.setPassword(null, userName, newPass);
                return null;
            }
        });
    }

    public void deleteUsers(String userNames) throws NotFoundException, UncategorizedUserRoleDaoException, SecurityException {
        if (this.canAdminister()) {
            StringTokenizer tokenizer = new StringTokenizer(userNames, "\t");
            while (tokenizer.hasMoreTokens()) {
                IPentahoUser user = this.getRoleDao().getUser(null, tokenizer.nextToken());
                if (user == null) continue;
                this.getRoleDao().deleteUser(user);
            }
        } else {
            throw new SecurityException();
        }
    }

    public void deleteRoles(String roleNames) throws SecurityException, UncategorizedUserRoleDaoException {
        if (this.canAdminister()) {
            StringTokenizer tokenizer = new StringTokenizer(roleNames, "\t");
            while (tokenizer.hasMoreTokens()) {
                IPentahoRole role = this.getRoleDao().getRole(null, tokenizer.nextToken());
                if (role == null) continue;
                this.getRoleDao().deleteRole(role);
            }
        } else {
            throw new SecurityException();
        }
    }

    public SystemRolesMap getRoleBindingStruct(String locale) throws SecurityException {
        if (this.canAdminister()) {
            RoleBindingStruct roleBindingStruct = this.getRoleBindingDao().getRoleBindingStruct(locale);
            SystemRolesMap systemRolesMap = new SystemRolesMap();
            for (Map.Entry localalizeNameEntry : roleBindingStruct.logicalRoleNameMap.entrySet()) {
                systemRolesMap.getLocalizedRoleNames().add(new LocalizedLogicalRoleName((String)localalizeNameEntry.getKey(), (String)localalizeNameEntry.getValue()));
            }
            for (Map.Entry logicalRoleAssignments : roleBindingStruct.bindingMap.entrySet()) {
                systemRolesMap.getAssignments().add(new LogicalRoleAssignment((String)logicalRoleAssignments.getKey(), (List)logicalRoleAssignments.getValue(), roleBindingStruct.immutableRoles.contains(logicalRoleAssignments.getKey())));
            }
            return systemRolesMap;
        }
        throw new SecurityException();
    }

    public void setLogicalRoles(LogicalRoleAssignments roleAssignments) throws SecurityException {
        if (this.canAdminister()) {
            for (LogicalRoleAssignment roleAssignment : roleAssignments.getAssignments()) {
                this.getRoleBindingDao().setRoleBindings(roleAssignment.getRoleName(), roleAssignment.getLogicalRoles());
            }
        } else {
            throw new SecurityException();
        }
    }

    public void updatePassword(User user) throws SecurityException {
        if (this.canAdminister()) {
            String userName = this.decode(user.getUserName());
            String password = this.decode(user.getPassword());
            IUserRoleDao roleDao = (IUserRoleDao)PentahoSystem.get(IUserRoleDao.class, (String)"userRoleDaoProxy", (IPentahoSession)PentahoSessionHolder.getSession());
            IPentahoUser puser = roleDao.getUser(null, userName);
            if (puser != null) {
                roleDao.setPassword(null, userName, password);
            }
        } else {
            throw new SecurityException();
        }
    }

    private boolean canAdminister() {
        return this.getPolicy().isAllowed("org.pentaho.repository.read") && this.getPolicy().isAllowed("org.pentaho.repository.create") && this.getPolicy().isAllowed("org.pentaho.security.administerSecurity");
    }

    private IRoleAuthorizationPolicyRoleBindingDao getRoleBindingDao() {
        if (this.roleBindingDao == null) {
            this.roleBindingDao = (IRoleAuthorizationPolicyRoleBindingDao)PentahoSystem.get(IRoleAuthorizationPolicyRoleBindingDao.class);
        }
        return this.roleBindingDao;
    }

    private IAuthorizationPolicy getPolicy() {
        if (this.policy == null) {
            this.policy = (IAuthorizationPolicy)PentahoSystem.get(IAuthorizationPolicy.class);
        }
        return this.policy;
    }

    private IUserRoleDao getRoleDao() {
        if (this.roleDao == null) {
            this.roleDao = (IUserRoleDao)PentahoSystem.get(IUserRoleDao.class);
        }
        return this.roleDao;
    }

    public static class ValidationFailedException
    extends Exception {
    }
}

