/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources;

import java.util.ArrayList;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.codehaus.enunciate.Facet;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.usersettings.IUserSettingService;
import org.pentaho.platform.api.usersettings.pojo.IUserSetting;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.web.http.api.resources.AbstractJaxRSResource;
import org.pentaho.platform.web.http.api.resources.Setting;

@Path(value="/user-settings")
@Facet(name="Unsupported")
public class UserSettingsResource
extends AbstractJaxRSResource {
    private IPentahoSession getPentahoSession() {
        return PentahoSessionHolder.getSession();
    }

    @GET
    @Path(value="/list")
    @Produces(value={"application/json", "application/xml"})
    @Facet(name="Unsupported")
    public ArrayList<Setting> getUserSettings() {
        try {
            IUserSettingService settingsService = (IUserSettingService)PentahoSystem.get(IUserSettingService.class, (IPentahoSession)this.getPentahoSession());
            ArrayList userSettings = (ArrayList)settingsService.getUserSettings();
            ArrayList<Setting> settings = new ArrayList<Setting>();
            for (IUserSetting userSetting : userSettings) {
                settings.add(new Setting(userSetting.getSettingName(), userSetting.getSettingValue()));
            }
            return settings;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @GET
    @Path(value="{setting : .+}")
    @Facet(name="Unsupported")
    public Response getUserSetting(@PathParam(value="setting") String setting) {
        IUserSettingService settingsService = (IUserSettingService)PentahoSystem.get(IUserSettingService.class, (IPentahoSession)this.getPentahoSession());
        IUserSetting userSetting = settingsService.getUserSetting(setting, null);
        return Response.ok((Object)(userSetting != null ? userSetting.getSettingValue() : null)).build();
    }

    @POST
    @Path(value="{setting : .+}")
    @Facet(name="Unsupported")
    public Response setUserSetting(@PathParam(value="setting") String setting, String settingValue) {
        IUserSettingService settingsService = (IUserSettingService)PentahoSystem.get(IUserSettingService.class, (IPentahoSession)this.getPentahoSession());
        settingValue = settingValue.replaceAll("&", "&amp;").replaceAll("\"", "&quot;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        settingsService.setUserSetting(setting, settingValue);
        return Response.ok((Object)settingValue).build();
    }
}

